/* 
**  mod_layout.h -- Common defines.
**  $Revision: 1.1.1.1 $
*/

#include "httpd.h"
#include "http_config.h"
#include "http_protocol.h"
#include "http_log.h"
#include "http_request.h"
#include "ap_config.h"
#include "apr_buckets.h"
#include "apr_compat.h"
#include "apr_strings.h"
#include "apr_lib.h"
#include "apr_tables.h"
#include "apr_fnmatch.h"
#include "util_filter.h"
#include <string.h>
#include "version.h"
#include "directives.h"
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>


#define BUFFER_LENGTH 1024

#define UNSET (-1)
#define OFF (0)
#define ON (1)
#define isOff(a) ((a == ON) ? 0 : 1 )
#define isOn(a) ((a == ON) ? 1 : 0 )
/* Yeah, I write perl, got a problem with that? */
#define unless(a) if(!(a))

/* layout states */
#define LAYOUT (0)
#define HTTP (1)
#define HEADER (2)
#define ORIGIN (3)
#define FOOTER (4)

/* layout ? */
#define APPEND (1)
#define REPLACE (2)
#define PREPEND (3)

#define WATCHPOINT printf("WATCHPOINT %s %d\n", __FILE__, __LINE__);
#define AWATCHPOINT ap_rprintf(r, "WATCHPOINT %s %d\n", __FILE__, __LINE__);
#define LAYOUT_EXPORT(type)    type

#define LAYOUT_CACHE "/tmp"
#define LAYOUT_BEGINTAG "<body*>"
#define LAYOUT_ENDTAG "</body>"
#define LAYOUT_TIMEFORMAT "%A, %d-%b-%Y %H:%M:%S %Z"

typedef struct {
	int type;									/* If it is static, file, dynamic */
	int kind;									/* Header, Footer or random layout */
	int append;								/* Either APPEND, REPLACE, or PREPEND */
	const char *string;				/* Whatever the layout is */
	const char *comment;			/* The comment that is displayed if comments are on */
	const char *pattern;			/* The pattern we match against */
} layout_string;

typedef struct {
	size_t size;
	char *file;
} mmap_data;

typedef struct {
	int http_header;
	int header;
	int footer;
	int length;
	int pid;
	int http;
	int origin;
	int merge;
	const char *type;
	const char *mime;
  ap_filter_t *f; 
	apr_bucket_brigade *b;
} layout_request;

typedef struct {
	int proxy;
	int glob;
	apr_array_header_t *layouts;
	int header_enabled;
	int footer_enabled;
	int pattern_enabled;
	int display_origin;
	apr_table_t *override;
	apr_table_t *override_uri;
	int async_post;
	const char *async_cache;
	int http_header_enabled;
	int comment;
	/* These next three variables change with each request */
	char *http_header;
	const char *time_format;
	apr_table_t *types;
	apr_table_t *uris_ignore;
	apr_table_t *uris_ignore_header;
	apr_table_t *uris_ignore_http_header;
	apr_table_t *uris_ignore_footer;
	apr_table_t *tag_ignore;
	apr_table_t *tag_ignore_footer;
	apr_table_t *tag_ignore_header;
	int append_header;
	int append_footer;
	int cache_needed;
	int merge;
	int notes;
	int replace_tags;
	const char *begin_tag;
	const char *end_tag;
	const char *dir;
	int layout_html_handler;
} layout_conf;

typedef struct layout_filter_struct {
	apr_bucket_brigade *b;
	const char *output;
} layout_filter_struct;

module AP_MODULE_DECLARE_DATA layout_module;

#include "proto.h"
