/********************************************************************/
/*                                                                  */
/*            L   I  QQ  U U I DD    W   W  A  RR    555            */
/*            L   I Q  Q U U I D D   W   W A A R R   5              */
/*            L   I Q  Q U U I D D   W W W AAA RR    55             */
/*            L   I Q Q  U U I D D   WW WW A A R R     5            */
/*            LLL I  Q Q  U  I DD    W   W A A R R   55             */
/*                                                                  */
/*                             b                                    */
/*                             bb  y y                              */
/*                             b b yyy                              */
/*                             bb    y                              */
/*                                 yy                               */
/*                                                                  */
/*                     U U       FFF  O   O  TTT                    */
/*                     U U       F   O O O O  T                     */
/*                     U U TIRET FF  O O O O  T                     */
/*                     U U       F   O O O O  T                     */
/*                      U        F    O   O   T                     */
/*                                                                  */
/********************************************************************/

/*****************************************************************************/
/* Liquid War is a unique multiplayer wargame                                */
/* Copyright (C) 1998-2002 Christian Mauduit                                 */
/*                                                                           */
/* This program is free software; you can redistribute it and/or modify      */
/* it under the terms of the GNU General Public License as published by      */
/* the Free Software Foundation; either version 2 of the License, or         */
/* (at your option) any later version.                                       */
/*                                                                           */
/* This program is distributed in the hope that it will be useful,           */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of            */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             */
/* GNU General Public License for more details.                              */
/*                                                                           */
/* You should have received a copy of the GNU General Public License         */
/* along with this program; if not, write to the Free Software               */
/* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA */
/*                                                                           */
/* Liquid War homepage : http://www.ufoot.org/liquidwar                      */
/* Contact author      : ufoot@ufoot.org                                     */
/*****************************************************************************/

/********************************************************************/
/* nom           : gfxmode.c                                        */
/* contenu       : gestion des modes graphiques                     */
/* date de modif : 3 mai 98                                         */
/********************************************************************/

/*==================================================================*/
/* includes                                                         */
/*==================================================================*/

#include <allegro.h>

#include "base.h"
#include "disk.h"
#include "log.h"
#include "gfxmode.h"
#include "startup.h"
#include "init.h"

/*==================================================================*/
/* variables globales                                               */
/*==================================================================*/

#ifdef ALLEGRO_DOS
int GFX_MODE_W[5]={320,360,640,800,1024};
int GFX_MODE_H[5]={240,240,480,600,768};
#endif

#ifdef ALLEGRO_WINDOWS
int GFX_MODE_W[5]={320,512,640,800,1024};
int GFX_MODE_H[5]={240,384,480,600,768};
#endif

#ifdef ALLEGRO_UNIX
int GFX_MODE_W[5]={320,512,640,800,1024};
int GFX_MODE_H[5]={240,384,480,600,768};
#endif

/*==================================================================*/
/* fonctions                                                        */
/*==================================================================*/

/*------------------------------------------------------------------*/
int need_to_change_mode(int res1,int res2,int flip){
  if (res1==res2 && !flip)
    return 0;
  else
    return !0;
}

/*------------------------------------------------------------------*/
int set_resolution (int res, int flip, int fullscreen)
{
  int ret=1;
  int num_try;
  int nb_try;

#ifdef ALLEGRO_DOS
  static int GFX_MODE_TYPE_FULLSCREEN[]={GFX_MODEX,
					 GFX_MODEX,
					 GFX_VESA2L,
					 GFX_VESA2L,
					 GFX_VESA2L};
  static int GFX_MODE_TYPE_WINDOWED[]={GFX_MODEX,
				       GFX_MODEX,
				       GFX_VESA2L,
				       GFX_VESA2L,
				       GFX_VESA2L};
#endif

#ifdef ALLEGRO_WINDOWS
  static int GFX_MODE_TYPE_FULLSCREEN[]={GFX_DIRECTX,
					 GFX_DIRECTX,
					 GFX_DIRECTX,
					 GFX_DIRECTX,
					 GFX_DIRECTX};
  static int GFX_MODE_TYPE_WINDOWED[]={GFX_DIRECTX_WIN,
				       GFX_DIRECTX_WIN,
				       GFX_DIRECTX_WIN,
				       GFX_DIRECTX_WIN,
				       GFX_DIRECTX_WIN};
#endif

#ifdef ALLEGRO_UNIX
  static int GFX_MODE_TYPE_FULLSCREEN[]={GFX_AUTODETECT_FULLSCREEN,
					 GFX_AUTODETECT_FULLSCREEN,
					 GFX_AUTODETECT_FULLSCREEN,
					 GFX_AUTODETECT_FULLSCREEN,
					 GFX_AUTODETECT_FULLSCREEN};
  static int GFX_MODE_TYPE_WINDOWED[]={GFX_AUTODETECT_WINDOWED,
				       GFX_AUTODETECT_WINDOWED,
				       GFX_AUTODETECT_WINDOWED,
				       GFX_AUTODETECT_WINDOWED,
				       GFX_AUTODETECT_WINDOWED};
#endif

  int w1,h1,w2,h2;

  log_print_str("Changing video mode to ");
  log_print_int(GFX_MODE_W[res]);
  log_print_str("x");
  log_print_int(GFX_MODE_H[res]);
  if (fullscreen)
    log_print_str(", fullscreen");
  else
    log_print_str(", windowed");
  if (flip)
    log_print_str(", page flipping enabled");

  nb_try=0;
  while (nb_try<5 && ret){
    if (nb_try==0)
      num_try=res;
    else
      num_try=nb_try-1;
    nb_try++;

    w1 = GFX_MODE_W[num_try];
    h1 = GFX_MODE_H[num_try];
    w2 = GFX_MODE_W[num_try];
    h2 = flip ? GFX_MODE_H[num_try]*2 : GFX_MODE_H[num_try];

    /*
     * First try, we try the "prefered" driver
     */
    if (fullscreen)
      ret=set_gfx_mode(GFX_MODE_TYPE_FULLSCREEN[num_try],w1,h1,w2,h2);
    else
      ret=set_gfx_mode(GFX_MODE_TYPE_WINDOWED[num_try],w1,h1,w2,h2);
    if (ret)
      {
	/*
	 * Second try, we try Allegro's default driver
	 */
	ret=set_gfx_mode(GFX_AUTODETECT,w1,h1,w2,h2);
      }
  }

  if (!ret)
    {
      set_palette(black_palette);

      if (SCREEN_W>=640)
        {
	  font=BIG_FONT;
	  set_mouse_sprite (BIG_MOUSE_CURSOR);
        }
      else
	{
          font=SMALL_FONT;
          set_mouse_sprite (SMALL_MOUSE_CURSOR);
	}
      
      set_window_title("Liquid War " LW_VERSION);
    }

  display_success_driver(!ret,(char *) gfx_driver->ascii_name);

  return (ret);
}


