/***************************************************************************
                          setup.h  -  description
                             -------------------
    begin                : Tue Apr 4 2000
    copyright            : (C) 2000 by Volker Schroer
    email                : DL1KSV@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *   based on the work of Moe Wheatley, AE4JY                              *
 ***************************************************************************/

#ifndef SETUP_H
#define SETUP_H



#include <qwidget.h>
#include <qradiobutton.h>
#include <qbuttongroup.h>
#include <qpushbutton.h>
#include <qlineedit.h>
#include <qcheckbox.h>
#include <qlabel.h>
#include <qspinbox.h>

#include "parameter.h"
#include "checkcom.h"

#include <string.h>

#include <sys/types.h>
#include <sys/soundcard.h>

#include "fsetup.h"


extern Parameter settings;

class Setup : public FSetup {
   Q_OBJECT
public: 
	Setup(QWidget *parent=0, const char *name=0);
	~Setup();
  bool demoMode;
	bool slashed0;

	int ptt;
	int DemoTypeNumber;
/** InputSource
ButtonId		0= Mic -> SOUND_MASK_MIC
ButtonID		1= Line -> SOUND_MASK_MIC
*/		 	
	int InputSource;
private:
	int level;

public slots: // Public slots
  /** Sets the Demomode on or off */
void setDemoMode(bool mode);
	/** Sets the Com port for ptt */
void setComPort(int);
	
void setSlashed0(bool);
void setInputLevel(int);
void setOutputLevel(int);
  /** Activates/Deactivates the SubWindow for the different Demo's */
  void activateTypeWindow(bool type);
  /** Selects the type of the input file
1 wav , sample rate 11025
2 text
 */
  void selectDemoType(int type);
  void selectInput(int source);
};

#endif
