/***************************************************************************
                          ctxdisplay.cpp  -  description
                             -------------------
    begin                : Sun Sep 17 2000
    copyright            : (C) 2000 by Volker Schroer
    email                : DL1KSV@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *    based on the work of  Moe Wheatly, AE4JY                             *  
 ***************************************************************************/

#include "ctxdisplay.h"

CTxdisplay::CTxdisplay(QWidget *parent, const char *name ) : QFrame(parent,name)
{

setFrameStyle(QFrame::WinPanel | QFrame::Sunken);
setFontPropagation(AllChildren);
setFont(settings.TxLabelFont);
QFontMetrics fm(settings.TxLabelFont);


// TX Values

  transmit= new QGroupBox(1,Horizontal,"Tx Freq",this);
  transmit->setFixedSize(fm.width("Tx Freq")+50,fm.height()*3+22);
	transmit->setFrameStyle(QFrame::WinPanel | QFrame::Raised);

  transmit->setMargin(0);
	transmit->setLineWidth(1);

// Tx Frequency	
  txfreq= new QSpinBox(transmit,"TxFrequency");
  txfreq->setRange(300,2500);
  txfreq->setValue(1000);
	txfrequency=1000;
	
// Changing TX- Frequency	
   connect(txfreq,SIGNAL(valueChanged(int)),this,SLOT(changetxfreq(int)));
	
// Net
  bnet= new QRadioButton(transmit,"net");
  bnet->setText("Net(F4)");
	bnet->setChecked(settings.net);
	connect(bnet,SIGNAL(toggled(bool)),&settings,SLOT(usenet(bool)));
	bnet->setAccel(Key_F4);
	

// RX/TX
	start= new CLedButton(this);
	start->setText("RX\n(F5)");
	
// SelectRxWindow	
	SelectRxWindow = new CRxSelect(settings.RxChannels,parent,this,"RxWindow");

// Txwindow

		txwindow= new CTxwindow(this);
		txwindow->setMaxLine(3);
}
CTxdisplay::~CTxdisplay(){
}

void CTxdisplay::resizeEvent(QResizeEvent *e)
{
int fontSize;
int xpos,ypos,left;
int elements_height;
int elements_width;

if (width() > 650)
	{
		setLineWidth(4);
		setMargin(15);
	}
else
	{
		setLineWidth(4);
		setMargin(10);
	}
//	setLineWidth(2);
//	setMargin(5);
			
//Setting FrameSize

left=5;

transmit->move(left,2);	

elements_width=transmit->width()-2*transmit->frameWidth()-2;
elements_height=(transmit->height()-2*transmit->frameWidth())/3;

fontSize=8;
// Calculating Fontsize
if ( (elements_height-2) > 8)
			fontSize = elements_height -2;					
if (fontSize*7 > elements_width)
			fontSize = elements_width/7;					



//Calculating position of Elements
xpos=transmit->frameWidth()+1;
ypos=transmit->frameWidth();


//Setting Label Size and position

//Setting DisplayValue and Position

// Setting Size and Position of ToggleButton

// RX/TX Button
start->setGeometry(2*left+transmit->width(),8,50,transmit->height()-5);

// Select RxWindow
SelectRxWindow->setGeometry(start->x()+start->width()+5,start->y(),50,start->height());

// Setting TX- Window
txwindow->setGeometry(SelectRxWindow->x()+SelectRxWindow->width()+5,transmit->y()+2,
					width()-SelectRxWindow->x()-SelectRxWindow->width()-10,height()-10);
txwindow->setFont(settings.TxWindowTextFont);

}

void CTxdisplay::changetxfreq(int freq)
{
if (freq != txfrequency)
 {
 	txfrequency=freq;
	txfreq->setValue(txfrequency);
 }	
}

int CTxdisplay::getTxFrequency()
{
return txfrequency;
}

