/*!!***************************************************************************
 *!! FILE NAME
 *!!	$Source: /var/cvs/pub/repository/LinCVS/src/logtree.h,v $
 *!!
 *!! AUTHOR
 *!!	$Author: joseh $
 *!!
 *!! DATE, REVISION AND STATE
 *!!	$Date: 2001/06/28 23:03:33 $
 *!!	$Revision: 1.4 $
 *!!	$State: Exp $
 *!!
 *!! DESCRIPTION
 *!!
 *!!	Copyright (C) 2001 Jose Hernandez.
 *!!
 *!!    Heavilly based on cervisia's code by Bernd Gehrmann and others.
 *!!    Copyright (C) 1999 Bernd Gehrmann.  bernd@physik.hu-berlin.de
 *!!
 *!!	This program is free software; you can redistribute it and/or modify
 *!!	it under the terms of the GNU General Public License as published by
 *!!	the Free Software Foundation; either version 2, or (at your option)
 *!!	any later version.
 *!!
 *!!	This program is distributed in the hope that it will be useful,
 *!!	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *!!	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *!!	GNU General Public License for more details.
 *!!
 *!!**************************************************************************/

#ifndef LOGTREE_H_20010626
#define LOGTREE_H_20010626

#include "config.h"
#include "ac_system_defs.h"

#include <qtableview.h>
#include <qlist.h>
#include <qcolor.h>


// Forward declarations
class LogTreeItem;
class LogTreeConnection;
class TipLabel;


class LogTreeView : public QTableView
{
	Q_OBJECT

public:
	LogTreeView (QWidget *parent=0, const char *name=0);
	~LogTreeView();

	void addRevision (const QString &rev, const QString &author,
			  const QString &date, const QString &state,
			  const QString &comment,
			  const QString &BranchTagList,
			  const QString &RegularTagList,
			  const QString &tagcomment);

	void setSelectedPair(QString selectionA, QString selectionB);
	void setSelectionColor (const unsigned char selection, const QColor &color);
	QColor getSelectionColor (const unsigned char selection) const;

	void collectConnections();
	void recomputeCellSizes();
        
	virtual QSize sizeHint() const;
	void lookupTip(const QPoint &p, QRect *r, QString *s);

signals:
	void revisionDblClicked (QString rev);
	void revisionClicked (QString rev, bool rmb);

public slots:
	void toggleBranchTags (bool enable);
	void toggleRegularTags (bool enable);

protected:
	virtual void mouseDoubleClickEvent (QMouseEvent *e);
	virtual void mousePressEvent(QMouseEvent *e);
	virtual void setupPainter(QPainter *p);
	virtual void paintCell(QPainter *p, int row, int col);
	virtual int cellWidth(int col);
	virtual int cellHeight(int row);
    
private:

	void paintRevisionCell (QPainter *p, LogTreeItem *TreeItem,
				bool followed, bool branched);

	void paintConnector (QPainter *p, int row, int col, bool followed,
			     bool branched);

	QList<LogTreeItem> items;
	QList<LogTreeConnection> connections;
	int currentRow, currentCol;
	QArray<int> colWidths;
	QArray<int> rowHeights;

	QString findCollision (int row, int col) const;
	void shiftBranch (QString branch);

	static QColor SelColor [2];
	bool bEnableBranchTags;
	bool bEnableRegularTags;
	bool bEnableCompactMode;
};

#endif //LOGTREE_H_20010626
