/*!!***************************************************************************
 *!! FILE NAME
 *!!	$Source: /var/cvs/pub/repository/LinCVS/src/TagDialogImpl.cpp,v $
 *!!
 *!! AUTHOR
 *!!	$Author: riemer $
 *!!
 *!! DATE, REVISION AND STATE
 *!!	$Date: 2001/08/16 00:55:59 $
 *!!	$Revision: 1.2 $
 *!!	$State: Exp $
 *!!
 *!! DESCRIPTION
 *!!
 *!!	Copyright (C) 2001 The LinCVS development team.
 *!!	    Tilo Riemer <riemer@lincvs.org>
 *!!	    Falk Brettschneider <gigafalk@yahoo.com>
 *!!	    Wim Delvaux <wim.delvaux@chello.be>
 *!!	    Jose Hernandez <joseh@tesco.net>
 *!!        Helmut Koll <HelmutKoll@web.de>
 *!!	    Sven Trogisch <trogisch@iapp.de>
 *!!
 *!!	This program is free software; you can redistribute it and/or modify
 *!!	it under the terms of the GNU General Public License as published by
 *!!	the Free Software Foundation; either version 2, or (at your option)
 *!!	any later version.
 *!!
 *!!	This program is distributed in the hope that it will be useful,
 *!!	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *!!	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *!!	GNU General Public License for more details.
 *!!
 *!!**************************************************************************/

#include "config.h"
#include "ac_system_defs.h"

#include "globals.h"             // for declaration of 'browser' 

#include <qcombobox.h>
#include <qbuttongroup.h>
#include <qstringlist.h>
#include "TagDialogImpl.h"
#include "PixmapCache.h"

/* 
 *  Constructs a TagDialogImpl which is a child of 'parent', with the 
 *  name 'name' and widget flags set to 'f' 
 *
 *  The dialog will by default be modeless, unless you set 'modal' to
 *  TRUE to construct a modal dialog.
 */
TagDialogImpl::TagDialogImpl( QWidget* parent,  const char* name, bool modal, WFlags fl )
    : TagDialog( parent, name, true, fl )
{
    if (bUseSmallIcons) setIcon( findEmbeddedPixmap( "Tag16x16" ) );
    else setIcon( findEmbeddedPixmap( "Tag32x32" ) );
    setCaption (name);
}


void TagDialogImpl::initTagList (QStringList *pTagList)
{
	m_pTagList = pTagList;

	for (unsigned int i = 0; i < m_pTagList->count(); i++)
		m_TagName->insertItem((*m_pTagList)[i]);
}


/*  
 *  Destroys the object and frees any allocated resources
 */
TagDialogImpl::~TagDialogImpl()
{
    // no need to delete child widgets, Qt does it all for us
}


void TagDialogImpl::accept ()
{
	if (m_pTagList->findIndex(m_TagName->currentText()) == -1)
	{
                // tag isnt in tagList
		m_pTagList->prepend(m_TagName->currentText());
	}
	else if (m_pTagList->findIndex(m_TagName->currentText()) > 0)
	{
		// text isnt the first item in list
		m_pTagList->remove(m_TagName->currentText());
		m_pTagList->prepend(m_TagName->currentText());
	}

	done (TagParamatersGroup->id(TagParamatersGroup->selected()));
}
