/*!!***************************************************************************
 *!! FILE NAME
 *!!	$Source: /var/cvs/pub/repository/LinCVS/src/PosixThread.cpp,v $
 *!!
 *!! AUTHOR
 *!!	$Author: joseh $
 *!!
 *!! DATE, REVISION AND STATE
 *!!	$Date: 2001/10/10 22:20:20 $
 *!!	$Revision: 1.2 $
 *!!	$State: Exp $
 *!!
 *!! DESCRIPTION
 *!!
 *!!	Copyright (C) 2001 The LinCVS development team.
 *!!	    Tilo Riemer <riemer@lincvs.org>
 *!!	    Falk Brettschneider <gigafalk@yahoo.com>
 *!!	    Wim Delvaux <wim.delvaux@chello.be>
 *!!	    Jose Hernandez <joseh@tesco.net>
 *!!        Helmut Koll <HelmutKoll@web.de>
 *!!	    Sven Trogisch <trogisch@iapp.de>
 *!!
 *!!	This program is free software; you can redistribute it and/or modify
 *!!	it under the terms of the GNU General Public License as published by
 *!!	the Free Software Foundation; either version 2, or (at your option)
 *!!	any later version.
 *!!
 *!!	This program is distributed in the hope that it will be useful,
 *!!	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *!!	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *!!	GNU General Public License for more details.
 *!!
 *!!**************************************************************************/


#include "config.h"
#include "ac_system_defs.h"
#include "time_ac.h"

#include <cstdio>
#include <iostream>
#include <climits>
#include "PosixThread.h"


PosixThread::PosixThread () : 
	m_finished(true)
{
}


PosixThread::~PosixThread () 
{
}


void *PosixThread::runCtrl (PosixThread *pthread)
{
	pthread_setcancelstate (PTHREAD_CANCEL_ENABLE, 0);
	pthread_setcanceltype (PTHREAD_CANCEL_ASYNCHRONOUS, 0);                    

	pthread->m_condition.lock();
	pthread->m_finished = false;
	pthread->m_condition.unlock();

	pthread->run();

	pthread->m_condition.lock();
	pthread->m_finished = true;
	pthread->m_condition.unlock();
	pthread->m_condition.signal();

	pthread_exit (0);
}


void PosixThread::start ()
{
	m_condition.init();
	pthread_create (&m_thread, 0,
			reinterpret_cast<void* (*)(void *)>(&runCtrl),
			(void*) this);
}


void PosixThread::exit ()
{
	bool bLocalfinished;

	m_condition.lock();
	bLocalfinished = m_finished;
	m_condition.unlock();

	if (!bLocalfinished)
	{
		pthread_cancel (m_thread);

		m_condition.lock();
		m_finished = true;
		m_condition.unlock();
	}
}


bool PosixThread::wait (unsigned long timeout)
{
	if (timeout == ULONG_MAX)
		pthread_join(m_thread, 0);
	else
		if (m_condition.wait(timeout))
			m_condition.unlock();
		else
			return (false);

	return (true);
}


bool PosixThread::finished()
{
	bool bLocalfinished;

	m_condition.lock();
	bLocalfinished = m_finished;
	m_condition.unlock();

	return (bLocalfinished);
}



PosixMutex::PosixMutex ()
{
      	pthread_mutex_init(&m_mutex,0);
};


PosixMutex::~PosixMutex ()
{
      pthread_mutex_destroy(&m_mutex);
};


void PosixMutex::lock()
{
	pthread_mutex_lock(&m_mutex);
}


void PosixMutex::unlock()
{
	pthread_mutex_unlock(&m_mutex);
}


PosixCondition::PosixCondition ()
{
	init();
}


PosixCondition::~PosixCondition()
{
	pthread_cond_destroy(&m_condition);
}


void PosixCondition::init()
{
	pthread_cond_init(&m_condition, 0);
}


void PosixCondition::signal()
{
	pthread_cond_signal(&m_condition);
}


bool PosixCondition::wait (unsigned long timeout)
{
	lock();

	if (timeout == ULONG_MAX)
	{
		pthread_cond_wait (&m_condition, &m_mutex);
	}
	else
	{
	    struct timeval now;
	    struct timespec interval;

	    gettimeofday(&now, 0);
	    interval.tv_sec = now.tv_sec + timeout;
	    interval.tv_nsec = now.tv_usec * 1000;

	    if ((pthread_cond_timedwait (&m_condition, &m_mutex, &interval)) != 0)
		return(false);
	}

	return (true);
}
