/*!!***************************************************************************
 *!! FILE NAME
 *!!	$Source: /var/cvs/pub/repository/LinCVS/src/CvsFileViewer.cpp,v $
 *!!
 *!! AUTHOR
 *!!	$Author: joseh $
 *!!
 *!! DATE, REVISION AND STATE
 *!!	$Date: 2001/06/28 23:03:33 $
 *!!	$Revision: 1.3 $
 *!!	$State: Exp $
 *!!
 *!! DESCRIPTION
 *!!
 *!!	Copyright (C) 2001 Jose Hernandez.
 *!!	This program is free software; you can redistribute it and/or modify
 *!!	it under the terms of the GNU General Public License as published by
 *!!	the Free Software Foundation; either version 2, or (at your option)
 *!!	any later version.
 *!!
 *!!	This program is distributed in the hope that it will be useful,
 *!!	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *!!	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *!!	GNU General Public License for more details.
 *!!
 *!!**************************************************************************/


#include "config.h"

#include <ctype.h>
#include <qpainter.h>
#include "CvsFileViewer.h"


class CvsFileViewerItem
{
public:
	QString text [CvsFileViewer::NUMCOLS];
};


class CvsFileViewerItemList : public QList<CvsFileViewerItem>
{
protected:
	virtual int compareItems (QCollection::Item item1, QCollection::Item item2)
	{
		return ((static_cast<CvsFileViewerItem*>(item1)->text[0]
			 == static_cast<CvsFileViewerItem*>(item2)->text[0]) ? 0 : 1);
	}
};


CvsFileViewer::CvsFileViewer (QWidget *parent, const char *name)
	: QTableView (parent, name)
{
	QFontMetrics fm(font());

	ColumnWidth.fill (0, NUMCOLS);
	ColumnWidth[0] = fm.width("99999");

	setFocusPolicy (QWidget::WheelFocus);
	setNumRows (0);
	setNumCols (NUMCOLS);
	setTableFlags (Tbl_autoVScrollBar |
		       Tbl_autoHScrollBar|
		       Tbl_smoothVScrolling);

	setFrameStyle (QFrame::WinPanel | QFrame::Sunken);
	setBackgroundMode (PaletteBase);
	setWFlags (WResizeNoErase);

	// Use variable cellwidth
	setCellWidth (0);
	setCellHeight (fm.lineSpacing());

	items = new CvsFileViewerItemList;
	items->setAutoDelete(true);
}


CvsFileViewer::~CvsFileViewer ()
{
	delete items;
}


void CvsFileViewer::append (QString Text, QString Revision,
			    QString Author, QString Date)
{
	CvsFileViewerItem *item = new CvsFileViewerItem;
	QFontMetrics fm(font());
	bool bUpdateTblSize = false;
	int LocalColumnWidth;

	item->text[0].setNum (items->count() + 1);
	// remove trailing whitespace from text line
	item->text[1] = " " + Revision + " ";
	item->text[2] = " " + Author + " ";
	item->text[3] = " " + Date + " ";
	item->text[4] = " " + Text.replace (QRegExp("[ \t]*$"), " ");
	items->append(item);

	for (int i=0; i<NUMCOLS; i++)
	{
		LocalColumnWidth = fm.width (item->text[i]);
		if (LocalColumnWidth > ColumnWidth[i])
		{
			ColumnWidth[i] = LocalColumnWidth;
			bUpdateTblSize = true;
		}
	}

	if (bUpdateTblSize)
		updateTableSize();

	setNumRows(numRows()+1);
}


int CvsFileViewer::cellWidth (int col)
{
	return (ColumnWidth[col]);
}


QSize CvsFileViewer::sizeHint() const
{
	QFontMetrics fm(font());
	return QSize( 4*fm.width("0123456789"), fm.lineSpacing()*8 );
}


void CvsFileViewer::paintCell (QPainter *p, int row, int col)
{
	CvsFileViewerItem *item = items->at(row);
	QColor fgColor, bgColor;
    
	switch (col)
	{
	case 0:
	case 1:
	case 2:
	case 3:
		bgColor = gray;
		fgColor = white;
		break;

	case 4:
		bgColor = white;
		fgColor = black;
		break;
	}

	int width = cellWidth(col);
	int height = cellHeight();

	p->setPen (fgColor);
	p->fillRect (0, 0, width, height, bgColor);
	p->drawText (0, 0, width, height, AlignLeft, item->text[col]);
}    
