// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// C++ Implementation: %{MODULE}
//
// Description:
//
// Author: Janusz SP9UMX <sp9umx@sr9zaa.ampr.org>, (C) 2005
//
// Copyright: See COPYING file that comes with this distribution
//

#include <qstringlist.h> 
#include <qscrollview.h> 
#include <qmessagebox.h> 
#include <qlistview.h>
#include <qfile.h> 
#include <qdir.h>
#include <qsettings.h> 
#include <qstatusbar.h>

#include "utils.h"
#include "llista.h"
#include "globals.h"
#include "msgproc.h"
#include "readmsg.h"
#include "addrbook.h"
#include "automark.h"
#include "configw.h"

#define BLOCK_SIZE 4096

// Global definitions

TUtils Util;
extern TList_window *List_window;
extern TMsgProc     *MsgProc;
extern TReadMsg     *ReadMsg;
extern TAddrBook    *AddrBook;
extern TAutoMark    *AutoMark;
extern TConfig	    *ConfigW;

extern int IdxInDir[10000];
extern int AlRdyRead[10000];
extern int MsgsInDir[10000];
extern int AutoMarkCount;
extern idx_record AutoMarkTable[20];
extern TAttrs FormAttrsTb[10];
extern QSettings ConfigFile;

extern QString  port;
extern QString  mycall;
extern QString  bbs;
extern QString  bbs_w_ssid;
extern QString  bbs_wo_ssid;
extern QString  digi;
extern QString  ListPath;
extern QString  PrgPath;
extern QString  ConfigFormat;
extern QString  LineFormat;
extern QString  IdxFormat;
extern int   header_lines;
extern QString  Cmds2GetLst;
extern QString  Cmds2LogOff;
extern QString  SysopName;
extern QString  Email;
extern QString  QuotePref;
extern QString  SID;
extern QString  RePref;
extern QString  HierAddr;
extern QString  BBSprompt;
extern QString  Altprompt;
extern QString  Version;
extern int   lastnum;
extern QStringList PersSigLines;
extern QStringList BullSigLines;
extern QString  HTMLV;
extern QString  HTMLE;
extern QString  ExtEd;
extern QString  ExtAd;

extern bool  AutoSig;
extern bool  Killmymsg;
extern int   Disconn;
extern bool  IsScript;
extern bool  IsTelnet;
extern char  Buffer[2047];
extern int   DataRead;
extern QString DataContent;
extern bool  AgeExpire;
extern int   AgeExpireDays;
extern bool  NrExpire;
extern int   NumberExpire;
extern bool  ShowHeaders;
extern bool  WordWrap;
extern int   WordWrapNr;


#define MAXHEADERS  13

const QString MsgHeaders[MAXHEADERS] = {"R:","From:","From :","To  :","To:","X-Info:",">From ","Received:","Message-Id:","	id",">From:","        id","Reply-To:"};

QString TUtils::Trim(const QString line )
{
  QString tmp;
  tmp = line.stripWhiteSpace();
  return tmp;

}


void TUtils::IncLastNum()
{
  QString tmp;
  
  lastnum++;
  
  tmp = PrgPath + "control/lastnum.dat";

  QFile fl(tmp);
  if ( fl.open( IO_WriteOnly ) ) 
  {
    QTextStream stream( &fl );
    tmp.sprintf( "%i" , lastnum );
    stream << tmp;
    fl.close();
  }    
}


QString TUtils::Get1Word( const QString wrd )
{
   QString tmp="";
   uint i=0;
   
   if (!wrd.isEmpty()) 
     while (wrd[i]!=' ' && i<wrd.length()) tmp +=wrd[i++];
         
   return tmp;
}

QString TUtils::Get2Word( const QString wrd )
{
    QString tmp="";
    uint i;
    
    i = wrd.find(' ',0,TRUE);
    i++;
    if (i>0 && i<wrd.length())
       while (wrd[i]!=" " && i<wrd.length()) tmp += wrd[i++];
    
    return tmp;
}


QString TUtils::GetRest( const QString wrd )
{
   QString tmp="";
   uint i = 0;
   
   i = wrd.find(' ',0,TRUE);
   i++;
   if (i>0 && i<wrd.length())
     while (i<wrd.length()) tmp +=wrd[i++];
   
   return tmp;
}


QString TUtils::AlgnToRght( const QString inp_string, int sizeofstr )
{
  int i;
  QString tmp;
  int cntch = inp_string.length();
  
  if (cntch < sizeofstr )
  {
    tmp = "";
    for (i=1; i<=sizeofstr-cntch; i++) tmp+=" ";
    tmp+=inp_string;
  }  
  else
  {
     tmp=inp_string;
  }
  return tmp;
}


QString TUtils::AlgnToLeft( const QString inp_string, int sizeofstr )
{
  int i;
  int cntch;
  QString tmp;
  
  cntch = strlen(inp_string);
  tmp=inp_string;
  
  if (cntch<sizeofstr) 
    for (i=cntch; i<=sizeofstr-1; i++) tmp +=" ";
  return tmp;
}


QString TUtils::substring( char idx, char test, QString data )
{
  QString TmpFormat;
  QString tmp;
  QString dt = data;
  int i;
  int cnt1;
  
  tmp="";
  if (idx=='i') TmpFormat=IdxFormat;
  if (idx=='l') TmpFormat=LineFormat;
  if (idx=='c') TmpFormat="NNNNNN  L SSSSSS TTTTTT@AAAAAA FFFFFF DDDD MMMM XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX";
  
//  TmpFormat="NNNNNN  L SSSSSS TTTTTT@AAAAAA FFFFFF DDDD MMMM XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX";
  
  i = TmpFormat.find(test,0,TRUE);
  cnt1 = i;
  if (i>=0)
  {
   while (TmpFormat[i]==test && dt[i] != 13 && dt[i] != 0)
   {
    tmp.append(dt[i]);
    i++;
   } 
  }
  else tmp="";
  
  return tmp;
}
  
QString TUtils::Idx2Str( char test, idx_record idx_tmp)
{
  QString tmp;
  
  if (test =='c' || test =='i' )
  {
	  tmp=AlgnToRght(idx_tmp.number,strlen(substring('i','N',IdxFormat)))+"  ";
  
  	tmp += idx_tmp.flag;
	tmp += "  ";
  	tmp += idx_tmp.size.rightJustify(strlen(substring('i','S',IdxFormat)),' ')+" ";
  	tmp += idx_tmp.to_a.leftJustify(strlen(substring('i','T',IdxFormat)),' ');
  	tmp += "@";
  
  	if (test=='i') tmp += idx_tmp.at.leftJustify(strlen(substring('i','A',IdxFormat)),' ');
  	if (test=='c') tmp += idx_tmp.at.leftJustify(6,' ');

      
  	tmp += " ";
  	tmp += idx_tmp.from.leftJustify(strlen(substring('i','F',IdxFormat)),' ');
  	tmp += " ";
  	tmp += idx_tmp.date;
  	tmp += " ";
  	tmp += idx_tmp.time;
  	tmp += " ";
  	tmp += idx_tmp.subject;
  }
  else if (test =='l')
  {
	  tmp = idx_tmp.number.stripWhiteSpace() + "  ";
	  tmp += idx_tmp.flag + " " + idx_tmp.size.rightJustify(6,' ') + " ";
	  tmp += idx_tmp.to_a.leftJustify(6,' ') + "@" + idx_tmp.at.leftJustify(6,' ')  + " ";
	  tmp += idx_tmp.from.leftJustify(6,' ') + " " + idx_tmp.date.leftJustify(4,' ') + " ";
	  tmp += idx_tmp.time.leftJustify(4,' ') + " " + idx_tmp.subject;
  }
  
  return tmp;
  

}
  
idx_record TUtils::idx_load(const char test, int nr )
{
  QString tmp;
  char c[255];
  FILE *fl;
  idx_record idx;
  QString cnv;
  
  tmp = PrgPath;
  
  
  if (test=='i') tmp += "control/";
  if (test=='q') tmp += "queue/";
  
  cnv = QString::number( nr );
  
  tmp += cnv;
  tmp += ".idx";
 
    if ( (fl=fopen(tmp, "r")) != NULL ) 
    {
         tmp = "";
	 fgets(c,100,fl);
	 fclose(fl);
	 tmp = c;
    } 
    else 
    {
	 fprintf(stdout,"%s\n","Blad otwarcia pliku :");
	 //QMessageBox sch ( "ERROR", "Blad otwarcia pliku idx.",
	//	   QMessageBox::Warning,
//		   QMessageBox::Ok, 0, 0 );
//	 sch.exec();	 
     }
  
  idx.number = substring('i','N',tmp);
  idx.flag = substring('i','L',tmp);
  idx.size = substring('i','S',tmp);
  idx.to_a = substring('i','T',tmp);
  idx.at   = substring('i','A',tmp);
  idx.from = substring('i','F',tmp);
  idx.date = substring('i','D',tmp);
  idx.time = substring('i','M',tmp);
  idx.subject = substring('i','X',tmp);
   
  return idx;   

}

void TUtils::idx_save( char test, idx_record idx_tmp )
{
  QString tst;

  if (test=='i') tst=PrgPath+"control/";
  if (test=='q') tst=PrgPath+"queue/";
  
  tst += Trim(idx_tmp.number) + ".idx";
  
  QFile fl(tst);
  if ( fl.open( IO_WriteOnly ) ) 
  {
    QTextStream stream( &fl );
    
    tst = idx_tmp.number.rightJustify(substring('i','N',IdxFormat).length(),' ');
    tst += "  "+ idx_tmp.flag + "  ";
    tst += idx_tmp.size.rightJustify(substring('i','S',IdxFormat).length(),' ')+" ";
    tst += idx_tmp.to_a.leftJustify(substring('i','T',IdxFormat).length(),' ')+"@";
    tst += idx_tmp.at.leftJustify(substring('i','A',IdxFormat).length(),' ')+" ";
    tst += idx_tmp.from.leftJustify(substring('i','F',IdxFormat).length(),' ')+" ";
    tst += idx_tmp.date + " " + idx_tmp.time + " " + idx_tmp.subject;
    
    stream << tst;
    fl.close();
  }    
  
}



QString TUtils::FindString(const char test, const QString data)
{
  QString tmp="";
  int i,j=0;
  
  j = data.find(test,0,FALSE);
  if (j>=0)
  {
   i=j;
   while (data[i]==test) i++;
   while (j!=i) tmp +=data[j++];
  }
  
  return tmp;
}


int TUtils::Look4Idx( char test)
{

  QString tmp,ttk="";
  QString ttp;
  idx_record idx_tmp;
  uint i;
  bool ok;
    
  if (test=='i') tmp = PrgPath+"control/";
  if (test=='q') tmp = PrgPath+"queue/";
   
  QDir d (tmp);
  d.setFilter( QDir::Files | QDir::NoSymLinks );
  d.setNameFilter("*.idx");
  d.setSorting( QDir::Name | QDir::Reversed );

  for ( i = 0; i < d.count(); i++ )
  {
    ttp = d[i];
    ttk += ttp;
    ttp.remove(d[i].find(".idx",0,TRUE),4);
    idx_tmp = idx_load('i',ttp.toInt( &ok, 10));
    IdxInDir[i]=ttp.toInt( &ok, 10);
    AlRdyRead[i]=idx_tmp.number.toInt( &ok, 10);
  }
  //    QMessageBox::information( List_window, "Look4Idx", ttk );

  return i;
  
}   
   

int TUtils::LoadAutoMarkTbl()
{
  
  int i=0;
  int max=0;
  QString tmp;
  
  tmp = PrgPath+"conf/AutoMark_new";
  
  QFile fl(tmp);
  if ( fl.open( IO_ReadOnly ) ) 
  {
    QTextStream stream( &fl );
    
    while ( !stream.atEnd())
    {
      tmp = stream.readLine();
      if ( !tmp.isEmpty() )
      {
	      //AddrList->insertRows(row,1);
	      AutoMarkTable[i].to_a = tmp.section(';',0,0);
	      AutoMarkTable[i].at   = tmp.section(';',1,1);
	      AutoMarkTable[i].from = tmp.section(';',2,2);
	      AutoMarkTable[i].subject = tmp.section(';',3,3);
	      //for (int p=0; p<=2 ; p++) AddrList->setText(row,p,tmp.section(';',p,p) ); 
	      i++;
      }

 /*     if (tmp=="[TO]")
        {
        while ( !stream.atEnd() && !tmp.isEmpty())
	{
          tmp = stream.readLine();  
	  if ( !tmp.isEmpty() ) AutoMarkTable[i++].to_a = tmp;
	}
      }
      
      max = i;
      tmp = stream.readLine();
      
      if (tmp=="[FROM]")
      {
        while ( !stream.atEnd() && !tmp.isEmpty())
	{
          tmp = stream.readLine();  
	  if ( !tmp.isEmpty() ) AutoMarkTable[i++].from = tmp;
	}
      }
      
      if (i>max) max=i;
      tmp = stream.readLine();
      if (tmp=="[BBS]")
      {
        while ( !stream.atEnd() && !tmp.isEmpty())
	{
          tmp = stream.readLine();  
	  if ( !tmp.isEmpty() ) AutoMarkTable[i++].at = tmp;
	}
      }
      
      if (i>max) max=i;
      tmp = stream.readLine();
       	
      if (tmp=="[Subject]")
      {
        while ( !stream.atEnd() && !tmp.isEmpty())
	{
          tmp = stream.readLine();  
	  if ( !tmp.isEmpty() ) AutoMarkTable[i++].subject = tmp;
	}
      }*/
    }
    
    if (i>max) max=i;
    fl.close();
   }
    return max;
      
}


bool TUtils::AutoMarkChk( QString line, int max )
{
  
  int i;
  bool ret=false;
  
  bool is_to,is_from,is_at,is_subj;
  
  for (i=0;i!=max;i++)
  {
	  is_to   = (!Trim(AutoMarkTable[i].to_a).isEmpty()) ? (Trim(AutoMarkTable[i].to_a) == Trim(substring('c','T',line))) : TRUE;
	  is_from = (!Trim(AutoMarkTable[i].from).isEmpty()) ? (Trim(AutoMarkTable[i].from) == Trim(substring('c','F',line))) : TRUE;
	  is_at   = (!Trim(AutoMarkTable[i].at).isEmpty())   ? (Trim(AutoMarkTable[i].at) == Trim(substring('c','A',line)))   : TRUE;
	  is_subj = (!Trim(AutoMarkTable[i].subject).isEmpty()) ? (substring('c','X',line).find(AutoMarkTable[i].subject,0,FALSE)>0) : TRUE; 	   
	  ret = ret || (is_to && is_from && is_at && is_subj);
  }
  
  return ret;
    
}


void TUtils::GetList()
{
  //QFile fl;
  QString tmp;
  int j,k,l;
  QString nr_msg;
  bool AutoMarkFound;
  bool IdxFound; 
  bool ok;
  QListView *ListView1 = List_window->ListView1;
  QListViewItem *last=NULL;

  ListView1->clear();
  ListView1->setSorting( 1,TRUE);
  ListView1->setColumnAlignment( 0, Qt::AlignHCenter );
  AutoMarkCount = LoadAutoMarkTbl();
  j = Look4Idx('i');
    
  QFile fl(ListPath);
  if ( fl.open( IO_ReadOnly ) ) 
  {
    l=0;
    QTextStream stream( &fl );
    while (! stream.atEnd() )
    {
      IdxFound = FALSE;
      tmp = stream.readLine();
      if (!tmp.isEmpty()) 
      {
        nr_msg = substring('i','N',tmp);
    
//    QMessageBox::information( List_window, "Title",  nr_msg );
        
      QListViewItem *item = new QListViewItem( ListView1 );
        item->setText( 1, substring('c','N',tmp));
        item->setText( 2, substring('c','L',tmp));
        item->setText( 3, substring('c','S',tmp));
        item->setText( 4, " "+substring('c','T',tmp));
        item->setText( 5, substring('c','A',tmp));
        item->setText( 6, substring('c','F',tmp));
        item->setText( 7, substring('c','D',tmp));
        item->setText( 8, substring('c','M',tmp));
        item->setText( 9, substring('c','X',tmp));
      
	AutoMarkFound = AutoMarkChk(tmp,AutoMarkCount);

	l++;
	k=0;
	while (k<=j) {if (AlRdyRead[k++]==nr_msg.toInt(&ok,10)) if (ok) IdxFound = TRUE;}
	  
	if (IdxFound) 
	{
	  item->setText( 0, "#" );
	}
	else
	{
	  if (AutoMarkFound) 
	  {  
	    if (QFile::exists(PrgPath+"control/"+nr_msg+".err")) 
	      item->setText( 0, "E" ); 
	    else
	    {
		    item->setText( 0, "!" );
	    }
	  } // if (AutoMarkFound)
	} // if (IdxFoud) - else
      last = item;
      } // if (!tmp.isEmpty())
    } // while (!stream.atEnd())
    ListView1->setSelected(last, TRUE);  
    ListView1->ensureItemVisible(last);    
    List_window->statusBar()->message( "Total items : " + QString::number( ListView1->childCount() ) );
  } // if (fl.open
  else
  {
    fl.open( IO_WriteOnly);
    fl.close(); 
  }
}

void TUtils::SaveAttrs( QString name, int n )
{
  ConfigFile.beginGroup( "/" + name );
  ConfigFile.writeEntry( "/FontName",      FormAttrsTb[n].FontAttrs.Name );
  ConfigFile.writeEntry( "/FontSize",      FormAttrsTb[n].FontAttrs.Size );
  ConfigFile.writeEntry( "/FontColor",     FormAttrsTb[n].FontAttrs.Color );
  ConfigFile.writeEntry( "/FontPitch",     FormAttrsTb[n].FontAttrs.Pitch );  
  ConfigFile.writeEntry( "/FontBold",      FormAttrsTb[n].FontAttrs.Bold );
  ConfigFile.writeEntry( "/FontItalic",    FormAttrsTb[n].FontAttrs.Italic );
//  ConfigFile.writeEntry( "/FontUnderline", FormAttrsTb[n].FontAttrs.Underline );
//  ConfigFile.writeEntry( "/FontStrikeout", FormAttrsTb[n].FontAttrs.Strikeout );

  ConfigFile.writeEntry( "/Color",  FormAttrsTb[n].FormAttrs.Color  );
  ConfigFile.writeEntry( "/Left",   FormAttrsTb[n].FormAttrs.x   );
  ConfigFile.writeEntry( "/Top",    FormAttrsTb[n].FormAttrs.y    );
  ConfigFile.writeEntry( "/Height", FormAttrsTb[n].FormAttrs.height );
  ConfigFile.writeEntry( "/Width",  FormAttrsTb[n].FormAttrs.width  );
  ConfigFile.endGroup();
  
}
  
void TUtils::SaveConfigFile()
{
//  QSettings ConfigFile;

 // QStringList::Iterator it = PersSigLines.begin();
  
  //it++;
  
 // QMessageBox::information( List_window, "Title",  *it );
 // port = "ax0";
    
  ConfigFile.insertSearchPath ( QSettings::Unix, PrgPath+"conf" );
  ConfigFile.setPath( "ampr.org" , "LinAMC" );
  
  ConfigFile.beginGroup("/General");
  ConfigFile.writeEntry( "/MyCall",      mycall );
  ConfigFile.writeEntry( "/SysopName",   SysopName );
  ConfigFile.writeEntry( "/Email",       Email );
  ConfigFile.writeEntry( "/QuotePrefix", QuotePref );
  ConfigFile.writeEntry( "/SID",         SID );
  ConfigFile.writeEntry( "/RePrefix",    RePref );
  ConfigFile.writeEntry( "/BBSCall",     bbs );
  ConfigFile.writeEntry( "/BBSprompt",   BBSprompt );
  ConfigFile.writeEntry( "/ALTprompt",   Altprompt );
  ConfigFile.writeEntry( "/HierAddr",    HierAddr );
  ConfigFile.writeEntry( "/Path",        digi );
  ConfigFile.writeEntry( "/Port",        port );
  ConfigFile.writeEntry( "/Format",      LineFormat );
  ConfigFile.writeEntry( "/Cmds2GetLst", Cmds2GetLst );
  ConfigFile.writeEntry( "/Cmds2LogOff", Cmds2LogOff );
  ConfigFile.writeEntry( "/HeaderLines", header_lines );
  ConfigFile.writeEntry( "/AutoSig",     AutoSig );
  ConfigFile.writeEntry( "/KillMyMsg",   Killmymsg );
  ConfigFile.writeEntry( "/HTMLViewer",  HTMLV );
  ConfigFile.writeEntry( "/HTMLEditor",  HTMLE );
  ConfigFile.writeEntry( "/ExtEditor",   ExtEd );
  ConfigFile.writeEntry( "/ExtAddOn",    ExtAd );
  ConfigFile.writeEntry( "/AgeExpire",   AgeExpire );
  ConfigFile.writeEntry( "/AgeExpDays",  AgeExpireDays );
  ConfigFile.writeEntry( "/NrExpire",    NrExpire );
  ConfigFile.writeEntry( "/NrExplines",  NumberExpire );
  ConfigFile.writeEntry( "/ShowHeaders", ShowHeaders );
  ConfigFile.writeEntry( "/WordWrap", WordWrap );
  ConfigFile.writeEntry( "/WordWrapNr",	 WordWrapNr );
  ConfigFile.endGroup();  
  
  ConfigFile.beginGroup( "/PersSig" );
  ConfigFile.writeEntry( "/Sig",     PersSigLines );
  ConfigFile.endGroup();
  ConfigFile.beginGroup( "/BullSig" );
  ConfigFile.writeEntry( "/Sig",     BullSigLines );
  ConfigFile.endGroup();
 
                                  // 1 - List_window
                                // 2 - MsgProc
                                // 3 - ReadMsg
                                // 4 - AddressF
                                // 5 - NewMsg
                                // 6 - ShellEx
 
  List_window->UpdateFormAttrs();
  SaveAttrs("List_window",1);
  MsgProc->UpdateFormAttrs();
  SaveAttrs("MsgProc",2);
  ReadMsg->UpdateFormAttrs();
  SaveAttrs("ReadMsg",3);
  SaveAttrs("AddrBook",4);
  SaveAttrs("NewMsg",5);
  SaveAttrs("ShellEx",6);
  SaveAttrs("AutoMark",7);
  SaveAttrs("ConfigW",8);
}

void TUtils::LoadAttrs( QString name, int n )
{  
  
  FormAttrsTb[n].FontAttrs.Name      = ConfigFile.readEntry( name + "/FontName", "Helvetica"    );
  FormAttrsTb[n].FontAttrs.Size      = ConfigFile.readNumEntry( name + "/FontSize",  12         );
  FormAttrsTb[n].FontAttrs.Color     = ConfigFile.readEntry( name + "/FontColor",  "#000001"    );
  FormAttrsTb[n].FontAttrs.Pitch     = ConfigFile.readBoolEntry( name + "/FontPitch",  TRUE     );  
  FormAttrsTb[n].FontAttrs.Bold      = ConfigFile.readBoolEntry( name + "/FontBold",   FALSE    );
  FormAttrsTb[n].FontAttrs.Italic    = ConfigFile.readBoolEntry( name + "/FontItalic", FALSE    );
//  FormAttrsTb[n].FontAttrs.Underline = ConfigFile.readBoolEntry( name + "/FontUnderline", FALSE );
//  FormAttrsTb[n].FontAttrs.Strikeout = ConfigFile.readBoolEntry( name + "/FontStrikeout", FALSE );

  FormAttrsTb[n].FormAttrs.Color  = ConfigFile.readEntry( name + "/Color", "#DCDCDC"   );
  FormAttrsTb[n].FormAttrs.x      = ConfigFile.readNumEntry( name + "/Left",  100  );
  FormAttrsTb[n].FormAttrs.y     = ConfigFile.readNumEntry( name + "/Top",   200  );
  FormAttrsTb[n].FormAttrs.height = ConfigFile.readNumEntry( name + "/Height",400  );
  FormAttrsTb[n].FormAttrs.width  = ConfigFile.readNumEntry( name + "/Width", 500  );


}


void TUtils::LoadConfigFile()
{
  int i;
  QString tmp;
   
  PrgPath=QDir::homeDirPath() + "/LinAMC/"; 
  
  ConfigFormat = "                                                                                ";
  tmp = PrgPath + "control/lastnum.dat";
  QFile fl(tmp);
  if ( fl.open( IO_ReadOnly ) ) 
  {
    QTextStream stream( &fl );
    tmp = stream.readLine();
    fl.close();
  }    
  lastnum = tmp.toInt();
  
 //QMessageBox::information( List_window, "Title",  PrgPath );
  
  ConfigFile.insertSearchPath ( QSettings::Unix, PrgPath+"conf" );
  ConfigFile.setPath( "ampr.org", "LinAMC" );
  
  ConfigFile.beginGroup("/config.new");
  mycall        = ConfigFile.readEntry("/MyCall", "nocall" );
  SysopName     = ConfigFile.readEntry( "/SysopName",  "" );
  Email         = ConfigFile.readEntry( "/Email",     ""  );
  QuotePref     = ConfigFile.readEntry( "/QuotePrefix",   ">"   );
  SID           = ConfigFile.readEntry( "/SID","[UMX-1.2-BFHM$]");
  RePref        = ConfigFile.readEntry( "/RePrefix",   "Re:"  );
  bbs           = ConfigFile.readEntry( "/BBSCall",     "" );
  BBSprompt     = ConfigFile.readEntry( "/BBSprompt",   ">" );
  Altprompt     = ConfigFile.readEntry( "/ALTprompt",   ">" );
  HierAddr      = ConfigFile.readEntry( "/HierAddr", "#KRA.POL.EU" );
  digi          = ConfigFile.readEntry( "/Path",  ""  );
  port          = ConfigFile.readEntry( "/Port",  "eth0"  );
  LineFormat    = ConfigFile.readEntry( "/Format",  ""     );
  Cmds2GetLst   = ConfigFile.readEntry( "/Cmds2GetLst", "lr" );
  Cmds2LogOff   = ConfigFile.readEntry( "/Cmds2LogOff", "b"  );
  header_lines  = ConfigFile.readNumEntry( "/HeaderLines",  4   );
  AutoSig       = ConfigFile.readBoolEntry( "/AutoSig",     TRUE );
  Killmymsg     = ConfigFile.readBoolEntry( "/KillMyMsg",   TRUE );
  HTMLV         = ConfigFile.readEntry( "/HTMLViewer",  ""   );
  HTMLE         = ConfigFile.readEntry( "/HTMLEditor",  ""   );
  ExtEd         = ConfigFile.readEntry( "/ExtEditor",   ""   );
  ExtAd         = ConfigFile.readEntry( "/ExtAddOn",    ""   );
  AgeExpire     = ConfigFile.readBoolEntry( "/AgeExpire",   FALSE);
  AgeExpireDays = ConfigFile.readNumEntry( "/AgeExpDays",  0    );
  NrExpire      = ConfigFile.readBoolEntry( "/NrExpire",    TRUE );
  NumberExpire  = ConfigFile.readNumEntry( "/NrExplines",  1000 );
  ShowHeaders   = ConfigFile.readBoolEntry( "/ShowHeaders", FALSE);
  WordWrap	= ConfigFile.readBoolEntry( "/WordWrap", FALSE );
  WordWrapNr	= ConfigFile.readNumEntry( "/WordWrapNr", 80 );
  PersSigLines  = ConfigFile.readListEntry( "/PersSig/Sig" ); 
  BullSigLines  = ConfigFile.readListEntry( "/BullSig/Sig" ); 
  //QMessageBox::information( List_window, "Title",  PersSigLines.join("#") );
 
 LoadAttrs("List_window",1);
 LoadAttrs("MsgProc",2);
 LoadAttrs("ReadMsg",3);
 LoadAttrs("AddrBook",4);
 LoadAttrs("NewMsg",5);
 LoadAttrs("ShellEx",6);
 LoadAttrs("AutoMark",7);
 LoadAttrs("ConfigW",8);

 
 i = SID.find('-',SID.find('-',0,FALSE)+1,FALSE);
 SID = SID.mid(0,SID.find('-',0,FALSE)) + "-" + Version + "-" + SID.mid(i+1,SID.length() -i);
 
 if (bbs.find('-',0,FALSE)!=0)
 {
   bbs_w_ssid = bbs;
   bbs_wo_ssid = bbs.mid(0,bbs.find('-',0,FALSE));
 }
 else
 {
   bbs_w_ssid  = bbs;
   bbs_wo_ssid = bbs;
 }
 
 ListPath = PrgPath + "ulistd/" + bbs_wo_ssid;
 
 IdxFormat = FindString('N',LineFormat) + "  L  ";
 IdxFormat += FindString('S',LineFormat) + " " + FindString('T',LineFormat) + " ";
 IdxFormat += "AAAAAAAAAAAAAAAAAAAA ";
 IdxFormat += FindString('F',LineFormat) + " ";
 IdxFormat += FindString('D',LineFormat) + " " + FindString('M',LineFormat) + " ";
 IdxFormat += FindString('X',LineFormat);
 
// QMessageBox::information( List_window, "Title",  IdxFormat );
 
}


bool TUtils::HeaderLine( QString s )
{
  int i=0;
  bool found;
  
  found = FALSE;
  while (i<MAXHEADERS && ! found)
  { if (s.find(MsgHeaders[i++],0,FALSE)>=0) found = TRUE;   }
  return found;
}

QStringList TUtils::StripHeader( QStringList Msg )
{
  if ( ! Msg.isEmpty() ) 
  {	
  QStringList::Iterator it = Msg.begin();

  if (HeaderLine(*it))
  {
  
    while ( HeaderLine(*it) || *it=="" ) 
    {
        if ( Msg.count() > 0 ) Msg.remove(it); else break;
        it = Msg.begin();
    }
  }
  }
  return Msg;
}



int TUtils::Look4Msgs()
{
  int i = 0;
  QDir dir = (PrgPath+"mail/");
  dir.setFilter( QDir::Files | QDir::NoSymLinks );
  dir.setSorting( QDir::Name );
  
  const QFileInfoList *list = dir.entryInfoList();
  QFileInfoListIterator it( *list );
  QFileInfo *fi;

  while ( (fi = it.current()) != 0 ) 
  {
    if (fi->fileName().find('.',0,FALSE) < 0)  MsgsInDir[i++] = fi->fileName().toInt();
   // QMessageBox::information( MsgProc, "Idx",  fi->fileName() );
    ++it;
  }
  return i;
}


void TUtils::MsgDir( bool UpdateMsgList )
{
   int i;
   int k;
   int l;
   QString tmp;
   idx_record idx_tmp;
   QFile fl;
   i = Look4Msgs();
   QListView *MsgList = MsgProc->MsgList;
   
   if (UpdateMsgList) MsgList->clear();
  
   for (k=0;k<i;k++)
   {
     tmp = PrgPath+"control/"+QString::number(MsgsInDir[k])+".idx";
     
     fl.setName( tmp );
     
     if (fl.exists())
     {
       idx_tmp = idx_load('i',MsgsInDir[k]);
       AlRdyRead[i] = idx_tmp.number.toInt();
       idx_tmp.number = QString::number(MsgsInDir[k]).rightJustify(6,' ',FALSE);
     
       if (UpdateMsgList )
       {
        QListViewItem *item = new QListViewItem( MsgList );
        item->setText( 0, idx_tmp.number.stripWhiteSpace().rightJustify(6,' ',FALSE));
        item->setText( 1, idx_tmp.flag);
        item->setText( 2, idx_tmp.size);
        item->setText( 3, " "+idx_tmp.to_a);
	
	l = idx_tmp.at.find('.',0,FALSE);
        if (l != -1 )
	   idx_tmp.at.truncate(l);
	else
	   idx_tmp.at.truncate(6);
	   
	item->setText( 4, idx_tmp.at);
        item->setText( 5, idx_tmp.from);
        item->setText( 6, idx_tmp.date);
        item->setText( 7, idx_tmp.time);
        item->setText( 8, idx_tmp.subject);
       }
     } 
     else // fl does not exists
     {
       tmp = "No .idx-file for: "+QString::number(MsgsInDir[k])+" mail-file. Please delete it or move to another location";
       QMessageBox::critical( MsgProc, "Error",  tmp );
     }
   }

}

void	TUtils::CopyFile( QString from, QString to)
{
	char *data = new char[BLOCK_SIZE];
			
	QFile f_from ( from );
	if ( f_from.open( IO_ReadOnly ) )
	{
		QFile f_to ( to );
		if ( f_to.open( IO_WriteOnly ))
		{
			do
			{
				f_to.writeBlock( data, f_from.readBlock(data, BLOCK_SIZE));
				f_to.flush();
			} while ( ! f_from.atEnd() );
		}
		else
		{
			QMessageBox::critical( List_window, "Open file error","Cannot open file: " + from );
		}
		
		f_from.close();
		f_to.close();
	}
	else
	{
		QMessageBox::critical( List_window, "Open file error","Cannot open file: " + from);
	}

	delete[] data;
}



/*
 
   pid_t RunPrg( char* prg, char* arg);
   char* dec2hex( long number_dec );
   void  idx_save( char test, idx_record idx_tmp );
*/

