// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you want to add, delete, or rename functions or slots, use
** Qt Designer to update this file, preserving your code.
**
** You should not define a constructor or destructor in this file.
** Instead, write your code in functions called init() and destroy().
** These will automatically be called by the form's constructor and
** destructor.
*****************************************************************************/
// Author: Janusz SP9UMX <sp9umx@sr9zaa.ampr.org>, (C) 2005
//
// Copyright: See COPYING file that comes with this distribution

// QT
#include <qfontdialog.h>
#include <qcolordialog.h>
#include <qlistview.h>
#include <qfile.h>
#include <qradiobutton.h>
#include <qdatetime.h>
#include <qprocess.h>

#include "utils.h"
#include "readmsg.h"
#include "msgproc.h"
#include "newmsg.h"

// Classess
extern TReadMsg  *ReadMsg;
extern TMsgProc  *MsgProc;
extern TNewMsg   *NewMsg;
extern TUtils Util;

// Global variables
extern TAttrs FormAttrsTb[10];
extern QString PrgPath;
extern bool  ShowHeaders;
extern bool  AutoSig;
extern QString  QuotePref;
extern QString  HTMLV;
extern QString  ExtEd;
extern QString  ExtAd;

QProcess *processRead;



void TReadMsg::ColorBtnClick()
{
	QColor colorTmp = QColorDialog::getColor( MsgBody->paletteBackgroundColor () );
	if ( colorTmp.isValid() ) MsgBody->setPaletteBackgroundColor( colorTmp );
  	UpdateFormAttrs();
}


void TReadMsg::CommentBtnClick()
{
  QString tmp;
  idx_record idx_tmp;
  QString from_tmp;

  NewMsg->EditMsg->clear();
  tmp = MsgProc->MsgList->currentItem()->text(0).stripWhiteSpace();
  idx_tmp = Util.idx_load('i',tmp.toInt() );
  tmp = PrgPath + "mail/" + tmp;
  NewMsg->EditMsg->append( "\n" );
  NewMsg->EditMsg->append( "Quoting from previos message ... " );
  NewMsg->EditMsg->append( "\n" );
  
  QFile fl( tmp );
  if ( fl.open( IO_ReadOnly ) )
  {
    QTextStream stream ( &fl );
    while ( ! stream.atEnd() )
    {
      tmp = stream.readLine();
      if ( tmp.isEmpty() )
         NewMsg->EditMsg->append( "\n" );
      else
      {
//        if ( tmp.find("From: "+ReadMsg->MsgFromEdt->text(),0,FALSE) == 0 )
//          from_tmp = tmp.section('@',1,1);
        if ( tmp[0] != 'R' && tmp[1] != ':' )
        {
          tmp = QuotePref + " " + tmp;
          NewMsg->EditMsg->append( tmp );
        }
      }
    }
  fl.close();
  }

  if (idx_tmp.flag == "P" || idx_tmp.flag == "W" || idx_tmp.flag == "F" )
  {
    NewMsg->ToEdt->setText( idx_tmp.to_a );
    NewMsg->SubjEdt->setText( "Re: " + idx_tmp.subject );
    NewMsg->AtEdt->setText( "" );
    NewMsg->MsgTypeP->setChecked( TRUE );
    NewMsg->MsgTypeB->setChecked( FALSE );
  }

  if (idx_tmp.flag == "B" || idx_tmp.flag == "V" || idx_tmp.flag == "G" )
  {
    NewMsg->ToEdt->setText( idx_tmp.to_a );
    NewMsg->SubjEdt->setText( "Re: " + idx_tmp.subject );
    NewMsg->AtEdt->setText( idx_tmp.at );
    NewMsg->MsgTypeP->setChecked( FALSE );
    NewMsg->MsgTypeB->setChecked( TRUE );
  }

  NewMsg->show();

}


void TReadMsg::ExtEditBtnClick()
{
   QString tmp;
   
   if (MsgProc->MsgList->childCount() > 0)
   {
     if ( ! ExtEd.isEmpty() )
     {
       processRead = new QProcess(this);
       processRead->addArgument( ExtEd );
       processRead->addArgument( PrgPath + "mail/" + MsgProc->MsgList->currentItem()->text(0).stripWhiteSpace() );
               
//       connect( process, SIGNAL(processExited ()), this, SLOT(ExtEdtExited()) );

        if ( !processRead->start() ) 
            QMessageBox::critical( this, "Error", "External text editor cannot be executed" );

     }
    }

}


void TReadMsg::FontBtnClick()
{
    MsgBody->setFont( QFontDialog::getFont( 0, MsgBody->font() ) );
    UpdateFormAttrs();
}


void TReadMsg::HTMLBtnClick()
{
  QString tmp;

       if ( ! HTMLV.isEmpty() )
       {
         tmp = PrgPath + "mail/" + MsgProc->MsgList->currentItem()->text(0).stripWhiteSpace();
       
         QFile flIn( tmp);
         if (flIn.open( IO_ReadOnly ))
         {
	   QFile flOut(tmp+".html");
	   flOut.open( IO_WriteOnly );
         
	   QTextStream streamIn  ( &flIn );
           QTextStream streamOut ( &flOut );
	 	 
	   while ( ! streamIn.atEnd() )
	   {
	     tmp = streamIn.readLine();
             if ( ! Util.HeaderLine( tmp ) ) streamOut << tmp;   
	   }
	   flIn.close();
	   flOut.close();
         }
     
         processRead = new QProcess(this);
         processRead->addArgument( HTMLV );
         processRead->addArgument( PrgPath + "mail/" + MsgProc->MsgList->currentItem()->text(0).stripWhiteSpace() + ".html" );
               
//       connect( process, SIGNAL(processExited ()), this, SLOT(ExtEdtExited()) );

        if ( !processRead->start() ) 
            QMessageBox::critical( this, "Error", "External text editor cannot be executed" );

       }

}


void TReadMsg::KillBtnClick()
{
    QString msg_nr;
    QString tmp;
    QListViewItem *current (MsgProc->MsgList->currentItem() );
    QListViewItemIterator it (MsgProc->MsgList->currentItem() );
    //QListViewItem *next (MsgList->currentItem()->itemBelow() );
    
    if (MsgProc->MsgList->lastItem() != 0)
    {
      current =  MsgProc->MsgList->currentItem();
      msg_nr = current->text(0).stripWhiteSpace();
      
//      QMessageBox::information( this, "Title", "nr " + next->text(0) );
      
      tmp = PrgPath + "mail/" + msg_nr;
      QFile::remove( tmp );
            
      tmp = PrgPath + "queue/" + msg_nr + ".idx";
      if (QFile::exists( tmp )) QFile::remove( tmp );
      
      delete MsgProc->MsgList->currentItem();
     // MsgList->setCurrentItem( current->itemAbove() );
          
      Util.MsgDir( FALSE );

      MsgProc->MsgList->setCurrentItem( *(it) );
      MsgProc->MsgList->currentItem()->setSelected( TRUE );
      //MsgList->ensureItemVisible( *it );
      
     MsgBody->clear();
     tmp = MsgProc->MsgList->currentItem()->text(0).stripWhiteSpace();
     FillFields( tmp.toInt() );
     
     // tmp := Trim(MsgProc.MsgList.ItemFocused.Caption);
     // FillFields(StrToInt(tmp));
    }
}


void TReadMsg::Msg2PrgBtnClick()
{
   QString tmp;
   
   if (MsgProc->MsgList->childCount() > 0)
   {
     if ( ! ExtAd.isEmpty() )
     {
       processRead = new QProcess(this);
       processRead->addArgument( ExtAd );
       processRead->addArgument( PrgPath + "mail/" + MsgProc->MsgList->currentItem()->text(0).stripWhiteSpace() );
               
//       connect( process, SIGNAL(processExited ()), this, SLOT(ExtEdtExited()) );

        if ( !processRead->start() ) 
            QMessageBox::critical( this, "Error", "External text editor cannot be executed" );

     }
    }

}


void TReadMsg::NewMsgBtnClick()
{
  NewMsg->MsgTypeP->setChecked( FALSE );
  NewMsg->MsgTypeB->setChecked( FALSE );
  NewMsg->EditMsg->clear();
  NewMsg->ToEdt->setText( "" );
  NewMsg->SubjEdt->setText( "" );
  NewMsg->AtEdt->setText( "" );

  QDate date = QDate::currentDate();
  QTime time = QTime::currentTime();
  QString s;
  s.sprintf("  ->  %02d-%02d-%02d  %02d:%02d  <-",date.day(),date.month(),date.year(),time.hour(),time.minute() );
  NewMsg->EditMsg->append( s );


  if (AutoSig )
  { 
    NewMsg->EditMsg->append( "\n" );
    NewMsg->EditMsg->append( "\n" );
    NewMsg->EditMsg->append( "[Signature]" );
  }

  NewMsg->show();
}


void TReadMsg::ReplyBtnClick()
{
  QString tmp;
  idx_record idx_tmp;
  QString from_tmp;

  NewMsg->EditMsg->clear();
  tmp = MsgProc->MsgList->currentItem()->text(0).stripWhiteSpace();
  idx_tmp = Util.idx_load('i',tmp.toInt() );
  tmp = PrgPath + "mail/" + tmp;
  NewMsg->EditMsg->append( "\n" );
  NewMsg->EditMsg->append( "Quoting from previos message ... " );
  NewMsg->EditMsg->append( "\n" );
  
  QFile fl( tmp );
  if ( fl.open( IO_ReadOnly ) )
  {
    QTextStream stream ( &fl );
    while ( ! stream.atEnd() )
    {
      tmp = stream.readLine();
      if ( tmp.isEmpty() )
         NewMsg->EditMsg->append( "\n" );
      else
      {
        if ( tmp.find("From: "+ReadMsg->MsgFromEdt->text(),0,FALSE) == 0 )
          from_tmp = tmp.section('@',1,1);
        if ( tmp[0] != 'R' && tmp[1] != ':' )
        {
          tmp = QuotePref + " " + tmp;
          NewMsg->EditMsg->append( tmp );
        }
      }
    }
  fl.close();
  }

  if (idx_tmp.flag == "P" || idx_tmp.flag == "W" || idx_tmp.flag == "F" )
  {
    NewMsg->ToEdt->setText( idx_tmp.from );
    NewMsg->SubjEdt->setText( "Re: " + idx_tmp.subject );
    NewMsg->AtEdt->setText( from_tmp );
    NewMsg->MsgTypeP->setChecked( TRUE );
    NewMsg->MsgTypeB->setChecked( FALSE );
  }

  if (idx_tmp.flag == "B" || idx_tmp.flag == "V" || idx_tmp.flag == "G" )
  {
    NewMsg->ToEdt->setText( idx_tmp.to_a );
    NewMsg->SubjEdt->setText( "Re: " + idx_tmp.subject );
    NewMsg->AtEdt->setText( idx_tmp.at );
    NewMsg->MsgTypeP->setChecked( FALSE );
    NewMsg->MsgTypeB->setChecked( TRUE );
  }

  NewMsg->show();
}



void TReadMsg::hideEvent( QHideEvent *e )
{
  if ( ! e->spontaneous ()  )    UpdateFormAttrs();
}



void TReadMsg::UpdateFormAttrs()
{
  QFontInfo fi (MsgBody->font());
  QColor font_color(MsgBody->foregroundColor());
  QColor background(MsgBody->paletteBackgroundColor());
  
  FormAttrsTb[3].FontAttrs.Name      =  fi.family();
  FormAttrsTb[3].FontAttrs.Size      =  fi.pointSize();
  
  FormAttrsTb[3].FontAttrs.Color     =  font_color.name();
  FormAttrsTb[3].FontAttrs.Pitch     =  fi.fixedPitch();
  FormAttrsTb[3].FontAttrs.Bold      =  fi.bold();
  FormAttrsTb[3].FontAttrs.Italic    =  fi.italic();

  FormAttrsTb[3].FormAttrs.Color  =  MsgBody->paletteBackgroundColor().name();
  FormAttrsTb[3].FormAttrs.x      =  ReadMsg->x();
  FormAttrsTb[3].FormAttrs.y      =  ReadMsg->y();
  FormAttrsTb[3].FormAttrs.height =  ReadMsg->height();
  FormAttrsTb[3].FormAttrs.width  =  ReadMsg->width();

}


void TReadMsg::showEvent( QShowEvent * e )
{
  if ( ! e->spontaneous ()  )
  {
  QFont fi;
  QColor color; //(MsgList->paletteBackgroundColor());
  
  
  fi.setFamily(FormAttrsTb[3].FontAttrs.Name);
  fi.setPointSize(FormAttrsTb[3].FontAttrs.Size);
  
  fi.setFixedPitch(FormAttrsTb[3].FontAttrs.Pitch);
  fi.setBold(FormAttrsTb[3].FontAttrs.Bold);
  fi.setItalic(FormAttrsTb[3].FontAttrs.Italic);
  MsgBody->setFont( fi );

  color.setNamedColor(FormAttrsTb[3].FormAttrs.Color);
  MsgBody->setPaletteBackgroundColor(color);
  MsgBody->setPaletteForegroundColor (FormAttrsTb[3].FontAttrs.Color); // Font Color
  
  move( FormAttrsTb[3].FormAttrs.x, FormAttrsTb[3].FormAttrs.y );
  resize( FormAttrsTb[3].FormAttrs.width, FormAttrsTb[3].FormAttrs.height );
  }

}


void TReadMsg::FillFields( int nr )
{
   QString tmp;
   idx_record idx_tmp;
   
   MsgBody->clear();
   tmp = QString::number( nr );
   
   ReadMsg->setCaption( "Reading message: " + tmp );
   idx_tmp = Util.idx_load('i', nr );
   
   QStringList *MsgTmp = new QStringList();
  
   tmp = PrgPath + "mail/" + tmp;

   QFile fl(tmp);
   if (fl.open(IO_ReadOnly))
   {
     while ( ! fl.atEnd() )
     {
       QTextStream stream (&fl);
       tmp = stream.readLine();
       *MsgTmp += tmp;
     }
     fl.close();
   }
   
   if ( ShowHeaders )
   {
   //  QMessageBox::information( this, "title", "showheaders");
     MsgBody->insert( MsgTmp->join("\n"));
   }
   else
     MsgBody->insert( Util.StripHeader(*MsgTmp).join("\n"));
     
   ReadMsg->MsgFromEdt->setText( idx_tmp.from );
   ReadMsg->MsgToEdt->setText ( idx_tmp.to_a );
   ReadMsg->MsgAtEdt->setText ( idx_tmp.at );
   ReadMsg->MsgTypeEdt->setText ( idx_tmp.flag );
   ReadMsg->MsgSubjEdt->setText ( idx_tmp.subject );
   ReadMsg->MsgSizeEdt->setText ( idx_tmp.size );
   ReadMsg->MsgBody->setContentsPos( 0,0);
   delete MsgTmp;
}



void TReadMsg::DownBtnClick()
{
  QListViewItemIterator it (MsgProc->MsgList->currentItem());
  if (  *(++it) )
  {
  MsgProc->MsgList->setCurrentItem( *it );
  MsgProc->MsgList->ensureItemVisible( *it );
  FillFields( (*it)->text(0).toInt() );
  }
}


void TReadMsg::UpBtnClick()
{
  QListViewItemIterator it (MsgProc->MsgList->currentItem());
  if ( *it != MsgProc->MsgList->firstChild() ) --it;
  MsgProc->MsgList->setCurrentItem( *it );
  MsgProc->MsgList->ensureItemVisible( *it );
  FillFields( (*it)->text(0).toInt() );
}
