// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

// Author: Janusz SP9UMX <sp9umx@sr9zaa.ampr.org>, (C) 2005
//
// Copyright: See COPYING file that comes with this distribution

#include <qapplication.h>
#include <qwidget.h>
#include <qlistview.h> 
#include <qtextbrowser.h>
#include <qscrollview.h>
#include <qdir.h>
#include <netax25/ax25.h> 
#include <netax25/axconfig.h>
//#include <netax25/axlib.h> 

// out !
#include <qmessagebox.h>

#include "llista.h"
#include "utils.h"
#include "shellex.h"
#include "msgproc.h"
#include "AxUnit.h"
#include "statusw.h"
#include "readmsg.h"
#include "newmsg.h"
#include "addrbook.h"
#include "automark.h"
#include "configw.h"
// #include "finddialog.h"

TList_window *List_window=NULL;
TShellEx     *ShellEx=NULL;
TMsgProc     *MsgProc=NULL;
QApplication *Application=NULL;
TAxUnit      *AxU;
TStatus      *StatusW=NULL;
TReadMsg     *ReadMsg=NULL;
TNewMsg      *NewMsg=NULL;
TAddrBook    *AddrBook=NULL;
TAutoMark    *AutoMark=NULL;
TConfig	     *ConfigW=NULL;
// FindDialogBase *FindDlg=NULL;

extern int   StatusByte;
extern QString  Version;
extern QString  PrgPath;

extern TUtils Util;


int main( int argc, char ** argv )
{
    
    QApplication a( argc, argv );
    Application = &a;
    
    Util.LoadConfigFile();

    TList_window Lw;
    List_window=&Lw;
        
    TMsgProc MP;
    MsgProc=&MP;
    
    TShellEx ShEx;
    ShellEx=&ShEx;
    
    TStatus Stat;
    StatusW=&Stat;
    
    TReadMsg RdMsg;
    ReadMsg=&RdMsg;
    
    TNewMsg NwMsg;
    NewMsg=&NwMsg;
    
    TAddrBook AdBk;
    AddrBook=&AdBk;
    
    TAutoMark AtMrk;
    AutoMark=&AtMrk;
    
    TConfig Cnfg;
    ConfigW=&Cnfg;
    
/*    FindDialogBase FD;
    FindDlg=&FD;*/
    
    Lw.show();
    
    Util.GetList();
    Util.MsgDir( TRUE );
    
    ax25_config_load_ports();
    
    a.setMainWidget( &Lw );
    a.connect( &a, SIGNAL( lastWindowClosed() ), &Lw, SLOT( Quit_and_Save() ) );  
    a.connect( &a, SIGNAL( aboutToQuit() ), &Lw, SLOT( Quit_and_Save() ) );  
 

    Version = "2.0rc5"; // - '+TimeToStr(Time);
    Lw.setCaption( "LinAMC " + Version + " - Bulletin list");

    //       Signals.InstallSigHandler;
    
    int i = 0;
    QDir dir = (PrgPath+"control/");
    dir.setNameFilter( "*.id_");
    for ( i = 0; i < (int)(dir.count()); i++ )
	    QFile::remove( PrgPath + "control/" + dir[i] );

    dir.setPath( PrgPath+"mail/");
    dir.setNameFilter( "*.html");
    for ( i = 0; i < (int)(dir.count()); i++ )
	    QFile::remove( PrgPath + "mail/" + dir[i] );

    
   StatusByte = 0;
 
    MP.show();
 //   ShEx.show();
    StatusByte = 0;
    return a.exec();
}
