// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// C++ Implementation: %{MODULE}
//
// Description:
//
//
// Author: Janusz SP9UMX <sp9umx@sr9zaa.ampr.org>, (C) 2005
//
// Copyright: See COPYING file that comes with this distribution
//
//

#include <netax25/ax25.h> 
#include <netax25/axconfig.h>
#include <netax25/axlib.h> 
#include <sys/select.h>
//#include <sys/socket.h>
#include <sys/ioctl.h>
//#include <sys/poll.h>
//#include <linux/fd.h>
//#include <stropts.h>
//#include <netinet/in.h>
#include <arpa/inet.h>
//#include <unistd.h>
//#include <fcntl.h>
#include <errno.h>
//#include <string.h>
#include <qmessagebox.h> 
#include <qfile.h> 
#include <qlistbox.h>
#include <qsocket.h>
//#include <qsocketdevice.h> 
#include <qapplication.h>
#include <qtimer.h>
//#include <qobject.h>
//#include <stdio.h>
//#include <string.h>

#include "llista.h"
//#include "globals.h"
#include "AxUnit.h"
#include "shellex.h"
#include "utils.h"
#include "event.h"

#define CONTIME 100

// Forms
extern QApplication *Application;
extern TShellEx *ShellEx;
extern TList_window *List_window;

// Use module
extern TUtils Util;

// Global variables
extern int StatusByte;
extern QString mycall;
extern QString bbs;
extern QString port;
extern QString bbs_w_ssid;
extern QString digi;
extern bool  IsScript;
extern bool  IsTelnet;
extern int   DataRead;
extern char  Buffer[2047];
extern QString DataContent;
extern FILE *FileDescriptor;
extern bool  connected;
extern QString  PrgPath;
extern QString  BBSprompt;


QSocket Socket;
int	SocketFileDescriptor;
int 	paclen;
int	ConnectionStatus;


int TAxUnit::WaitConnect( int sock )
{
	int err;
	ax25_info_struct axinfo;
/*	ConnectionStatus = 0;
	QTimer *timer = new QTimer( AxU );
	connect ( timer, SIGNAL(timeout()), this, SLOT(ConnStat()));
	timer->start(200,false);	*/
	
	
/*	while (ConnectionStatus == 1)
	{
		if ((err = ioctl(sock, SIOCAX25GETINFO, &axinfo)) != -1)
			ConnectionStatus = axinfo.state;
		ShExLineEvent* shln = new ShExLineEvent( QString::number(ConnectionStatus) );
		QApplication::postEvent( ShellEx, shln );
		Application->processEvents();
	}*/
	
  fd_set rfds;
  struct timeval tv;
  int rc=0;
  int i=0;
  while (rc==0 && i<30000 && StatusByte!=6)
  {
    Application->processEvents();
    FD_ZERO(&rfds);
    FD_SET(sock, &rfds);
    tv.tv_sec = 0;
    tv.tv_usec = CONTIME;
    rc = select(sock+1, &rfds, NULL, NULL, &tv);
    Application->processEvents();
    i++;
  }
  if (StatusByte==6) close(sock);
  if (rc > 0 && FD_ISSET(sock, &rfds))
  {
    return 1;
  }
  else
  {
    return 0;
  }
}

void ConnStat()
{
	ax25_info_struct axinfo;
	int err;
	
	if ((err = ioctl(SocketFileDescriptor, SIOCAX25GETINFO, &axinfo)) != -1 )
	{
		ConnectionStatus = axinfo.state;
		ShExLineEvent* shln = new ShExLineEvent( QString::number(ConnectionStatus) );
		QApplication::postEvent( ShellEx, shln );
	}
}

bool TAxUnit::AxCon_BBS( QString ConnTo )
{
   int len,i;
   struct full_sockaddr_ax25 SockAddr_src, SockAddr_dst;
   char *tmp;
   char kk[10];
   char *pp=kk;
   QString mm;
   
   
   DataContent = "";
   
   IsTelnet = FALSE;
   connected = FALSE;
      
   strcpy(pp,port);   
     
   
//   ax25_config_load_ports();
   tmp = ax25_config_get_addr(pp);
     
   paclen = ax25_config_get_paclen( pp );
		   
		   
   SocketFileDescriptor = socket(AF_AX25, SOCK_SEQPACKET, PF_AX25);
   
   if (SocketFileDescriptor == -1)
     	QMessageBox::critical( List_window, "Connection error",  "Cannot create socket" );

   
  
 // fcntl(SocketFileDescriptor, F_SETFL, O_NONBLOCK);
   
   SockAddr_dst.fsa_ax25.sax25_family = AF_AX25;
   SockAddr_src.fsa_ax25.sax25_family = AF_AX25;
   SockAddr_src.fsa_ax25.sax25_ndigis = 0;
   
   if (ConnTo.isEmpty())
   {
     ax25_aton_entry(bbs_w_ssid,SockAddr_dst.fsa_ax25.sax25_call.ax25_call);
     if (digi.isEmpty())
     {
      SockAddr_dst.fsa_ax25.sax25_ndigis = 0;
     }
     else
     {
       strcpy(pp,bbs_w_ssid+" v "+digi);
       ax25_aton(pp, &SockAddr_dst);
     }
     ax25_aton_entry(tmp,SockAddr_src.fsa_ax25.sax25_call.ax25_call);
   }
   else
   {
     ax25_aton_entry(ConnTo, SockAddr_dst.fsa_ax25.sax25_call.ax25_call);
     ax25_aton_entry(tmp,    SockAddr_src.fsa_ax25.sax25_call.ax25_call);
     SockAddr_dst.fsa_ax25.sax25_ndigis = 0;
   }
   
   len = sizeof(struct full_sockaddr_ax25);
   
   ioctl(SocketFileDescriptor, FIONBIO,&i);
   
   
   if (bind(SocketFileDescriptor, (struct sockaddr *)&SockAddr_src, len) == -1)
     	QMessageBox::critical( List_window, "Connection error",  "Cannot bind" );
   
   //connect new socket
   if (::connect(SocketFileDescriptor, (struct sockaddr *)&SockAddr_dst, len) == -1)
     if (errno != EINPROGRESS)
     		QMessageBox::critical( List_window, "Connection error",  "Cannot connect" );

   /* wait for connection */
   if (WaitConnect(SocketFileDescriptor)==0) 
   {
     QMessageBox::critical( List_window, "Connection error",  "Cannot connect" );
   }
   else
   {
     FileDescriptor = fdopen(SocketFileDescriptor, "r+");
     Socket.setSocket( SocketFileDescriptor);
     connected = TRUE;
   }

  return connected;
    
}


bool TAxUnit::Telnet_BBS( QString Addr )
{

   sockaddr_in 	SockAddr;
   sockaddr_in 	LocSockAddr;
   int	       	SockAddrLen;
   QString	IP;
   QString	tmp,ttk;
   int		TCPPort;
   char		pp1[10];
   char		*pp=pp1;
   char		kk1[20];
   char		*kk=kk1;
   char		buffer[10];
     
   IsTelnet = TRUE;
   
   if (Addr.find(':', 0, FALSE)>=0)
   {
     tmp = Addr.stripWhiteSpace();
     IP = tmp.section(':',0,0);
     TCPPort = tmp.section(':',1,1).stripWhiteSpace().toInt();
   }
   else
   {
     IP = Addr;
     TCPPort = 23;
   } 
     
     //QMessageBox::information( List_window, "Connection",  "IP="+IP+" Port="+QString::number(TCPPort) );
      
   SockAddrLen = sizeof(LocSockAddr);
   
   LocSockAddr.sin_family = AF_INET;
   LocSockAddr.sin_port   = 0;  // htons(0)
   
   SocketFileDescriptor = socket( AF_INET, SOCK_STREAM, 0 );
   if (SocketFileDescriptor == -1 )
   {
     QMessageBox::critical( List_window, "Connection error",  "Cannot create socket" );
     connected = FALSE;
//     break;
   }
   
   strcpy(pp,port);   
   LocSockAddr.sin_addr.s_addr = inet_addr(pp);
   
   strcpy(kk,IP);
   
   SockAddr.sin_family		= AF_INET;
   SockAddr.sin_addr.s_addr	= inet_addr(kk);
   SockAddr.sin_port		= htons(TCPPort);
   
   if (::connect(SocketFileDescriptor,(struct sockaddr *)&SockAddr, SockAddrLen) == -1 )
   {
     QMessageBox::critical( List_window, "Connection error",  "Cannot connect to host" );
     close(SocketFileDescriptor);
     connected = FALSE;
//     break;
   }
   
   /* wait for connection */
   if (WaitConnect(SocketFileDescriptor)==0) 
   {
     QMessageBox::critical( List_window, "Connection error",  "Connectio failure !" );
     connected = FALSE;
   }
   else
   {
     
     FileDescriptor = fdopen(SocketFileDescriptor, "r+");
     read(SocketFileDescriptor, buffer, 3); //Added because FBB sends 0xff, 0x
     Socket.setSocket( SocketFileDescriptor);
     connected = TRUE;
   }
 /*     
      ::connect( SocketFileDescriptor, (struct sockaddr*)&SockAddr,   // connect to host
                   sizeof(SockAddr) );                    // NOT QObject::connect()!
     
    connected = FileDescriptor.open( IO_ReadWrite, SocketFileDescriptor);
    if (connected)
    {
     read(SocketFileDescriptor, buffer, 3); //Added because FBB sends 0xff, 0x
     DataStream.setDevice( &FileDescriptor );
    }
*/
  return connected;
  
  
}

void TAxUnit::DiscBBS( )
{
  // FileDescriptor.close();
  Socket.close();
  fclose(FileDescriptor);
  // DataStream.unsetDevice();
  close(SocketFileDescriptor);
}


void TAxUnit::WaitDisc( )
{
  QString line;
  int ch;

  
//   int ch;
  if (IsTelnet) 
  {
	  while (ch!= -1) ch=fgetc(FileDescriptor);
  }
  else
  {	  
   do
   {
	   Application->processEvents();
	   ch = fgetc(FileDescriptor); 
   } while (ch != -1 || errno != ENOTCONN);

  }
/*  while (Socket.bytesAvailable()>0 && Socket.state()==QSocket::Connected )
  {
    ch = Socket.getch();
    //ch = fgetc(FileDescriptor);
    Application->processEvents();
    if ((ch == 0x0a && IsTelnet) || (ch == 0x0d && ! IsTelnet))
    {     
	 ShExLineEvent* shln = new ShExLineEvent( line );
         QApplication::postEvent( ShellEx, shln );  // Qt will delete it when done
	 line = "";
    }
    else
      line += (char)(ch);
  }*/
}


void TAxUnit::WaitPrompt()
{
  WaitFor(BBSprompt); // QMessageBox::critical( List_window, "Connection error",  "prompt found" );
}



void TAxUnit::SendChar( unsigned char ch )
{
	Socket.putch( ch );
}


unsigned char TAxUnit::GetChar()
{
  int ch;
  
  while (Socket.bytesAvailable()<=0) Application->processEvents();
  ch = Socket.getch();
  return ch;
}




QString TAxUnit::GetLine()   //fgets_cr()
{
   QTextStream DataStream( FileDescriptor,IO_ReadWrite);
   QString line;
   unsigned char c;
   
   do
   {
     c = GetChar();  
//     Application->processEvents();
     if (c!='\n' && c!='\r') line += c;
   } while ((((c!=0x0d && IsTelnet) || (c!=0x0d && ( ! IsTelnet))) && StatusByte!=6));
   // was c!=0x0a %% IsTelnet
   return line;
}


// Send line; if CR is TRUE adds CR to the end of line and send it, else keep and send line as it is
void TAxUnit::SendLine( QString line, bool CR )
{
   QTextStream DataStream( FileDescriptor, IO_ReadWrite);
   QString tmp;
   
   while (Socket.bytesAvailable() > 0)
              Socket.getch();   
   
   if (StatusByte!=6 )
   {
     tmp = line;
              
     ShExLineEvent* shln = new ShExLineEvent( tmp );
     QApplication::postEvent( ShellEx, shln );  // Qt will delete it when done
     
     if ( CR )
     {
     	tmp += "\r";  // "\r" = 0x0d
   //  	if (IsTelnet) tmp += "\n";
     }
     DataStream.writeRawBytes(tmp, tmp.length());
   }
}





void TAxUnit::SendCR()
{
   QTextStream DataStream( FileDescriptor,IO_ReadWrite);
     
   do fgetc(FileDescriptor); while (errno == EAGAIN || errno == EINTR);
  
   if (StatusByte!=6) DataStream << "\r\n";
}




void TAxUnit::SendCommands( QString cmds )
{
//  QListBox *ShellOut = ShellEx->ShellOut;
  uint i;
  QString tmp;
  
  i = 0;
  tmp = "";
  
  while ((i < cmds.length() ) && (StatusByte != 6))
  {
     Application->processEvents();
     while (( i < cmds.length()) && ( cmds[i] != ';'))
       tmp += cmds[i++];  
     
     SendLine( tmp, TRUE );
    
     tmp = "";
     Application->processEvents();
     if (cmds[i]==';')
     {
       WaitPrompt();
       i++;
     }
  }

}

bool TAxUnit::WaitFor( QString line )
{
//  QListBox *ShellOut = ShellEx->ShellOut;
  QString tst;
  bool found;
  QTextStream DataStream( FileDescriptor,IO_ReadWrite);
  
  found = FALSE;
  tst = "";
  int ch;
  
//QMessageBox::information( List_window, "WaitFor",  line );
/* while (Socket.bytesAvailable() <=0) Application->processEvents();

 tst = DataStream.read();
      if (tst.find(line,0,FALSE)>=0)
      {
        found = TRUE;
      }
	ShExLineEvent* shln = new ShExLineEvent( tst );
        QApplication::postEvent( ShellEx, shln );*/
  
  while ((!found) && (StatusByte != 6) )
  {
    
    ch = GetChar();
    
    if (ch=='\r')
    {
      ShExLineEvent* shln = new ShExLineEvent( tst );
      QApplication::postEvent( ShellEx, shln );  // Qt will delete it when done
      tst = "";
    }
    else
    {
      if (ch != '\n') tst += ch;
      if (tst.find(line,0,FALSE)>=0)
      {
        found = TRUE;
	ShExLineEvent* shln = new ShExLineEvent( tst );
        QApplication::postEvent( ShellEx, shln );
      }
    }
    
    Application->processEvents();
  }
/*  if (found)
  {   
     do
     {
        ch = fgetc_unlocked(FileDescriptor);
     } while ((errno == EAGAIN || errno == EINTR));
  }*/
  
  return found;
}

bool TAxUnit::ConnectBBS()
{
  QString tmp;
  QString tst;
  bool Connected=FALSE;    
    
  tmp = PrgPath + "scripts/"+bbs_w_ssid+".con";

  QFile fl(tmp);
  if (fl.exists() )
  {
    IsScript = TRUE;
    if ( fl.open( IO_ReadOnly ) ) 
    {
      QTextStream stream( &fl );
      
      while ( ! stream.atEnd() ) //&& (! Connected) )
      {
         tmp = stream.readLine();
	 if ( (! tmp.isEmpty() ) && (tmp[0]!='#') && (tmp[0]!=';'))
	 {
//	   if ((tmp[1]!='#') && (tmp[1]!=';'))
//	   {
	     tst = Util.Get1Word(tmp).lower().stripWhiteSpace();
	     if (tst=="connectto")
	        Connected = AxCon_BBS( Util.Get2Word( tmp ).simplifyWhiteSpace());
	     if (tst=="waitfor") 
	       if (! WaitFor( Util.GetRest( tmp ).stripWhiteSpace())) 
	          QMessageBox::critical( List_window, "Script error",  tmp+" "+tst );
	     if (tst=="send") SendLine( Util.GetRest( tmp ).simplifyWhiteSpace(), TRUE);
	     if (tst=="waitprompt") WaitPrompt();
	     if (tst=="telnet") 
	        Connected = Telnet_BBS( Util.Get2Word( tmp ).simplifyWhiteSpace());
//	   }
	}
      }
      fl.close();
    }
    
  } // fl.exists()
  else
  {
    IsScript = FALSE;
    Connected = AxCon_BBS("");
    if (Connected)  WaitPrompt();
  }    
  
  if (Connected) StatusByte = 0;
  
  return Connected;
}


