/* --------------------------------------------------------------------	*
 * slave_add.c															*
 * 																		*
 * Slave program for adding elements of an array using PVM				*
 * --------------------------------------------------------------------	*/
#include <stdlib.h>
#include <pvm3.h>
#include "tags.h"
#include "common.h"

int main()
{
	int mytid, parent_tid;
	int items[DATA_SIZE];			/* data sent by the master	*/
	int sum, i;
	
	/* enroll into the PVM system		*/
	mytid = pvm_mytid();

	/* get the task ID of the master	*/
	parent_tid = pvm_parent();

	/* receive the data from the master	*/
	pvm_recv(parent_tid, MSG_DATA);
	pvm_upkint(items, DATA_SIZE, 1);

	/* find the sum of the elements 	*/
	sum = 0;
	for(i = 0; i < DATA_SIZE; i++)
		sum = sum + items[i];

	/* send the result to the master	*/
	pvm_initsend(PvmDataDefault);
	pvm_pkint(&sum, 1, 1);
	pvm_send(parent_tid, MSG_RESULT);

	/* clean up and exit from PVM		*/
	pvm_exit();
	
	exit(EXIT_SUCCESS);
} /* end main() */

