/*
   
        (c) 2006 by Thomas Michel <tom.michel@arcor.de>

        Kwlan is free software; you can redistribute it and/or modify
        it under the terms of the GNU Library General Public License as
        published by the Free Software Foundation; either version 2 of
        the License, or (at your option) any later version.

        Kwlan is distributed in the hope that it will be useful,
        but WITHOUT ANY WARRANTY; without even the implied warranty of
        MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
        GNU Library General Public License for more details.

        You should have received a copy of the GNU Library General Public License
        along with this library; see the file COPYING.LIB.  If not, write to
        the Free Software Foundation, Inc., 51 Franklin Steet, Fifth Floor,
        Boston, MA 02110-1301, USA.
*/

#include "kwlansettingsdlg.h"
#include "configuration.h"

#include <qcheckbox.h>
#include <qcombobox.h>
#include <qspinbox.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <qradiobutton.h>
#include <kfiledialog.h>

KwlanSettingsDlg::KwlanSettingsDlg(QWidget* parent, const char* name, bool modal, WFlags fl)
: KwlanSettings(parent,name, modal,fl)
{
    m_configuration = 0L;
}

KwlanSettingsDlg::~KwlanSettingsDlg()
{
}

/*$SPECIALIZATION$*/
void KwlanSettingsDlg::enableWpaNoQuestion(int state)
{
    cbWpaNoQuestion->setEnabled(state);
}
void KwlanSettingsDlg::customWpaConfigChanged(int state)
{
    leConfigFile->setEnabled(state);
    pbBrowseConfigFile->setEnabled(state);
}

void KwlanSettingsDlg::browseConfigFile()
{
    QString file = KFileDialog::getOpenFileName ();
    if (!file.isEmpty())
        leConfigFile->setText(file);
}

void KwlanSettingsDlg::Cancel()
{
    QWidget::close(true);
}

void KwlanSettingsDlg::Ok()
{
    if (!m_configuration)
    {
        QWidget::close(true);
        return;
    }
    m_configuration->m_startWpa = cbWpa->isChecked();
    m_configuration->m_startWpaNoQuestion = cbWpaNoQuestion->isChecked();
    m_configuration->m_useCustomWpaConf = cbUseCustomConfigFile->isChecked();
    m_configuration->m_customWpaConf = leConfigFile->text();
    if (rbScan0->isChecked())
        m_configuration->m_ap_scan = 0;
    else if (rbScan1->isChecked())
        m_configuration->m_ap_scan = 1;
    else m_configuration->m_ap_scan = 2;
    m_configuration->writeSettings();
    QWidget::close(true);
}

void KwlanSettingsDlg::setConfiguraton(Configuration *conf)
{
    m_configuration = conf;
    if (!conf) return;
    cbWpa->setChecked(m_configuration->m_startWpa);
    cbWpaNoQuestion->setChecked(m_configuration->m_startWpaNoQuestion);
    cbUseCustomConfigFile->setChecked(m_configuration->m_useCustomWpaConf);
    leConfigFile->setText(m_configuration->m_customWpaConf);
    switch (m_configuration->m_ap_scan)
    {
        case 0: 
            rbScan0->setChecked(TRUE);
            break;
        case 1: 
            rbScan1->setChecked(TRUE);
            break;
        default:
            rbScan2->setChecked(TRUE);
    }
}

#include "kwlansettingsdlg.moc"

