/*
   
        (c) 2006 by Thomas Michel <tom.michel@arcor.de>

        Kwlan is free software; you can redistribute it and/or modify
        it under the terms of the GNU Library General Public License as
        published by the Free Software Foundation; either version 2 of
        the License, or (at your option) any later version.

        Kwlan is distributed in the hope that it will be useful,
        but WITHOUT ANY WARRANTY; without even the implied warranty of
        MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
        GNU Library General Public License for more details.

        You should have received a copy of the GNU Library General Public License
        along with this library; see the file COPYING.LIB.  If not, write to
        the Free Software Foundation, Inc., 51 Franklin Steet, Fifth Floor,
        Boston, MA 02110-1301, USA.
*/

#ifndef __KWLANMAINTRAYWIN__
#define  __KWLANMAINTRAYWIN__

#include <ksystemtray.h>
#include <qtooltip.h>

class QWidget;
class QPopupMenu;
class KwlanToolTip;
class KAction;


class KwlanMainToolTip : public QToolTip {

    public:
        KwlanMainToolTip(QWidget *parent);
        virtual ~KwlanMainToolTip();
	
    protected:
        void maybeTip(const QPoint &);
};


class KwlanMainTrayWin : public KSystemTray
{
    Q_OBJECT
    public:
        KwlanMainTrayWin(QWidget *parent=0, const char *name=0);
        virtual ~KwlanMainTrayWin();
        void contextMenuAboutToShow( KPopupMenu *r );
    public slots:
        void slotHandleInterfacesMenu(int id);
        void slotHandleConfigureInterfacesMenu(int);
        void slotSettingsMenu();
    signals:
        void aboutSelected();
        void sigMonitorInterface(QString interface, bool showWin);
        void sigConfigureInterface(QString interface, bool configure);
    protected:
        KAction *m_quit, *m_about;
        KwlanMainToolTip *m_tooltip;
    private:
        KPopupMenu *m_interfacesMenu;
        KPopupMenu *m_configureInterfacesMenu;
        KAction *m_settingsMenu;
  
};


#endif
