

#include "kwlanmainsettingsdlg.h"
#include "configuration.h"

#include "qspinbox.h"
#include "qcheckbox.h"

#include <kmessagebox.h>

KWlanMainSettingsDlg::KWlanMainSettingsDlg(QWidget* parent, const char* name, bool modal, WFlags fl)
: KWlanMainSettings(parent,name, modal,fl)
{
    int res;
    KMessageBox::setDontShowAskAgainConfig(mainConfiguration().m_configuration);
    cbMinimized->setChecked(mainConfiguration().readStartMinimized());
    res = KMessageBox::shouldBeShownContinue("newinterfacewizzard");
    if (res) cbNewInterfaceWizzard->setEnabled(FALSE);
    res = KMessageBox::shouldBeShownContinue("dontwarnnowpa");
    if (res) cbWpaWarning->setEnabled(FALSE);
    sbPasswordTime->setValue(PasswordCache().m_pwexpire);
}

KWlanMainSettingsDlg::~KWlanMainSettingsDlg()
{
}


/*$SPECIALIZATION$*/
void KWlanMainSettingsDlg::Cancel()
{
    QWidget::close(true);
}

void KWlanMainSettingsDlg::Ok()
{
    mainConfiguration().writeStartMinimized(cbMinimized->isChecked());
    if (cbNewInterfaceWizzard->isChecked())
    {
        KMessageBox::enableMessage("newinterfacewizzard");
    }
    if (cbWpaWarning->isChecked())
    {
        KMessageBox::enableMessage("dontwarnnowpa");
    }
    PasswordCache().m_pwexpire = sbPasswordTime->value();
    PasswordCache().writePasswordExpire();
    QWidget::close(true);

}



#include "kwlanmainsettingsdlg.moc"

