#include "kwlanapplication.h"
#include "kwlanmainwin.h"
#include "kwlaninterface.h"
#include "kwlansuprocess.h"
#include "dialup.h"

#include <klocale.h>
#include <qstringlist.h>
#include <kprocess.h>
#include <qdir.h>
#include <kdebug.h>
#include <kmessagebox.h>

KWlanApplication::KWlanApplication(bool allowStyles, bool GUIenabled, bool configUnique)
    : KUniqueApplication(allowStyles, GUIenabled, configUnique)
{
}

 KWlanApplication::~KWlanApplication()
{
}

void KWlanApplication::init()
{
    QDir dir;
    KConfig* config = KGlobal::config();
    config->setGroup("super-user-command");
    QString suCommand = config->readEntry("super-user-command", DEFAULT_SUPER_USER_COMMAND);
    if ( suCommand != "sudo" && suCommand != "su" ) {
        KMessageBox::error(0,i18n("No valid super-user command found. KWlan won't be able to do any configurations"));
    } else 
    {
        QString suPath = getPath(suCommand);
        if (suPath.isEmpty())
        {
            KMessageBox::error(0,QString(i18n("Cannot find %1 in the path. KWlan won't be able to do any configuration.")).arg(suCommand));
        }   
    }
    // First check for existing directory for dialup networking
    if (dir.exists("/etc/ppp/peers"))
    {
        // ppp peers directory exists, now check for kwlan dir
        if (!dir.exists(PPP_PEERS))
        {
            KWlanSuProcess *proc = new KWlanSuProcess();
            *proc << "mkdir" << PPP_PEERS;
            proc->setDescription( i18n("create kwlan dialup peer directory"));
            proc->start();
        }

    } else kdDebug() <<   i18n("/etc/ppp/peers does not exist. Dialup networking will not work.") << endl;
    KWlanMainWin *mainWin = new KWlanMainWin();
    mainWin->init();
}


