/***************************************************************************
 *   Copyright (C) 2004 by Matthias Reif                                   *
 *   matthias.reif@informatik.tu-chemnitz.de                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef KTXPOWERGROUP_H
#define KTXPOWERGROUP_H

using namespace std;
#include <vector>

#include <klocale.h>
#include <qbuttongroup.h>
#include <qradiobutton.h>
#include <kcombobox.h>
#include <qlabel.h>

#include "kwavecontrol.h"
#include "wcard.h"
#include "wcardlib.h"

/**
@author Matthias Reif
*/
class KTxPowerGroup : public QButtonGroup
{
Q_OBJECT
public:
	KTxPowerGroup( QString title, QWidget *parent = 0, const char *name = 0);

	~KTxPowerGroup();
	bool insertTxPowers( WCard* card );
	void setTxPower( bool disabled, bool fixed, int value, int unit );
	TxPower current();
	void clear();

protected:
	QRadioButton* txPowerOffButton;
	QRadioButton* txPowerAutoButton;
	QRadioButton* txPowerFixedButton;
	QLabel* powerModes;
	KComboBox* powerSelection;
	vector<TxPower> txPowers;
	int numTxPowers;
public slots:
	void changedSlot();
signals:
	void changed( bool disabled, bool fixed, int value, int unit );
protected:
	virtual void resizeEvent( QResizeEvent * event ) ;
};

#endif
