/***************************************************************************
 *   Copyright (C) 2004 by Matthias Reif                                   *
 *   matthias.reif@informatik.tu-chemnitz.de                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef KSCANWIDGET_H
#define KSCANWIDGET_H

using namespace std;
#include <vector>
#include <map>

#include <math.h>
#include <kpushbutton.h>
#include <klistview.h>
#include <qheader.h>
#include <qlabel.h>

#include <kiconloader.h>

#include "kwavecontrol.h"

#include "wcardlib.h"
#include "wcard.h"

class WWidget;

/**
@author Matthias Reif
*/
class KScanWidget : public QWidget
{
Q_OBJECT
public:
	KScanWidget( WWidget* wWidget, QWidget* parent = 0, const char *name = 0 );

	~KScanWidget();
	void update( WCard* card, APInfos apInfos );
	void setScanning( bool scanning = true );
	void setScanningEnabled( bool enabled );

protected:
	KListView* listView;
	KListViewItem* lastApItem;
	
	QString getKey( const unsigned char* data, int length, int flags );
	void hideCols();
	void resizeEvent ( QResizeEvent * );

	map< int, QString > sorting;
	vector<KListViewItem*> newSubItems;
	
	QLabel* scanningLabel;
	
	WWidget* wWidget;
	
	map< QListViewItem*, double > frequencies;
	
	KPushButton* scanButton;
	KPushButton* connectButton;
	
protected slots:
	void connectSlot();
	void scanSlot();
	void selectionChangedSlot();
};

#endif
