/***************************************************************************
 *   Copyright (C) 2004 by Matthias Reif                                   *
 *   matthias.reif@informatik.tu-chemnitz.de                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "kpowergroup.h"

KPowerGroup::KPowerGroup( QString title, QWidget *parent, const char *name ) : QButtonGroup( title, parent, name )
{
	setInsideMargin( 25 );
	enableRadio = new QRadioButton( i18n( "enabled" ), this );
	disableRadio = new QRadioButton( i18n( "disabled" ), this );
	enableRadio->adjustSize();
	disableRadio->adjustSize();
	disableRadio->move( KWaveControl::SPACING, 25 );
	enableRadio->move( disableRadio->x() + disableRadio->width() + KWaveControl::SPACING, disableRadio->y() );
	
	modeSelection = new KComboBox( this );
	modeSelection->move( disableRadio->x(), disableRadio->y() + disableRadio->height() + KWaveControl::SPACING );

	modeSelection->adjustSize();
	adjustSize();

	connect( this, SIGNAL( clicked( int ) ), this, SLOT( changedSlot() ) );
	connect( modeSelection, SIGNAL( activated( int ) ), this, SLOT( changedSlot( int) ) );
}


KPowerGroup::~KPowerGroup()
{
}


/*!
	\fn KPowerGroup::insertPowers( WCard* card )
 */
void KPowerGroup::insertPowers( WCard* card )
{
	this->setEnabled( card->has.power );
	modeSelection->clear();
	modes.clear();
	if( card->has.power )
	{
		modeSelection->setEnabled( card->range->pm_capa & IW_POWER_MODE );
		if( card->range->pm_capa & IW_POWER_MODE )
		{
			if( card->range->pm_capa & ( IW_POWER_UNICAST_R | IW_POWER_MULTICAST_R ) )
			{
				modeSelection->insertItem( i18n( "Receive all packets" ) );
				modes.push_back( IW_POWER_ALL_R );
			}
			if( card->range->pm_capa & IW_POWER_UNICAST_R )
			{
				modeSelection->insertItem( i18n( "Receive Unicast only" ) );
				modes.push_back( IW_POWER_UNICAST_R );
			}
			if( card->range->pm_capa & IW_POWER_MULTICAST_R )
			{
				modeSelection->insertItem( i18n( "Receive Multicast only" ) );
				modes.push_back( IW_POWER_MULTICAST_R );
			}
			if( card->range->pm_capa & IW_POWER_FORCE_S )
			{
				modeSelection->insertItem( i18n( "Force sending using Power Management" ) );
				modes.push_back( IW_POWER_FORCE_S );
			}
			if( card->range->pm_capa & IW_POWER_REPEATER )
			{
				modeSelection->insertItem( i18n( "Repeat multicast" ) );
				modes.push_back( IW_POWER_REPEATER );
			}
		}
	}
}

/*!
    \fn KPowerGroup::setPower( bool enabled, int flags )
 */
void KPowerGroup::setPower( bool enabled, int flags )
{
	enableRadio->setChecked( enabled );
	disableRadio->setChecked( ! enabled );
	int mode = flags & IW_POWER_MODE;
	unsigned int i;
	for( i = 0; i < modes.size(); i++ )
	{
		if( mode == modes[i] )
			break;
	}
	if( i < modes.size() )
	{
		modeSelection->setCurrentItem( i );
	}
	else
	{
		if( mode == IW_POWER_ALL_R )
		{
			modeSelection->insertItem( i18n( "Receive all packets" ) );
		}
		else if( mode == IW_POWER_UNICAST_R )
		{
			modeSelection->insertItem( i18n( "Receive Unicast only" ) );
		}
		else if( mode == IW_POWER_MULTICAST_R )
		{
			modeSelection->insertItem( i18n( "Receive Multicast only" ) );
		}
		else if( mode == IW_POWER_FORCE_S )
		{
			modeSelection->insertItem( i18n( "Force sending using Power Management" ) );
		}
		else if( mode == IW_POWER_REPEATER )
		{
			modeSelection->insertItem( i18n( "Repeat multicast" ) );
		}
		else
		{
			modeSelection->insertItem( "<" + i18n( "unknown mode" ) + ">" );
		}
		modes.push_back( mode );
	}
}


/*!
	\fn KPowerGroup::changedSlot( int index )
 */
void KPowerGroup::changedSlot( int index )
{
	if( index < 0 )
		index = modeSelection->currentItem();
	changed( enableRadio->isOn(), modes[ index ] );
}



/*!
    \fn KPowerGroup::resizeEvent( QResizeEvent * event )
 */
void KPowerGroup::resizeEvent( QResizeEvent * event )
{
	QButtonGroup::resizeEvent( event );
	modeSelection->resize( this->width() - 2 * KWaveControl::SPACING, modeSelection->height() );
}


#include "kpowergroup.moc"
