// =============================================================================
//
//      --- kvi_query.cpp ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#define _KVI_DEBUG_CHECK_RANGE_
#define _KVI_DEBUG_CLASS_NAME_ "KviQuery"

#include <qsplitter.h>

#include "kvi_frame.h"
#include "kvi_input.h"
#include "kvi_irc_view.h"
#include "kvi_locale.h"
#include "kvi_options.h"
#include "kvi_query.h"
#include "kvi_statusbar.h"
#include "kvi_userparser.h"
#include "kvi_userpopupmenu.h"

// Declared in kvi_app.cpp and managed by KviApp class
extern QPixmap          *g_pixViewOut[KVI_OUT_NUM_IMAGES];
extern KviUserPopupMenu *g_pQueryPopup;

/**
 * ============ KviQuery ============
 */
KviQuery::KviQuery(KviFrame *lpFrm, const char *name)
	: KviWindow(name, KVI_WND_TYPE_QUERY, lpFrm)
{
	// TODO: Set the query caption on locally requested queries when the remote complete mask is known
	m_pSplitter = new QSplitter(QSplitter::Horizontal, this);
	m_pSplitter->setOpaqueResize();
	m_pView     = new KviIrcView(m_pSplitter, lpFrm, this);
	m_pView->enableDnD(true);
	connect(m_pView, SIGNAL(fileDropped(const char *)), this, SLOT(fileDroppedOnView(const char *)));
	connect(m_pView, SIGNAL(dndEntered()), this, SLOT(dndEnteredView()));
	m_pInput    = new KviInput(this, lpFrm->m_pUserParser);
	connect(m_pView, SIGNAL(contextPopupRequested(KviIrcView *)), this, SLOT(viewRightClicked(KviIrcView *)));
}

/**
 * ============ ~KviQuery ============
 */
KviQuery::~KviQuery()
{
	// Nothing here
}

void KviQuery::dndEnteredView()
{
	m_pFrm->m_pStatusBar->tempText(_i18n_("Drop the file to start the DCC Send"), 5000);
}

void KviQuery::fileDroppedOnView(const char *fileName)
{
	QString tmp(fileName);
	tmp.prepend(" ");
	tmp.prepend(caption());
	tmp.prepend("/DCC SEND ");
	m_pFrm->m_pUserParser->parseUserCommand(tmp, this);
}

void KviQuery::viewRightClicked(KviIrcView *)
{
	g_pQueryPopup->doPopup(this, SLOT(viewPopupClicked(const KviStr &)));
}

void KviQuery::viewPopupClicked(const KviStr &dataBuffer)
{
	m_pFrm->m_pUserParser->parseCommand(dataBuffer.ptr(), this);
}

/**
 * ================ myIconPtr =================
 */
QPixmap *KviQuery::myIconPtr()
{
	return g_pixViewOut[KVI_OUT_WND_QUERY];
}

/**
 * =============== applyOptions ================
 */
void KviQuery::applyOptions()
{
	m_pView->setFont(g_pOptions->m_fntView);
	m_pView->setShowImages(g_pOptions->m_bShowImages, false);
	m_pView->setTimestamp(g_pOptions->m_bTimestamp);
	m_pView->setMaxBufferSize(g_pOptions->m_iViewMaxBufferSize);
}

/**
 * ================ resizeEvent ===============
 */
void KviQuery::resizeEvent(QResizeEvent *)
{
	int inputSize = m_pInput->heightHint();
	   m_pInput->setGeometry(0, height() - inputSize, width(), inputSize);
	m_pSplitter->setGeometry(0, 0, width(), height() - inputSize);
}

#include "m_kvi_query.moc"
