#ifndef _KVI_VARIABLECACHE_H_INCLUDED_
#define _KVI_VARIABLECACHE_H_INCLUDED_

// =============================================================================
//
//      --- kvi_variablecache.h ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#include <qptrlist.h>

#include "kvi_string.h"

class KviVariableCache;

/**
 * Variable entry.
 */
typedef struct
{
	KviStr szName;
	KviStr szValue;
} KviVariable;

/**
 * Array like dictionary %dict[key]
 */
typedef struct
{
	KviStr szName;                 // Dict name (corresponds to the array name).
	KviVariableCache *m_pVarCache; // Values associated with each key.
} KviDictionary;

class KviVariableCache
{
	friend class KviUserParser;
	friend class KviVariablesEditor;
public:
	KviVariableCache();
	~KviVariableCache();
protected:
	QPtrList<KviVariable>   *m_pVarList;
	QPtrList<KviDictionary> *m_pDictList;
protected:
	KviVariable *insertNewVariable(const char *name, const char *value);
	KviVariable *set(const char *name, const char *value);
	void concat(const char *name, const char *value);
	void concatWithSeparator(const char *name, char sep, const char *value);
	void unset(const char *name);
	const char *find(const char *name);
	QPtrList<KviVariable> *variableList();
	KviVariable *getVariable(const char *name);

	// Dictionaries
	void deleteDict(KviDictionary *dict);
	KviDictionary *insertNewDict(const char *name);
	KviDictionary *getDict(const char *name);
	KviVariable *getDictVariable(const char *dictname, const char *varname);
	const char *findDictVariable(const char *dictname, const char *varname);
	KviVariable *setDictVariable(const char *dictname, const char *varname, const char *value);
	void  unsetDictVariable(const char *dictname, const char *varname);
	void concatDictVariable(const char *dictname, const char *varname, const char *value);
	void concatWithSeparatorDictVariable(const char *dictname, const char *varname, char sep, const char *value);
	QPtrList<KviDictionary> *dictList();
};

#endif // _KVI_VARIABLECACHE_H_INCLUDED_
