//=============================================================================
//
//   File : kvi_up_fnc.cpp
//   Creation date : Mon Jul 03 2000 20:41:21 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2002 Szymon Stefanek (pragma at kvirc dot net)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//=============================================================================

#define __KVIRC__

#include "kvi_debug.h"
#include "kvi_uparser.h"
#include "kvi_command.h"
#include "kvi_app.h"
#include "kvi_error.h"
#include "kvi_frame.h"
#include "kvi_window.h"
#include "kvi_locale.h"
#include "kvi_console.h"
#include "kvi_query.h"
#include "kvi_channel.h"
#include "kvi_scriptobject.h"
#include "kvi_modulemanager.h"
#include "kvi_parameterlist.h"
#include "kvi_ircuserdb.h"
#include "kvi_avatar.h"
#include "kvi_ircuserdb.h"
#include "kvi_mirccntrl.h"
#include "kvi_iconmanager.h"
#include "kvi_options.h"
#include "kvi_ircconnection.h"
#include "kvi_ircconnectionuserinfo.h"
#include "kvi_input.h"

#ifdef COMPILE_NEW_KVS
	#include "kvi_kvs_object.h"
	#include "kvi_kvs_kernel.h"
	#include "kvi_kvs_object_class.h"
	#include "kvi_kvs_object_controller.h"
	#include "kvi_kvs_corefunctions.h"
	#include "kvi_kvs_moduleinterface.h"
#endif

#include <stdlib.h> // for rand()
#include <time.h>   // for time()

#include <qregexp.h>


// kvi_app.cpp
extern QAsciiDict<KviWindow> * g_pGlobalWindowDict;
//extern KviTimerManager * g_pTimerManager;

void KviUserParser::initFunctionDict()
{
	m_pFunctionDict = new QAsciiDict<KviFunctionParseProc>(109);
	m_pFunctionDict->setAutoDelete(true);

	KviFunctionParseProc * p;

#define ALLOC_PARSE_PROC(__proc) \
	p = new KviFunctionParseProc; \
	p->proc = KVI_PTR2MEMBER(KviUserParser::__proc)

#define FNC_REG(__name,__proc) \
	ALLOC_PARSE_PROC(__proc); \
	m_pFunctionDict->insert(__name,p);

	/*
	FNC_REG("WINDOW",parseFnc_WINDOW);
	FNC_REG("CHANNEL",parseFnc_CHANNEL);
	FNC_REG("QUERY",parseFnc_QUERY);
	FNC_REG("CONSOLE",parseFnc_CONSOLE);
	FNC_REG("CONTEXT",parseFnc_CONTEXT);
	FNC_REG("IC",parseFnc_CONTEXT);
	FNC_REG("NEW",parseFnc_NEW);
	FNC_REG("THIS",parseFnc_THIS);
	FNC_REG("RAND",parseFnc_RAND);
	FNC_REG("UNIXTIME",parseFnc_UNIXTIME);
	FNC_REG("SELECTED",parseFnc_SELECTED);
	FNC_REG("ISMEOP",parseFnc_ISMEOP);
	FNC_REG("TARGET",parseFnc_TARGET);
	FNC_REG("OPTION",parseFnc_OPTION);
	FNC_REG("MASK",parseFnc_MASK);
	FNC_REG("AVATAR",parseFnc_AVATAR);
	FNC_REG("ISTIMER",parseFnc_ISTIMER);
	FNC_REG("AWAY",parseFnc_AWAY);
	FNC_REG("ISWELLKNOWN",parseFnc_ISWELLKNOWN);
	FNC_REG("USERNAME",parseFnc_USERNAME);
	FNC_REG("HOSTNAME",parseFnc_HOSTNAME);
	FNC_REG("SERVER",parseFnc_SERVER);
	FNC_REG("FMTLINK",parseFnc_FMTLINK);
	FNC_REG("LF",parseFnc_LF);
	FNC_REG("CR",parseFnc_CR);
	FNC_REG("ASCII",parseFnc_ASCII);
	FNC_REG("CHAR",parseFnc_CHAR);
	FNC_REG("K",parseFnc_K);
	FNC_REG("B",parseFnc_B);
	FNC_REG("U",parseFnc_U);
	FNC_REG("O",parseFnc_O);
	FNC_REG("R",parseFnc_R);
	FNC_REG("ISANYCONSOLECONNECTED",parseFnc_ISANYCONSOLECONNECTED);
	FNC_REG("ME",parseFnc_ME);
	FNC_REG("TIME",parseFnc_TIME);
	FNC_REG("DATE",parseFnc_DATE);
	FNC_REG("BASE64TOTEXT",parseFnc_BASE64TOASCII);
	FNC_REG("HEXTOASCII",parseFnc_HEXTOASCII);
	FNC_REG("ACTIVE",parseFnc_ACTIVE);
	FNC_REG("ISMEVOICE", parseFnc_ISMEVOICE);
	FNC_REG("ISMEHALFOP", parseFnc_ISMEHALFOP);
	FNC_REG("ISMEUSEROP", parseFnc_ISMEUSEROP);
	FNC_REG("INPUTTEXT", parseFnc_INPUTTEXT);
	FNC_REG("CLASSDEFINED",parseFnc_CLASSDEFINED);
	FNC_REG("FEATURES",parseFnc_FEATURES);
	FNC_REG("VERSION",parseFnc_VERSION);
	FNC_REG("SPLIT",parseFnc_SPLIT);
	FNC_REG("ICON",parseFnc_ICON);
	FNC_REG("ICONNAME",parseFnc_ICONNAME);
	FNC_REG("SW",parseFnc_SW);
	FNC_REG("ISMAINWINDOWMINIMIZED",parseFnc_ISMAINWINDOWMINIMIZED);
	FNC_REG("MSGTYPE",parseFnc_MSGTYPE);
	FNC_REG("ARRAY",parseFnc_ARRAY);
	FNC_REG("TR",parseFnc_TR);
	FNC_REG("ASCIITOHEX",parseFnc_ASCIITOHEX);
	FNC_REG("ASCIITOBASE64",parseFnc_ASCIITOBASE64);
	FNC_REG("ISMAINWINDOWACTIVE",parseFnc_ISMAINWINDOWACTIVE);
	FNC_REG("FIRSTCONNECTEDCONSOLE",parseFnc_FIRSTCONNECTEDCONSOLE);
	*/
}

// FIXME: $eval ???




