// =============================================================================
//
//      --- kvi_fontselector.cpp ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#define _KVI_DEBUG_CHECK_RANGE_
#define _KVI_DEBUG_CLASS_NAME_ "KviFontSelector"

#include "kvi_fontbutton.h"
#include "kvi_fontselector.h"
#include "kvi_label.h"
#include "kvi_string.h"

/**
 * KviFontSelector
 */
KviFontSelector::KviFontSelector(QWidget *parent, const char *label, QFont *valuePtr, bool bEnabled, int defInputWidth)
	: QWidget(parent)
{
	m_valuePtr       = valuePtr;
	m_pLabel         = new KviLabel(_CHAR_2_QSTRING(label), this);
	QFont tmp(*valuePtr);
	m_pFntButton     = new KviFontButton(this, tmp);
	m_iDefInputWidth = defInputWidth;
	setMinimumSize(sizeHint());
	setEnabled(bEnabled);
}

KviFontSelector::~KviFontSelector()
{
	// Nothing here
}

void KviFontSelector::commitChanges()
{
	*m_valuePtr = m_pFntButton->getSelectedFont();
}

QFont KviFontSelector::getFont()
{
	return m_pFntButton->getSelectedFont();
}

QSize KviFontSelector::sizeHint()
{
	QSize sz = m_pLabel->sizeHint();
	sz.setWidth(sz.width() + m_iDefInputWidth);
	sz.setHeight(m_pLabel->sizeHint().height());
	if( sz.height() < 24 ) sz.setHeight(24);
	return sz;
}

void KviFontSelector::resizeEvent(QResizeEvent *)
{
	m_pLabel->setGeometry(0, 0, width() - (m_iDefInputWidth + 1), height());
	m_pFntButton->setGeometry(width() - m_iDefInputWidth, 0, m_iDefInputWidth, height());
}

#include "m_kvi_fontselector.moc"
