/**vim: ts=4, wrap, tw=80
  *
  *		--- libkvistatwindow.h ---
  *
  * This is a plugin for KVirc 2.0 Phoenix. It allows you to see
  * statistics of your IRC sessions - total words said etc.
  * More features are still to come.
  *
  * (c) Krzysztof Godlewski <kristoff@poczta.wprost.pl>
  *
  * 
  * This program is FREE software. You can redistribute it and/or
  * modify it under the terms of the GNU General Public License
  * as published by the Free Software Foundation; either version 2
  * of the License, or (at your opinion) any later version.
  *
  * This program is distributed in the HOPE that it will be USEFUL,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  * See the GNU General Public License for more details.

  * You should have received a copy of the GNU General Public License
  * along with this program. If not, write to the Free Software Foundation,
  * Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
  **/

#ifndef LIBKVISTATWINDOW_H
#define LIBKVISTATWINDOW_H

#include <qtabdialog.h>
#include <qvbox.h>
#include <qhbox.h>
#include <qlist.h>
#include <qlabel.h>
#include <qlistview.h>

class KviStatWindow : public QTabDialog
{
	Q_OBJECT
	
public:
	KviStatWindow();
	~KviStatWindow();

	void updateStats();
	
private:
	QList<QLabel>	labels;
	QListView		*m_chansView;

private slots:
	void slotRemoveChan();
};

#endif	// ! LIBKVISTATWINDOW_H
