//
//   SPEAK plugin for KVirc 1.1 Phoenix.
//
//   This plugin enables you to use IBM's ViaVoiceOutloud to speak
//   messages to you.  Messages that are directed to you, over the
//   Relay Chat, can be spoken outloud or sentences spoken by specific
//   people can also heard outloud.
//
//   To use the plugin, one needs to have a working IBM ViaVoice
//   Outloud, which can be retrieved from IBM's site.  For information
//   about IBM ViaVoice http://www-4.ibm.com/software/speech/dev/
//
//   Copyright (C) rn E. Hansen (oe.hansen@gamma.telenordia.se)
//   Copyright (C) Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#ifndef eciSetupData_included
#define eciSetupData_included

#include <qdialog.h>
#include <qlabel.h>
#include <qcheckbox.h>
#include <qslider.h>

class eciSetupData : public QDialog
{
    Q_OBJECT

public:

    eciSetupData(QWidget *parent = NULL, const char *name = NULL);

    virtual ~eciSetupData();

    protected slots:

    virtual void grandpa() =0;
    virtual void volumeValue(int) =0;
    virtual void pitchBaseValue(int) =0;
    virtual void female() =0;
    virtual void cancelPressed() =0;
    virtual void male1() =0;
    virtual void testPressed() =0;
    virtual void male2() =0;
    virtual void speedValue(int) =0;
    virtual void headValue(int) =0;
    virtual void genderValue(bool) =0;
    virtual void okPressed() =0;
    virtual void breathinessValue(int) =0;
    virtual void child() =0;
    virtual void grandma() =0;
    virtual void pitchRangeValue(int) =0;
    virtual void roughnessValue(int) =0;

    protected:

    QSlider *m_pPitchbase;
    QSlider *m_pPitchrange;
    QSlider *m_pRoughness;
    QSlider *m_pSpeed;
    QSlider *m_pHeadsize;
    QSlider *m_pVolume;
    QSlider *m_pBreathiness;
    QCheckBox *m_pGender;
    QLabel *m_pAnnotations;
};

#endif // eciSetupData_included
