//
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//


#define __KVIRC_PLUGIN__

#include "kvirc_plugin.h"

#include "libkvieditor.h"

#include "kvi_locale.h"

//#include <qtoolbutton.h>
#include <qpopupmenu.h>
#include <qfiledialog.h>
//#include <qglobal.h>
//#include <qfiledialog.h>
//#include <qdir.h>
//#include <qfileinfo.h>

static QPixmap * g_pIcon;

const char * editor_icon_xpm[] = {
"16 16 171 2",
"  	c None",
". 	c #FFFFFF",
"+ 	c #F7F7F7",
"@ 	c #EFEFEF",
"# 	c #E7E7E7",
"$ 	c #DFDFDF",
"% 	c #D7D7D7",
"& 	c #CFCFCF",
"* 	c #C7C7C7",
"= 	c #BFBFBF",
"- 	c #B7B7B7",
"; 	c #AFAFAF",
"> 	c #A7A7A7",
", 	c #9F9F9F",
"' 	c #979797",
") 	c #8F8F8F",
"! 	c #878787",
"~ 	c #000000",
"{ 	c #090909",
"] 	c #121212",
"^ 	c #1B1B1B",
"/ 	c #242424",
"( 	c #2D2D2D",
"_ 	c #363636",
": 	c #3F3F3F",
"< 	c #484848",
"[ 	c #515151",
"} 	c #5B5B5B",
"| 	c #646464",
"1 	c #6D6D6D",
"2 	c #767676",
"3 	c #7F7F7F",
"4 	c #C1C1C1",
"5 	c #B0A7A7",
"6 	c #B69494",
"7 	c #AC8484",
"8 	c #A47676",
"9 	c #986666",
"0 	c #8E5656",
"a 	c #874B4B",
"b 	c #803F3F",
"c 	c #773434",
"d 	c #292929",
"e 	c #777777",
"f 	c #B1B1B1",
"g 	c #C1A3A3",
"h 	c #FF9393",
"i 	c #FF8383",
"j 	c #FF7575",
"k 	c #FF6666",
"l 	c #FF5656",
"m 	c #FF4B4B",
"n 	c #FF4040",
"o 	c #FF3333",
"p 	c #572727",
"q 	c #888888",
"r 	c #6F6F6F",
"s 	c #A8A8A8",
"t 	c #A4A4A4",
"u 	c #999999",
"v 	c #BD8B8B",
"w 	c #FF7E7E",
"x 	c #FF7171",
"y 	c #966262",
"z 	c #8D5555",
"A 	c #864A4A",
"B 	c #D33F3F",
"C 	c #FF3232",
"D 	c #9D2525",
"E 	c #919191",
"F 	c #676767",
"G 	c #949494",
"H 	c #939393",
"I 	c #8A8A8A",
"J 	c #D48383",
"K 	c #FF7777",
"L 	c #EC6A6A",
"M 	c #5C5C5C",
"N 	c #525252",
"O 	c #854848",
"P 	c #3D3D3D",
"Q 	c #D02E2E",
"R 	c #E52323",
"S 	c #9A9A9A",
"T 	c #5F5F5F",
"U 	c #848484",
"V 	c #838383",
"W 	c #E07777",
"X 	c #FF6C6C",
"Y 	c #C96161",
"Z 	c #575757",
"` 	c #AF4C4C",
" .	c #D44242",
"..	c #393939",
"+.	c #442D2D",
"@.	c #222222",
"#.	c #A3A3A3",
"$.	c #757575",
"%.	c #717171",
"&.	c #FF6A6A",
"*.	c #FF6161",
"=.	c #FF5757",
"-.	c #FF5050",
";.	c #FF4747",
">.	c #BD3C3C",
",.	c #343434",
"'.	c #2A2A2A",
").	c #1F1F1F",
"!.	c #ADADAD",
"~.	c #4F4F4F",
"{.	c #666666",
"].	c #976363",
"^.	c #FF5C5C",
"/.	c #9D5050",
"(.	c #C24747",
"_.	c #A53636",
":.	c #2E2E2E",
"<.	c #3C2424",
"[.	c #191919",
"}.	c #B6B6B6",
"|.	c #474747",
"1.	c #A05555",
"2.	c #FF5151",
"3.	c #FF4D4D",
"4.	c #804141",
"5.	c #FF3838",
"6.	c #742E2E",
"7.	c #3E2626",
"8.	c #FF1919",
"9.	c #7B0F0F",
"0.	c #4D4D4D",
"a.	c #C34A4A",
"b.	c #D34242",
"c.	c #303030",
"d.	c #3F2727",
"e.	c #E31C1C",
"f.	c #FF1010",
"g.	c #290E0E",
"h.	c #C8C8C8",
"i.	c #373737",
"j.	c #544040",
"k.	c #824242",
"l.	c #FF3E3E",
"m.	c #FF3B3B",
"n.	c #E73737",
"o.	c #BA3131",
"p.	c #B82B2B",
"q.	c #B62424",
"r.	c #FF1C1C",
"s.	c #FF1212",
"t.	c #930C0C",
"u.	c #0D0D0D",
"v.	c #D1D1D1",
"w.	c #2F2F2F",
"x.	c #793535",
"y.	c #FF2F2F",
"z.	c #FF2B2B",
"A.	c #FF2727",
"B.	c #FF2121",
"C.	c #FF0B0B",
"D.	c #270C0C",
"E.	c #0A0A0A",
"F.	c #DADADA",
"G.	c #272727",
"H.	c #282828",
"I.	c #262626",
"J.	c #0F0F0F",
"K.	c #070707",
"L.	c #E3E3E3",
"M.	c #ECECEC",
"N.	c #171717",
". + @ # $ % & * = - ; > , ' ) ! ",
"+ ~ { ] ^ / ( _ : < [ } | 1 2 3 ",
"@ { 4 - 5 6 7 8 9 0 a b c d 3 e ",
"# ] - f g h i j k l m n o p q r ",
"$ ^ s t u v w x y z A B C D E F ",
"% / G H I J K L M N O P Q R S T ",
"& ( U V 3 W X Y Z `  ...+.@.#.Z ",
"* _ 2 $.%.&.*.=.-.;.>.,.'.).!.~.",
"= : {.{.].^.l /.(.n _.:.<.[.}.|.",
"- < Z Z 1.2.3.< 4.5.6.7.8.9.= : ",
"; [ 0.0.a.;.b.: ..c.d.e.f.g.h.i.",
"> } j.k.l.m.n.o.p.q.r.s.t.u.v.w.",
", | x.o C y.z.A.B.8.f.C.D.E.F.G.",
"' 1 H.G.G.I./ ).[.] J.u.E.K.L.).",
") 2 3 q E S #.!.}.= h.v.F.L.M.N.",
"! 3 e r F T Z ~.|.: i.w.G.).N.J."};

void * g_handle = 0;


KviEditorWindow::KviEditorWindow(KviFrame *lpFrm)
:KviWindow("!Editor: Untitled",KVI_WND_TYPE_PLUGIN,lpFrm)
{
	m_pMenuBar = new QMenuBar(this);
	m_pEditor = new SSEXEditor(this);

	connect(m_pEditor,SIGNAL(fileNameChanged(SSEXEditor *,const QCString &)),this,SLOT(fileNameChanged(SSEXEditor *,const QCString &)));

	QPopupMenu * file = new QPopupMenu(m_pMenuBar);
	file->insertItem("&New",this,SLOT(newFile()),QAccel::stringToKey(__tr("Ctrl+N")));
	file->insertItem("&Open",this,SLOT(openFile()),QAccel::stringToKey(__tr("Ctrl+O")));
	file->insertSeparator();
	file->insertItem("&Save",m_pEditor,SLOT(saveFile()),QAccel::stringToKey(__tr("Ctrl+S")));
	file->insertItem("Save &As...",m_pEditor,SLOT(saveFileAs()),QAccel::stringToKey(__tr("Ctrl+A")));
	file->insertSeparator();
	file->insertItem("&Close",this,SLOT(close()),QAccel::stringToKey(__tr("Ctrl+W")));

	QPopupMenu * edit = new QPopupMenu(m_pMenuBar);
	edit->insertItem("Toggle &Find Widget",m_pEditor,SLOT(toggleFindWidget()),QAccel::stringToKey(__tr("Ctrl+F")));
	edit->insertItem("&Switch Mode",m_pEditor,SLOT(switchMode()));

	m_pMenuBar->insertItem("&File",file);
	m_pMenuBar->insertItem("&Edit",edit);
	m_pMenuBar->setBackgroundMode(QMenuBar::PaletteBackground);

	setFocusHandlerNoChildren(m_pEditor);

	m_pEditor->setFocus();
}

//void KviEditorWindow::setBackgroundMode(QWidget::BackgroundMode bk)
//{
//	if(backgroundPixmap() && !backgroundPixmap()->isNull())QWidget::setBackgroundMode(bk);
//}

KviEditorWindow::~KviEditorWindow()
{
}

QPixmap * KviEditorWindow::myIconPtr()
{
	return g_pIcon;
}

void KviEditorWindow::fileNameChanged(SSEXEditor *,const QCString &fileName)
{
	KviStr tmp(KviStr::Format,"!Editor : %s",fileName.data());
	setWindowCaption(tmp.ptr());
}

void KviEditorWindow::resizeEvent(QResizeEvent *)
{
	int hght = m_pMenuBar->heightForWidth(width());
	m_pMenuBar->setGeometry(0,0,width(),hght);
	m_pEditor->setGeometry(0,hght,width(),height() - hght);
}

void KviEditorWindow::closeEvent(QCloseEvent *e)
{
	e->ignore();
	if(m_pEditor->isModified())
	{
		if(!m_pEditor->closeFile())return;
	}
	KviWindow::closeEvent(e);
}

void KviEditorWindow::openFile(const char *name)
{
	m_pEditor->loadFile(name);
}

void KviEditorWindow::newFile()
{
	KviEditorWindow * wnd = new KviEditorWindow(m_pFrm);
	kvirc_plugin_add_window(g_handle,m_pFrm,wnd);
}

void KviEditorWindow::openFile()
{
	KviStr tmp = QFileDialog::getOpenFileName();
	if(tmp.hasData())
	{
		if(kvi_strEqualCS(m_pEditor->fileName().data(),"Untitled") && (!m_pEditor->isModified()))
		{
			// open in this window
			openFile(tmp.ptr());
		} else {
			// open in another window
			KviEditorWindow * wnd = new KviEditorWindow(m_pFrm);
			kvirc_plugin_add_window(g_handle,m_pFrm,wnd);
			wnd->openFile(tmp.ptr());
		}
	}
}

bool editor_plugin_command_edit(KviPluginCommandStruct *cmd)
{
	KviEditorWindow * wnd = new KviEditorWindow(cmd->frame);
	kvirc_plugin_add_window(cmd->handle,cmd->frame,wnd);
	KviStr tmp = kvirc_plugin_param(cmd,1);
	if(tmp.hasData())wnd->openFile(tmp.ptr());
	return true;
}

bool editor_plugin_init(KviPluginCommandStruct *cmd)
{
	g_pIcon = new QPixmap(editor_icon_xpm);
	kvirc_plugin_register_command(cmd->handle,"EDIT",editor_plugin_command_edit);
	g_handle = cmd->handle; //need it outside commands
	return true; // success
}

void editor_plugin_cleanup()
{
	delete g_pIcon;
	kvirc_plugin_unregister_meta_object("KviEditorWindow");
	kvirc_plugin_unregister_meta_object("SSEXFindWidget");
	kvirc_plugin_unregister_meta_object("SSEXEditor");
}

/*
	@document: doc_plugin_editor.kvihelp
	@title: The text editor plugin
		Adds a simple text editor to KVIrc.<br>
		You can open files by using the command<br>
		<b>/edit [filename]</b><br>
		Filename must be an absolute file path.<br>
		If no filename is specified , a "new file" will be created.<br>
		The editor has three working modes:<br>
		Normal , Cpp (for c source code , with syntax highlighting) and Html
		(with light syntax highlighting).<br>
		The plugin window has a lot of keyboard shortcuts:<br>
		Here goes the list:<br>
		CTRL+C : copy the selected text to clipboard.<br>
		CTRL+V : paste the clipboard contents to the current position in the file.<br>
		CTRL+X : copy & then remove the selection.<br>
		CTRL+M : switch mode.<br>
		CTRL+I : indent one level (only in Cpp mode).<br>
		CTRL+U : unindent one level (only in Cpp mode).<br>
		CTRL+O : comment out (only in Cpp mode).<br>
		CTRL+O+Shift : comment out (alternate) (only in Cpp mode).<br>
		CTRL+P : remove comment (only in Cpp mode).<br>
		CTRL+R : record/stop recording keystrokes.<br>
		CTRL+T : replay keystrokes.<br>
		CTRL+S : save file.<br>
		CTRL+A : save file as.<br>
		CTRL+F : show/hide the find widget.<br>
		CTRL+N : find next.<br>
		CTRL+H : find prev.<br>
		CTRL+B : find next treating the string to find as a regular expression.<br>
		CTRL+G : find prev (regular expression).<br>
		CTRL+J : replace the current selection.<br>
		CTRL+K : replace all the occurences in the file.<br>
		CTRL+L : replace all the occurences in the file (regular expression).<br>
		CTRL+Q : replace and find next.<br>
		CTRL+W : replace and find next (regular expression).<br>
		CTRL+E : replace all in selection.<br>
		CTRL+D : replace all in selection (regular expression).<br>
		<br>
		You can use the editor as the default "player"
		for text files (see <a href="play.kvihelp">PLAY</a>).<br>
		In order to do so , put "EDIT <a href="s_execfilename.kvihelp">$execFileName</a>" in the
		"Run script" field (misc options dialog , mimetypes tab)
		for the mimetypes that you want to play with the editor.<br>
		Note:<br>
		If you unload the plugin , the /EDITOR command will no longer work.<br>
		Here comes a simple workaround "commandline field" script for this problem:<br>
		Version 1: Use the plugin if is loaded.<br>
		<b><a href="if.kvihelp">if</a>(<a href="s_pluginLoaded.kvihelp">$pluginLoaded</a>(editor))edit <a href="s_execfilename.kvihelp">$ExecFileName</a>; else <a href="exec.kvihelp">exec</a> -q myviewer <a href="s_execfilename.kvihelp">$ExecFileName</a></b><br>
		Workaround 2: Use the plugin always, if it is not loaded , load it.<br>
		<b><a href="if.kvihelp">if</a>(!<a href="s_pluginloaded.kvihelp">$pluginLoaded</a>(editor))<a href="plugin.kvihelp">PLUGIN</a> load libkvieditor.so; edit <a href="s_execfilename.kvihelp">$ExecFilename</a></b><br>
		Note:<br>
		I'm currently using this widget (inserted into a separate application) in Cpp mode to develop 
		KVIrc. :)
*/

void editor_plugin_help()
{
	kvirc_plugin_show_help_page("doc_plugin_editor.kvihelp");
}

KviPlugin kvirc_plugin =
{
	"editor" ,
	"A simple text editor" ,
	"0.1" ,
	"Szymon Stefanek <stefanek@tin.it>" ,
	"Exports the /EDIT command" ,
	editor_plugin_init ,
	editor_plugin_cleanup ,
	0 ,
	editor_plugin_help
};

#include "m_libkvieditor.moc"

