#ifndef _LIBKVICHARPICKER_H_INCLUDED_
#define _LIBKVICHARPICKER_H_INCLUDED_
//
//   Charpicker plugin for the KVIrc IRC client
//   Copyright (C) 1999-2000 Szymon Stefanek (kvirc@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include "kvi_window.h"
#include <qscrollview.h>
#include <qpushbutton.h>
#include <qlabel.h>

class KviCharPickerButton;

class KviCharPicker : public QScrollView
{
	Q_OBJECT
public:
	KviCharPicker(QSplitter * parent,KviWindow * wnd);
	~KviCharPicker();
public:
	KviWindow * m_pWnd;
	KviCharPickerButton * m_pBtn[256];
	QPushButton * m_pUpdateButton;
	QPushButton * m_pCloseButton;
protected slots:
	void closeClicked();
	void updateFont();
	void charPicked(const QString &str);
};


class KviCharPickerButton : public QPushButton
{
	Q_OBJECT
public:
	KviCharPickerButton(QWidget * parent,char display);
	~KviCharPickerButton();
protected slots:
	void hasBeenClicked();
signals:
	void charPicked(const QString &str);
};

#endif
