/**vim: ts=4, wrap, tw=80
  *
  *		--- libkvibiffsocket.h---
  *
  * Authors:
  * 	Szymon Stefanek <stefanek@tin.it>
  * 	Krzysztof Godlewski <kristoff@poczta.wprost.pl>
  * 
  * This program is FREE software. You can redistribute it and/or
  * modify it under the terms of the GNU General Public License
  * as published by the Free Software Foundation; either version 2
  * of the License, or (at your opinion) any later version.
  *
  * This program is distributed in the HOPE that it will be USEFUL,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  * See the GNU General Public License for more details.

  * You should have received a copy of the GNU General Public License
  * along with this program. If not, write to the Free Software Foundation,
  * Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
  **/
 

#ifndef _LIBKVIBIFFSOCKET_H_
#define _LIBKVIBIFFSOCKET_H_

#include <qsocketnotifier.h>

#include "kvi_string.h"
#include "kvi_dns.h"

class KviBiffWidget;
class KviBiffMailbox;

class KviBiffSocket : public QObject
{
	Q_OBJECT

public:
	KviBiffSocket();
	~KviBiffSocket();
	
protected:
	int                m_fd;
	QSocketNotifier  * m_pNotifier;
	KviStr             m_szHostIp;
	KviAsyncDns      * m_pDns;
	KviBiffMailbox   * m_pMailbox;
	// Original data
	unsigned short int m_uPort;
	KviStr             m_szUsername;
	KviStr             m_szPassword;
	KviStr             m_szHostname;
	KviStr             m_lastCommand;
	
public:
	const char * hostname()		const		{ return m_szHostname.ptr(); };
	const char * hostIp()		const 		{ return m_szHostIp.ptr(); };
	unsigned short int port()	const 		{ return m_uPort; };
	bool run(KviBiffMailbox * box);
	
protected slots:
	void dnsDone(KviDnsStruct *dns);
	void writeNotifierFired(int fd);
	void readNotifierFired(int fd);
	
signals:
	void resolving();
	void connected();		// emitted to signal the connection estabilished
	void loggedIn();
// The following two signals are critical:
// Can't rely on the this pointer after these have been emitted
	void error(const char * err);		// emitted in case of critical errors
	void jobDone();			// emitted when the update job has been terminated
};

#endif
