/**vim: ts=4, wrap, tw=80
  *
  *		--- libkvibiffconfig.cpp ---
  *
  * (c) Krzysztof Godlewski <kristoff@poczta.wprost.pl>
  * 
  * This program is FREE software. You can redistribute it and/or
  * modify it under the terms of the GNU General Public License
  * as published by the Free Software Foundation; either version 2
  * of the License, or (at your opinion) any later version.
  *
  * This program is distributed in the HOPE that it will be USEFUL,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  * See the GNU General Public License for more details.

  * You should have received a copy of the GNU General Public License
  * along with this program. If not, write to the Free Software Foundation,
  * Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
  **/


#include <qlabel.h> 
#include <qtabbar.h>
#include <qmessagebox.h>

#include "libkvibiff.h"
#include "libkvibiffconfig.h"
#include "kvi_locale.h"

extern KviBiff * g_pBiff;


KviBiffConfigDlg::KviBiffConfigDlg() : QTabDialog(0,"BiffConfigDialog", false )
{
	setCaption( __tr("Biff plugin configuration"));

//
// "General" tab
	QVBox *vb = new QVBox(this);
	vb->setMargin(5);

	QLabel *lab = new QLabel(vb);
	lab->setAlignment(AlignCenter);
	lab->setText(_CHAR_2_QSTRING("Nothing here yet ! :)"));
//
// FIXME: Some options here, like: Auto check all, auto check interval etc...
//
	addTab(vb, __tr("General"));

// 
// "Mailboxes" tab
	vb = new QVBox(this);
	vb->setMargin(5);
	m_mboxView = new KviListView(vb);

	const char *columns[] = {
	__tr("Login"), __tr("Server"), __tr("Port"),__tr("Password"),
	__tr("Check") };

#define Col_Login			0
#define Col_Server			1
#define Col_Port			2
#define Col_Password		3
#define Col_Check			4

	for( uint i = 0; i < sizeof(columns) / sizeof(columns[0]); i++ )
		m_mboxView->addColumn(_CHAR_2_QSTRING(columns[i]));

	m_mboxView->setShowSortIndicator(true);

	QHBox *hb = new QHBox(vb);
	hb->setMargin(5);

	QPushButton *b = new QPushButton( _CHAR_2_QSTRING(__tr("Add")), hb );
	b->setFocus();
	connect(b, SIGNAL(clicked()), SLOT(slotAddMailbox()));

	b = new QPushButton( _CHAR_2_QSTRING(__tr("Remove")), hb );
	connect(b, SIGNAL(clicked()), SLOT(slotRemoveMailbox()));

	b = new QPushButton( _CHAR_2_QSTRING(__tr("Remove all")), hb );
	connect(b, SIGNAL(clicked()), SLOT(slotRemoveAll()));

	addTab(vb, _CHAR_2_QSTRING(__tr("Mailboxes")));
}

KviBiffConfigDlg::~KviBiffConfigDlg()
{
}

void KviBiffConfigDlg::setOptions()
{
// TODO: do sth with it :)
//	const KviBiffConfig & bc = g_pBiff->configStruct();
//
	
	m_mboxView->clear();
	QList<KviBiffMailbox> * const mbl = g_pBiff->mailboxList();

	for(KviBiffMailbox *mb = mbl->first(); mb; mb = mbl->next())
	{
		QListViewItem *vi = new QListViewItem(m_mboxView);
		vi->setText(Col_Login, mb->username());
		vi->setText(Col_Server, mb->hostname());
		QString s;
		s.setNum(mb->port());
		vi->setText(Col_Port, s );
		vi->setText(Col_Password, mb->password());
		vi->setText(Col_Check, mb->autoCheck() ? "true" : "false");
	}
}

void KviBiffConfigDlg::getOptions()
{
//
// TODO: Set correct options to g_pBiff->configStruct() here
//
	if( g_pBiff->mailboxList()->count())
		g_pBiff->mailboxList()->clear();

	for(QListViewItem *i=m_mboxView->firstChild();i;
		i=i->itemBelow()) 
	{
		KviBiffMailbox *mb = new KviBiffMailbox(
			i->text(Col_Server).latin1(),
			i->text(Col_Login).latin1(),
			i->text(Col_Password).latin1(),
			i->text(Col_Port).toUInt(),
			kvi_strEqualCI(i->text(Col_Check).latin1(), "true"));

		if(mb)
			g_pBiff->mailboxList()->append(mb);
	}
}

void KviBiffConfigDlg::slotAddMailbox()
{
	QListViewItem *i = new QListViewItem(m_mboxView);
	i->setText( Col_Login, "-x-" );
	i->setText( Col_Server, "-x-" );
	i->setText( Col_Port, "110" );
	i->setText( Col_Password, "-x-" );
	i->setText( Col_Check, "true" );

	m_mboxView->insertItem(i);
	m_mboxView->triggerUpdate();
}

void KviBiffConfigDlg::slotRemoveMailbox()
{
	if( ! m_mboxView->selectedItem())
		return;

	const KviBiffMailbox *mb = 
	g_pBiff->findMailbox(m_mboxView->selectedItem()->text(Col_Login).latin1(),
		m_mboxView->selectedItem()->text(Col_Server).latin1());

	if(mb)
	{
		if( QMessageBox::warning(0, _CHAR_2_QSTRING(__tr("Remove Mailbox")),
			_CHAR_2_QSTRING(__tr("Are you sure you want to remove this mailbox from the list ?"))
			,_CHAR_2_QSTRING(__tr("Yes")), _CHAR_2_QSTRING(__tr("No"))) == 0 )
		{
			g_pBiff->mailboxList()->removeRef(mb);
			m_mboxView->removeItem(m_mboxView->selectedItem());
		}
	}
	else
		m_mboxView->removeItem(m_mboxView->selectedItem());
}

void KviBiffConfigDlg::slotRemoveAll()
{
	if( QMessageBox::warning(0, _CHAR_2_QSTRING(__tr("Remove Mailbox")),
		_CHAR_2_QSTRING(__tr("Are you sure you want to remove all mailboxes from the list ?"))
		 ,_CHAR_2_QSTRING(__tr("Yes")), _CHAR_2_QSTRING(__tr("No"))) == 0 )
	{
		g_pBiff->mailboxList()->clear();
		m_mboxView->clear();
	}
}

void KviBiffConfigDlg::activateMailboxesTab() const
{
	tabBar()->setCurrentTab(1);
}

#include "libkvibiffconfig.moc"
