//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include "kvi_wmdock.h"
#include "kvi_app.h"
#include "kvi_frame.h"
#include "kvi_options.h"

#include "kvi_locale.h"

#include "kvi_imagelib.h"

#include <qcursor.h>
#include <qpainter.h>
#include <qinputdialog.h>
#include <qmessagebox.h>

#include <unistd.h>

#ifdef COMPILE_NEED_KDE
extern QPixmap * g_pixViewOut[KVI_OUT_NUM_IMAGES];

KviWMDockWidget::KviWMDockWidget()
: KSystemTray(0,"kvirc_wm_dock_widget")
{
	m_bFramesVisible = true;
	m_bHighlight = false;
	m_bAltColor = false;
	m_bLocked = false;

	m_pSessionsPopup = new KPopupMenu(this,"sessions_popup");
	connect(m_pSessionsPopup,SIGNAL(aboutToShow()),this,SLOT(fillSessionsPopup()));

	KPopupMenu * m_pConfigurePopup = new KPopupMenu(this,"configure_popup");
	m_pConfigurePopup->setCaption(__tr("Configure"));
	m_pConfigurePopup->insertItem(__tr("&User Configuration..."),g_pApp,SLOT(slot_doUserOptionsDialog()));
	m_pConfigurePopup->insertItem(__tr("Servers && Proxy &Hosts..."),g_pApp,SLOT(slot_doServerOptionsDialog()));
	m_pConfigurePopup->insertItem(__tr("&General Options..."),g_pApp,SLOT(slot_generalOptionsDialog()));
	m_pConfigurePopup->insertItem(__tr("&Registered Users..."),g_pApp,SLOT(slot_doRegUsersDialog()));

	m_pContextPopup = new KPopupMenu(this,"dock_popup");
	m_pContextPopup->setCaption(__tr("Context"));
	connect(m_pContextPopup,SIGNAL(aboutToShow()),this,SLOT(fillContextPopup()));
	m_pContextPopup->insertTitle(*g_pixViewOut[KVI_OUT_KVIRC],"KVIrc");
	m_iFramesMinimize = m_pContextPopup->insertItem(__tr("&Minimize All"),this,SLOT(slot_hideAllFrames()));
	m_iFramesRestore = m_pContextPopup->insertItem(__tr("&Restore All"),this,SLOT(slot_showAllFrames()));
	m_pContextPopup->insertItem(__tr("&Lock..."),this,SLOT(slot_toggleLock()));
	m_pContextPopup->insertItem(__tr("&Undock"),g_pApp,SLOT(slot_destroyWMDockWidget()));
	m_pContextPopup->insertSeparator();
	m_pContextPopup->insertItem(__tr("&New Session"),g_pApp,SLOT(createNewFrame()));
	m_pContextPopup->insertItem(__tr("&Sessions"),m_pSessionsPopup);
	m_pContextPopup->insertItem(__tr("&Configure"),m_pConfigurePopup);
	m_pContextPopup->insertSeparator();
	m_pContextPopup->insertItem(__tr("&Quit"),g_pApp,SLOT(slot_safeQuit()));

	KviStr szP1;
	KviStr szP2;
	g_pApp->getLocalKVircDirectory(szP1,KviApp::Pics,"kvi_dock.png");
	g_pApp->getGlobalKVircDirectory(szP2,KviApp::Pics,"kvi_dock.png");
	KviImageLibrary lib5(szP1.ptr(),szP2.ptr(),22,22); //16,16
	m_pNormalIcon=new QPixmap(lib5.getImage(0));
	m_pHighlightIcon=new QPixmap(lib5.getImage(1));
	m_pAltColorIcon=new QPixmap(lib5.getImage(2));

	setPixmap();
	show();
}

KviWMDockWidget::~KviWMDockWidget()
{
	delete m_pNormalIcon;
	delete m_pHighlightIcon;
	delete m_pAltColorIcon;
	if(g_pApp->m_pWMDockWidget != 0)g_pApp->wmDockWidgetDestroyed();
}

void KviWMDockWidget::fillSessionsPopup()
{
	m_pSessionsPopup->clear();
	m_pSessionsPopup->setCaption(__tr("Sessions"));
	int i = 0;
	for(KviFrame *pFrm=g_pApp->m_pFrameList->first();pFrm;pFrm=g_pApp->m_pFrameList->next())
	{
		KviStr szItem;
		if(pFrm->isMinimized()){
			szItem="(";
			szItem+=pFrm->caption();
			szItem+=")";
		} else szItem=pFrm->caption();
		int id = m_pSessionsPopup->insertItem(szItem.ptr(),g_pApp,SLOT(toggleFrame(int)));
		m_pSessionsPopup->setItemParameter(id,i);
		m_pSessionsPopup->setItemChecked(id,!pFrm->isHidden());
		i++;
	}
}

void KviWMDockWidget::fillContextPopup()
{
	int i = 0;
	for(KviFrame *pFrm=g_pApp->m_pFrameList->first();pFrm;pFrm=g_pApp->m_pFrameList->next())
		if(pFrm->isHidden())i++;
	if(i == g_pApp->m_pFrameList->count())m_bFramesVisible=false;
	else m_bFramesVisible=true;

	m_pContextPopup->setItemEnabled(m_iFramesMinimize,m_bFramesVisible);
	m_pContextPopup->setItemEnabled(m_iFramesRestore,i);

}

void KviWMDockWidget::slot_showAllFrames()
{
	g_pApp->showAllFrames();
}

void KviWMDockWidget::slot_hideAllFrames()
{
	g_pApp->hideAllFrames();
}

void KviWMDockWidget::slot_toggleAllFrames()
{
	if(m_bFramesVisible)
		g_pApp->hideAllFrames();
	else g_pApp->showAllFrames();
}

void KviWMDockWidget::slot_toggleLock()
{
	QString pw;
	bool bOk = false;
	if(m_bLocked)
		pw = QInputDialog::getText(__tr("KVIrc is Locked"),__tr("Enter lock password to unlock KVIrc:"),
			QLineEdit::Password,QString::null,&bOk,this);
	else pw = QInputDialog::getText(__tr("Lock KVIrc"),__tr("Set lock password to lock KVIrc:"),
			QLineEdit::Password,QString::null,&bOk,this);
	if(bOk && !pw.isEmpty()){
		register unsigned long a=0,b=0,c=0,d=0,sum=0,delta=0x9E3779B9;
		int n=32;
		pw.truncate(16);
		for(int i = 0;!pw.at(i).isNull();i++)
		{
			QCharRef ch = pw.at(i);
			if(i < 4)a+=ch.unicode();
			else if(i < 8)b+=ch.unicode();
			else if(i < 12)c+=ch.unicode();
			else if(i < 16)d+=ch.unicode();
			ch='\0';
		}
		while(n-->0){
			sum += delta;
			a += (b << 4)+c ^ b+sum ^ (b >> 5)+d;
			b += (a << 4)+a ^ a+sum ^ (a >> 5)+b;
			c += (d << 4)+c ^ d+sum ^ (d >> 5)+d;
			d += (c << 4)+a ^ c+sum ^ (c >> 5)+b;
		}
		if(m_bLocked){
			if(a%b%c%d == m_lPw)m_bLocked = false;
			else QMessageBox::warning(this,__tr("KVIrc Lock"),
				__tr("Password incorrect"),
					QMessageBox::Ok | QMessageBox::Default,0);
		} else {
			g_pApp->hideAllFrames();
			m_bLocked = true;
			m_lPw = a%b%c%d;
		}
	}
}

void KviWMDockWidget::setFramesVisible(bool bVisible)
{
	m_bFramesVisible = bVisible;
	if(bVisible){
		m_bHighlight = false;
		m_bAltColor = false;
		setPixmap();
	}
}

void KviWMDockWidget::mousePressEvent(QMouseEvent *e)
{
	if(!m_bLocked){
		if(e->button() & RightButton)m_pContextPopup->popup(QCursor::pos());
		else slot_toggleAllFrames();
	} else slot_toggleLock();
}

void KviWMDockWidget::highlight(bool bAltColor)
{
	if((m_bAltColor != bAltColor) || (!m_bHighlight)){
		m_bHighlight = true;
		m_bAltColor = bAltColor;
		setPixmap();
	}
}

void KviWMDockWidget::setPixmap()
{
	if(m_bHighlight)
	{
		if(m_bAltColor)
			QLabel::setPixmap(*m_pAltColorIcon);
		else
			QLabel::setPixmap(*m_pHighlightIcon);
	}
	else
		QLabel::setPixmap(*m_pNormalIcon);
}

#include "m_kvi_wmdock.moc"


#endif

