//
//   File : kvi_statusbar.cpp (/usr/build/NEW_kvirc/kvirc/src/kvirc/kvi_statusbar.cpp)
//   Last major modification : Tue Jul 6 1999 14:49:18 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#define _KVI_DEBUG_CHECK_RANGE_
#define _KVI_DEBUG_CLASS_NAME_ "KviStatusBar"

#include "kvi_debug.h"
#include "kvi_statusbar.h"
#include "kvi_frame.h"
#include "kvi_style.h"

#include <qlist.h>
#include <qlayout.h>
#include <qpainter.h>
#include <qtimer.h>
#include <qdrawutil.h>
#include <qapplication.h>
#include <qsizegrip.h>


KviDockableWidget::KviDockableWidget(void * plugin_handle,KviStatusBar * parent)
: QWidget(parent)
{
	m_plugin_handle = plugin_handle;
}

KviDockableWidget::~KviDockableWidget()
{
	// debug("Dockable widget dying");
}


//============ KviStatusBar ============//

KviStatusBar::KviStatusBar(KviFrame *parent)
:QStatusBar(parent,"status_bar")
{

}


//============ ~KviStatusBar ============//

KviStatusBar::~KviStatusBar()
{

}

void KviStatusBar::tempText(const char *msg,int msecs)
{
	if(msecs > 0) message(_CHAR_2_QSTRING(msg),msecs);
	else message(_CHAR_2_QSTRING(msg));
}
/*
void KviStatusBar::dockWidget(KviDockableWidget *w)
{
	m_pDockedWidgetList->append(w);
	recalcHeight();
	layoutDockedWidgets();
}


void KviStatusBar::undockWidget(KviDockableWidget *w)
{
	m_pDockedWidgetList->removeRef(w);
	recalcHeight();
	layoutDockedWidgets();
}

void KviStatusBar::recalcHeight()
{
	int min = 16;
	int x;
	for(KviDockableWidget *w=m_pDockedWidgetList->first();w;w=m_pDockedWidgetList->next()){
		x = w->minimumHeight() + 2;
		if(min < x)min = x;
	}
	// trick
	setMinimumHeight(min);
	setMaximumHeight(min);
	((QWidget *)parent())->resize(((QWidget *)parent())->width(),((QWidget *)parent())->height());
}

void KviStatusBar::layoutDockedWidgets()
{
	int x = width() - 13; //13 is QSizeGrip::sizeHint()
	for(KviDockableWidget *w=m_pDockedWidgetList->first();w;w=m_pDockedWidgetList->next()){
		x -= (w->minimumWidth() + 3);
		if(x < 3)x = 3;
		w->setGeometry(x,2,w->minimumWidth(),height() - 4);
	}
}

void KviStatusBar::killDockedWidgetsByPluginHandle(void * plugin_handle)
{
	QList<KviDockableWidget> *l = new QList<KviDockableWidget>;
	l->setAutoDelete(true);
	for(KviDockableWidget *w=m_pDockedWidgetList->first();w;w=m_pDockedWidgetList->next()){
		if(w->m_plugin_handle == plugin_handle)l->append(w);
	}
	for(KviDockableWidget *wdg=l->first();wdg;wdg=l->next()){
		m_pDockedWidgetList->removeRef(wdg);
	}
	delete l;
	recalcHeight();
	layoutDockedWidgets();
}

void KviStatusBar::resizeEvent(QResizeEvent *e)
{
	QStatusBar::resizeEvent(e);
	layoutDockedWidgets();
}
*/
#include "m_kvi_statusbar.moc"
