#ifndef _KVI_SCRIPTWIDGET_H_INCLUDED_
#define _KVI_SCRIPTWIDGET_H_INCLUDED_

//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include "kvi_scriptobject.h"

#include <qlist.h>
#include <qwidget.h>
#include <qtoolbar.h>
#include <qlistview.h>

class KviScriptWidget : public KviScriptObject
{
	friend class KviScriptLayout;
	friend class KviScriptButton;
	friend class KviScriptLabel;
	friend class KviScriptMultiLineEdit;
	friend class KviScriptLineEdit;
	friend class KviScriptToolBar;
	friend class KviScriptCheckBox;
	friend class KviScriptToolButton;
	friend class KviScriptSplitter;
	friend class KviScriptPopupMenu;
	friend class KviScriptSpinBox;
	friend class KviScriptComboBox;
	friend class KviScriptTabWidget;
	friend class KviScriptTreeView;
	friend class KviScriptTreeViewItem;
	Q_OBJECT
	public:
		KviScriptWidget(KviScriptObjectController * cntrl,KviScriptObject * p,const char *name,KviScriptObjectClassDefinition * pDef);
		~KviScriptWidget();
	protected:
		QWidget   * m_pWidget;
		bool        m_bAutoDestroyControlledWidget;
	public:
		virtual bool init(QList<KviStr> * params);
		static void initializeClassDefinition(KviScriptObjectClassDefinition *d);
		int builtinFunction_SHOW(QList<KviStr> * params,KviStr &buffer);
		int builtinFunction_HIDE(QList<KviStr> * params,KviStr &buffer);
		int builtinFunction_X(QList<KviStr> * params,KviStr &buffer);
		int builtinFunction_Y(QList<KviStr> * params,KviStr &buffer);
		int builtinFunction_WIDTH(QList<KviStr> * params,KviStr &buffer);
		int builtinFunction_HEIGHT(QList<KviStr> * params,KviStr &buffer);
		int builtinFunction_SETMINIMUMWIDTH(QList<KviStr> * params,KviStr &buffer);
		int builtinFunction_SETMINIMUMHEIGHT(QList<KviStr> * params,KviStr &buffer);
		int builtinFunction_ISTOPLEVEL(QList<KviStr> * params,KviStr &buffer);
		int builtinFunction_ISVISIBLE(QList<KviStr> * params,KviStr &buffer);
		int builtinFunction_SETGEOMETRY(QList<KviStr> * params,KviStr &buffer);
		int builtinFunction_ISENABLED(QList<KviStr> * params,KviStr &buffer);
		int builtinFunction_SETENABLED(QList<KviStr> * params,KviStr &buffer);
		int builtinFunction_PARENTWIDGET(QList<KviStr> * params,KviStr &buffer);
		int builtinFunction_CAPTION(QList<KviStr> * params,KviStr &buffer);
		int builtinFunction_SETCAPTION(QList<KviStr> * params,KviStr &buffer);
		int builtinFunction_RAISE(QList<KviStr> * params,KviStr &buffer);
		int builtinFunction_LOWER(QList<KviStr> * params,KviStr &buffer);
		int builtinFunction_SETFOCUS(QList<KviStr> * params,KviStr &buffer);
		int builtinFunction_HASFOCUS(QList<KviStr> * params,KviStr &buffer);
		int builtinFunction_SETBACKGROUNDCOLOR(QList<KviStr> * params,KviStr &buffer);
		int builtinFunction_BACKGROUNDCOLOR(QList<KviStr> * params,KviStr &buffer);
		int builtinFunction_SETQTPROPERTY(QList<KviStr> * params,KviStr &buffer);
		int builtinFunction_QTPROPERTY(QList<KviStr> * params,KviStr &buffer);
		int builtinFunction_LISTQTPROPERTIES(QList<KviStr> * params,KviStr &buffer);
	protected:
		bool eventFilter(QObject *o,QEvent *e);
		void recursiveShow();
	protected slots:
		void widgetDestroyed();

};

class KviScriptButton : public KviScriptWidget
{
	Q_OBJECT
	public:
		KviScriptButton(KviScriptObjectController * cntrl,KviScriptObject * p,const char *name,KviScriptObjectClassDefinition * pDef);
		~KviScriptButton();
	public:
		virtual bool init(QList<KviStr> * params);
		static void initializeClassDefinition(KviScriptObjectClassDefinition *d);
		int builtinFunction_TEXT(QList<KviStr> * params,KviStr &buffer);
		int builtinFunction_SETTEXT(QList<KviStr> * params,KviStr &buffer);
	protected slots:
		void buttonClicked();
};

class KviScriptToolButton : public KviScriptWidget
{
	Q_OBJECT
	public:
		KviScriptToolButton(KviScriptObjectController * cntrl,KviScriptObject * p,const char *name,KviScriptObjectClassDefinition * pDef);
		~KviScriptToolButton();
	public:
		virtual bool init(QList<KviStr> * params);
		static void initializeClassDefinition(KviScriptObjectClassDefinition *d);
		int builtinFunction_TEXT(QList<KviStr> * params,KviStr &buffer);
		int builtinFunction_SETTEXT(QList<KviStr> * params,KviStr &buffer);
		int builtinFunction_SETIMAGE(QList<KviStr> * params,KviStr &buffer);

	protected slots:
		void buttonClicked();
};

class KviScriptLabel : public KviScriptWidget
{
	Q_OBJECT
	public:
		KviScriptLabel(KviScriptObjectController * cntrl,KviScriptObject * p,const char *name,KviScriptObjectClassDefinition * pDef);
		~KviScriptLabel();
	public:
		virtual bool init(QList<KviStr> * params);
		static void initializeClassDefinition(KviScriptObjectClassDefinition *d);
		int builtinFunction_TEXT(QList<KviStr> * params,KviStr &buffer);
		int builtinFunction_SETTEXT(QList<KviStr> * params,KviStr &buffer);
		int builtinFunction_SETFRAMESHAPE(QList<KviStr> * params,KviStr &buffer);
		int builtinFunction_SETFRAMESHADOW(QList<KviStr> * params,KviStr &buffer);
		int builtinFunction_SETIMAGE(QList<KviStr> * params,KviStr &buffer);
};

class KviScriptMultiLineEdit : public KviScriptWidget
{
	Q_OBJECT
	public:
		KviScriptMultiLineEdit(KviScriptObjectController * cntrl,KviScriptObject * p,const char *name,KviScriptObjectClassDefinition * pDef);
		~KviScriptMultiLineEdit();
	public:
		virtual bool init(QList<KviStr> * params);
		static void initializeClassDefinition(KviScriptObjectClassDefinition *d);
		int builtinFunction_TEXT(QList<KviStr> * params,KviStr &buffer);
		int builtinFunction_SETTEXT(QList<KviStr> * params,KviStr &buffer);
		int builtinFunction_SETREADONLY(QList<KviStr> * params,KviStr &buffer);
		int builtinFunction_READONLY(QList<KviStr> * params,KviStr &buffer);
		int builtinFunction_SETCURSORPOSITION(QList<KviStr> * params,KviStr &buffer);
		int builtinFunction_CURSORPOSITION(QList<KviStr> * params,KviStr &buffer);
};

class KviScriptLineEdit : public KviScriptWidget
{
	Q_OBJECT
	public:
		KviScriptLineEdit(KviScriptObjectController * cntrl,KviScriptObject * p,const char *name,KviScriptObjectClassDefinition * pDef);
		~KviScriptLineEdit();
	public:
		virtual bool init(QList<KviStr> * params);
		static void initializeClassDefinition(KviScriptObjectClassDefinition *d);
		int builtinFunction_TEXT(QList<KviStr> * params,KviStr &buffer);
		int builtinFunction_SETTEXT(QList<KviStr> * params,KviStr &buffer);
		int builtinFunction_SETREADONLY(QList<KviStr> * params,KviStr &buffer);
		int builtinFunction_READONLY(QList<KviStr> * params,KviStr &buffer);
		int builtinFunction_HOME(QList<KviStr> *, KviStr &);
		int builtinFunction_END(QList<KviStr> *, KviStr &);
		int builtinFunction_CLEAR(QList<KviStr> *, KviStr &);
};

class KviScriptToolBar : public KviScriptWidget
{
	Q_OBJECT
	public:
		KviScriptToolBar(KviScriptObjectController * cntrl,KviScriptObject * p,const char *name,KviScriptObjectClassDefinition * pDef);
		~KviScriptToolBar();
	public:
		virtual bool init(QList<KviStr> * params);
		static void initializeClassDefinition(KviScriptObjectClassDefinition *d);
		QMainWindow::ToolBarDock getDockId(const char * str);
		int builtinFunction_DOCK(QList<KviStr> * params,KviStr &buffer);
		int builtinFunction_SETDOCKENABLED(QList<KviStr> * params,KviStr &buffer);

};

class KviScriptCheckBox : public KviScriptWidget
{
	Q_OBJECT
	public:
		KviScriptCheckBox(KviScriptObjectController * cntrl,KviScriptObject * p,const char *name,KviScriptObjectClassDefinition * pDef);
		~KviScriptCheckBox();
	public:
		virtual bool init(QList<KviStr> * params);
		static void initializeClassDefinition(KviScriptObjectClassDefinition *d);
		int builtinFunction_TEXT(QList<KviStr> * params,KviStr &buffer);
		int builtinFunction_SETTEXT(QList<KviStr> * params,KviStr &buffer);
		int builtinFunction_ISCHECKED(QList<KviStr> * params,KviStr &buffer);
		int builtinFunction_SETCHECKED(QList<KviStr> * params,KviStr &buffer);
	protected slots:
		void boxToggled(bool bChecked);
};

class KviScriptQtWrapper : public KviScriptWidget
{
	Q_OBJECT
	public:
		KviScriptQtWrapper(KviScriptObjectController * cntrl,KviScriptObject * p,const char *name,KviScriptObjectClassDefinition * pDef);
		~KviScriptQtWrapper();
	public:
		virtual bool init(QList<KviStr> * params);
		static void initializeClassDefinition(KviScriptObjectClassDefinition *d);
	private:
		QWidget * findWidgetToWrap(const char * szClass,const char * szName,QWidget * childOf);
		QWidget * findTopLevelWidgetToWrap(const char * szClass,const char * szName);
};

class KviScriptSplitter : public KviScriptWidget
{
	Q_OBJECT
	public:
		KviScriptSplitter(KviScriptObjectController * cntrl,KviScriptObject * p,const char *name,KviScriptObjectClassDefinition * pDef);
		~KviScriptSplitter();
	public:
		virtual bool init(QList<KviStr> * params);
		static void initializeClassDefinition(KviScriptObjectClassDefinition *d);
		int builtinFunction_SETORIENTATION(QList<KviStr> * params,KviStr &buffer);
		int builtinFunction_ORIENTATION(QList<KviStr> * params,KviStr &buffer);
};

class KviScriptPopupMenu : public KviScriptWidget
{
	Q_OBJECT
	public:
		KviScriptPopupMenu(KviScriptObjectController * cntrl,KviScriptObject * p,const char *name,KviScriptObjectClassDefinition * pDef);
		~KviScriptPopupMenu();
	public:
		virtual bool init(QList<KviStr> * params);
		static void initializeClassDefinition(KviScriptObjectClassDefinition *d);
		int builtinFunction_INSERTITEM(QList<KviStr> * params,KviStr &buffer);
		int builtinFunction_REMOVEITEM(QList<KviStr> * params,KviStr &buffer);
		int builtinFunction_ISITEMENABLED(QList<KviStr> * params,KviStr &buffer);
		int builtinFunction_ISITEMCHECKED(QList<KviStr> * params,KviStr &buffer);
		int builtinFunction_SETITEMENABLED(QList<KviStr> * params,KviStr &buffer);
		int builtinFunction_SETITEMCHECKED(QList<KviStr> * params,KviStr &buffer);
		int builtinFunction_INSERTMENU(QList<KviStr> * params,KviStr &buffer);
		int builtinFunction_INSERTSEPARATOR(QList<KviStr> * params,KviStr &buffer);
		int builtinFunction_POPUP(QList<KviStr> * params,KviStr &buffer);
		int builtinFunction_TEXT(QList<KviStr> * params,KviStr &buffer);
		int builtinFunction_CLEAR(QList<KviStr> * params,KviStr &buffer);
	protected slots:
		void itemActivated(int id);
};

class KviScriptSpinBox : public KviScriptWidget
{
	Q_OBJECT
public:
	KviScriptSpinBox(KviScriptObjectController * cntrl, KviScriptObject *p,
		const char * name, KviScriptObjectClassDefinition * pDef);
	~KviScriptSpinBox();

	virtual bool init(QList<KviStr> * params);
	static void initializeClassDefinition(KviScriptObjectClassDefinition *);

	int builtinFunction_VALUE(QList<KviStr> * params, KviStr &buffer);
	int builtinFunction_SETMINVALUE(QList<KviStr> *, KviStr &);
	int builtinFunction_SETMAXVALUE(QList<KviStr> *, KviStr &);
	int builtinFunction_SETVALUE(QList<KviStr> * params, KviStr &buffer);
	int builtinFunction_SETWRAPPING(QList<KviStr> * params, KviStr &buffer);
	int builtinFunction_WRAPPING(QList<KviStr> * params, KviStr &buffer);
	int builtinFunction_SETSTEP(QList<KviStr> *, KviStr &);
	int builtinFunction_SETSUFFIX(QList<KviStr> *, KviStr &);
	int builtinFunction_SUFFIX(QList<KviStr> *, KviStr &);
	int builtinFunction_CLEANVALUE(QList<KviStr> *, KviStr &);
};

class KviScriptComboBox : public KviScriptWidget
{
	Q_OBJECT
public:
	KviScriptComboBox(KviScriptObjectController * cntrl, KviScriptObject *p,
		const char * name, KviScriptObjectClassDefinition * pDef);
	~KviScriptComboBox();

	virtual bool init(QList<KviStr> * params);
	static void initializeClassDefinition(KviScriptObjectClassDefinition *);

	int builtinFunction_INSERTITEM(QList<KviStr> *, KviStr &);
	int builtinFunction_CLEAR(QList<KviStr> *, KviStr &);
	int builtinFunction_CURRENTTEXT(QList<KviStr> *, KviStr &);
	int builtinFunction_TEXT(QList<KviStr> *, KviStr &);
	int builtinFunction_REMOVEITEM(QList<KviStr> *, KviStr &);

protected slots:
	void __slotActivated(const QString &);
};

class KviScriptTabWidget : public KviScriptWidget
{
	Q_OBJECT
public:
	KviScriptTabWidget(KviScriptObjectController * cntrl, KviScriptObject *p,
		const char * name, KviScriptObjectClassDefinition * pDef);
	~KviScriptTabWidget();

	virtual bool init(QList<KviStr> * params);
	static void initializeClassDefinition(KviScriptObjectClassDefinition *);

	int builtinFunction_ADDTAB(QList<KviStr> *, KviStr &);
	int builtinFunction_REMOVETAB(QList<KviStr> *, KviStr &);
	int builtinFunction_SHOWTAB(QList<KviStr> *, KviStr &);
};

class KviScriptTreeView : public KviScriptWidget
{
	Q_OBJECT
public:
	KviScriptTreeView(KviScriptObjectController * cntrl, KviScriptObject *p,
		const char * name, KviScriptObjectClassDefinition * pDef);
	~KviScriptTreeView();

	virtual bool init(QList<KviStr> * params);
	static void initializeClassDefinition(KviScriptObjectClassDefinition *);


	int builtinFunction_ADDCOLUMN(QList<KviStr> *, KviStr &);
	int builtinFunction_REMOVECOLUMN(QList<KviStr> *, KviStr &);
	int builtinFunction_SETCOLUMNTEXT(QList<KviStr> *, KviStr &);
	int builtinFunction_SETROOTISDECORATED(QList<KviStr> *, KviStr &);
	int builtinFunction_SETSHOWSORTINDICATOR(QList<KviStr> *, KviStr &);
	int builtinFunction_SETALLCOLUMNSSHOWFOCUS(QList<KviStr> *, KviStr &);
	int builtinFunction_FIRSTCHILD(QList<KviStr> *,KviStr &);
protected slots:
	void selectionChanged(QListViewItem *it);
	void itemClicked(QListViewItem *it);
	void itemDoubleClicked(QListViewItem *it);
};

class KviScriptTreeViewItem;

class KviScriptListViewItem : public QListViewItem
{
	friend class KviScriptTreeViewItem;
	friend class KviScriptTreeView;
protected:
	KviScriptTreeViewItem * m_pScriptObjectClass;
public:
	KviScriptListViewItem(KviScriptTreeViewItem * it,QListView * par,QString &l1,QString &l2,QString &l3,QString &l4)
		: QListViewItem(par,l1,l2,l3,l4) , m_pScriptObjectClass(it) {};
	KviScriptListViewItem(KviScriptTreeViewItem * it,KviScriptListViewItem * par,QString &l1,QString &l2,QString &l3,QString &l4)
		: QListViewItem(par,l1,l2,l3,l4) , m_pScriptObjectClass(it) {};
	~KviScriptListViewItem();
};

class KviScriptTreeViewItem : public KviScriptObject
{
	friend class KviScriptListViewItem;
	Q_OBJECT
public:
	KviScriptTreeViewItem(KviScriptObjectController * cntrl,KviScriptObject * p,
		const char *name,KviScriptObjectClassDefinition * pDef);
	~KviScriptTreeViewItem();

	virtual bool init(QList<KviStr> * params);
	static void initializeClassDefinition(KviScriptObjectClassDefinition *);

	int builtinFunction_SETTEXT(QList<KviStr> *p, KviStr &);
	int builtinFunction_SETPIXMAP(QList<KviStr> *p, KviStr &);
	int builtinFunction_TEXT(QList<KviStr> *p,KviStr &buffer);
	int builtinFunction_SETOPEN(QList<KviStr> *p,KviStr &);
	int builtinFunction_ISSELECTED(QList<KviStr> *,KviStr &buffer);
	int builtinFunction_FIRSTCHILD(QList<KviStr> *,KviStr &buffer);
	int builtinFunction_NEXTSIBLING(QList<KviStr> *,KviStr &buffer);

protected:
	KviScriptListViewItem * m_pItem;

};

#endif //_KVI_SCRIPTWIDGET_H_DEFINED_
