#ifndef _KVI_SCRIPTLAYOUT_H_INCLUDED_
#define _KVI_SCRIPTLAYOUT_H_INCLUDED_

//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include "kvi_scriptobject.h"

#include <qlist.h>
#include <qlayout.h>

class KviScriptLayout : public KviScriptObject
{
	Q_OBJECT
	public:
		KviScriptLayout(KviScriptObjectController * cntrl,KviScriptObject * p,const char *name,KviScriptObjectClassDefinition * pDef);
		~KviScriptLayout();
	protected:
		QGridLayout   * m_pLayout;
	public:
		virtual bool init(QList<KviStr> * params);
		static void initializeClassDefinition(KviScriptObjectClassDefinition *d);
		int builtinFunction_MARGIN(QList<KviStr> * params,KviStr &buffer);
		int builtinFunction_SETMARGIN(QList<KviStr> * params,KviStr &buffer);
		int builtinFunction_SPACING(QList<KviStr> * params,KviStr &buffer);
		int builtinFunction_SETSPACING(QList<KviStr> * params,KviStr &buffer);
		int builtinFunction_ADD(QList<KviStr> * params,KviStr &buffer);
		int builtinFunction_ADDMULTICELL(QList<KviStr> * params,KviStr &buffer);
		int builtinFunction_SETROWSTRETCH(QList<KviStr> * params,KviStr &buffer);
		int builtinFunction_SETCOLSTRETCH(QList<KviStr> * params,KviStr &buffer);
	protected slots:
		void layoutDestroyed();

};

#endif //_KVI_SCRIPTSOCKET_H_DEFINED_
