#ifndef _KVI_OPTIONS_H_INCLUDED_
#define _KVI_OPTIONS_H_INCLUDED_

//
//   File : kvi_options.h (/usr/build/NEW_kvirc/kvirc/kvirc/kvi_options.h)
//   Last major modification : Mon Dec 28 1998 18:05:25 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include <qcolor.h>
#include <qpixmap.h>
#include <qfont.h>
#include <qlist.h>

#include "kvi_defines.h"
#include "kvi_string.h"

// 00000001
#define KVI_OPT_STR 1
// 00000010
#define KVI_OPT_BOOL   2
// 00000011
#define KVI_OPT_CLR 3
// 00000100
#define KVI_OPT_FNT 4
// 00000101
#define KVI_OPT_PCLR 5
// 00000110
#define KVI_OPT_TXTF 6
// 00000111
#define KVI_OPT_TXTB 7
// 00001000
#define KVI_OPT_INT 8

// 00001111
#define KVI_OPT_TYPE_MASK 15
// 11110000
#define KVI_OPT_FLAG_MASK 240

// 00010000
#define KVI_OPT_CAPTION (1 << 4)
// 00100000
#define KVI_OPT_GUI (2 << 4)
// 00110000
#define KVI_OPT_MSG (3 << 4)
// 01000000
#define KVI_OPT_REDIR (4 << 4)
// 01010000
#define KVI_OPT_CTCP (5 << 4)
// 01100000
#define KVI_OPT_IRCENG (6 << 4)

typedef struct KviOptionEntryTag
{
	const char *optName;
	int         optType;
	void       *optValue;
} KviOptionEntry;

class KviIrcServerManager;
class KviIrcProxyManager;
class KviWindowPropertiesList;
class KviMimeManager;
class KviRegisteredUsersDb;
class KviStrSub;

class KviOptions
{
	friend class KviApp;
public:
	KviOptions();
	~KviOptions();
public:
	static KviOptionEntry optBoolTable[];
	static KviOptionEntry optColorsTable[];
	static KviOptionEntry optStringsTable[];
	static KviOptionEntry optFontsTable[];
	static KviOptionEntry optTextTable[];
	static KviOptionEntry optIntTable[];
	//========================================================================================================
	// INTERNAL STUFF
	//========================================================================================================
	// USER OPTIONS
	static KviStr            m_szUserName;
	static KviStr            m_szRealName;
	static KviStr            m_szNickName1;
	static KviStr            m_szNickName2;
	static bool              m_bModeWOnConnect;
	static bool              m_bModeIOnConnect;
	static bool              m_bModeSOnConnect;
	// MISC OPTIONS : Messages tab
	static KviStr            m_szPartMessage;
	static KviStr            m_szKickMessage;
	static KviStr            m_szQuitMessage;
	static KviStr            m_szCaptionMessage;
	static KviStr            m_szCtcpVersionAppendix;
	static KviStr            m_szCtcpUserinfoAppendix;
	static KviStr            m_szCtcpClientinfoAppendix;
	static KviStr            m_szCtcpSourceAppendix;
	static KviStr            m_szCtcpFingerReply;
	//========================================================================================================
	// GUI STUFF
	//========================================================================================================
	// MDI MANAGER
	static QColor            m_clrMdiCaptionActiveBack;                   // Mdi caption colors
	static QColor            m_clrMdiCaptionActiveFore;                   //
	static QColor            m_clrMdiCaptionInactiveBack;                 //
	static QColor            m_clrMdiCaptionInactiveFore;                 //
	static QColor            m_clrMdiBack;                                // Mdi background color
	static QFont             m_fntMdiCaption;                             // Mdi caption font
	static KviStr            m_szMdiBack;                                 // Mdi background image path
	static bool              m_bMdiOpaqueMove;
	static bool              m_bMdiOpaqueResize;
	// Internal
	QPixmap                * m_pixMdiBack;                                // And the related pixmap
	//========================================================================================================
	// LIST BOX
	static QColor            m_clrListBoxOwner;
	static QColor            m_clrListBoxOp;                              // All in direct access by KviListBox
	static QColor            m_clrListBoxHalfOp;
	static QColor            m_clrListBoxVoice;
	static QColor            m_clrListBoxUserOp;
	static QColor            m_clrListBoxNormal;
	static QColor            m_clrListBoxSeleBack;
	static QColor            m_clrListBoxSeleFore;
	static QColor            m_clrListBoxBack;
	static QFont             m_fntListBox;
	static KviStr            m_szListBoxBack;
	static bool              m_bListBoxShowImages;
	// Internal
	QPixmap                * m_pixListBoxBack;
	int                      m_iListBoxCellHeight;
	int                      m_iListBoxBaseLineOffset;
	//========================================================================================================
	// INPUT WIDGET
	static QColor            m_clrInputBack;                  //Background color          (direct access - not used if !m_pixInputBack.isNull())
	static QColor            m_clrInputFore;                  //Foreground color          (direct access)
	static QColor            m_clrInputSeleBack;              //Selection background      (direct access)
	static QColor            m_clrInputSeleFore;              //Selection foreground      (direct access)
	static QColor            m_clrInputCursor;                //Cursor and control marks  (direct access)
	static QFont             m_fntInput;                      //Input font                (direct access - when set the below variables must be recalculated)
	static KviStr            m_szInputBack;                   //Background pixmap path
	// Internal
	QPixmap                * m_pixInputBack;                  //Default background pixmap (direct access - always non-NULL ptr)
	int                      m_iInputFontLineSpacing;         //                          (direct access , no save , font dependant)
	int                      m_iInputFontCharacterWidth[256]; // Yes...I am completly mad (direct access , no save , font dependant)
	int                      m_iInputFontBaseLineOffset;      //                          (direct access , no save , font dependant)
	int                      m_iInputFontLineWidth;           //                          (direct access , no save , font dependant)
	int                      m_iInputFontHeight;              //                          (direct access , no save , font dependant)
	//========================================================================================================
	// LABELS
	static KviStr            m_szLabelsBack;
	static QColor            m_clrLabelsBack;
	static QColor            m_clrLabelsActiveFore;
	static QColor            m_clrLabelsInactiveFore;
	static QFont             m_fntLabels;
	// Internal
	QPixmap                * m_pixLabelsBack;
	//========================================================================================================
	// HELP BROWSER
	static QColor            m_clrHelpBack;
	static QColor            m_clrHelpFore;
	static QColor            m_clrHelpTitle;
	static QColor            m_clrHelpSubtitle;
	static QColor            m_clrHelpExample;
	static QFont             m_fntHelpNormal;
	static QFont             m_fntHelpFixed;
	//========================================================================================================
	// SYSTRAY
	static QFont             m_fntSysTray;
	static QColor            m_clrSysTrayBack;
	static QColor            m_clrSysTrayFore;
	//========================================================================================================
	// KVIIRCVIEW
	// Output options (Handled by GUI dialog - output tab)
	static KviStr            m_szViewBack;                           // Background pixmap path
	static QColor            m_clrViewBack;                          // Background color           (direct access)
	static QFont             m_fntView;                              // Font for the view   (autoset in the constructor, later must be updated)
	// Other view options (Handlded by GUI dialog - output tab)
	static bool              m_bShowImages;                          // Show message images (autoset in the constructor, later must be updated)
	static bool              m_bWrapMargin;                          // Add a margin after the first word wrap ? (direct access)
	static bool              m_bTimestamp;                           // Timestamp           (autoset in the constructor , later must be updated)
	// Internal
	QPixmap                * m_pixViewBack;                          // Default background pixmap  (direct access,overridden)
	//========================================================================================================
	// APPLICATION
#ifdef COMPILE_USE_AA_FONTS
	static bool              m_bUseFontAntiAliasing;
#endif
	static bool              m_bSetGlobalPaletteAtStartup;
	static QColor            m_clrNormalGlobalForeground;
	static QColor            m_clrNormalGlobalButton;
	static QColor            m_clrNormalGlobalLight;
	static QColor            m_clrNormalGlobalDark;
	static QColor            m_clrNormalGlobalMid;
	static QColor            m_clrNormalGlobalText;
	static QColor            m_clrNormalGlobalBase;
	static QColor            m_clrDisabledGlobalForeground;
	static QColor            m_clrDisabledGlobalText;
	static QColor            m_clrDisabledGlobalBase;

	static QFont             m_fntApplication;
	static KviStr            m_szApplicationGUIStyle;
	//========================================================================================================
	// MIRC COLORS
	static bool              m_bUseKsircControlCodes;
	static QColor          * m_pMircColor[16];                       // The 16 mIrc colors (direct access from KviIrcView)
	static unsigned char     m_cViewOutSeleBack;                     // Selected background        (direct)
	static unsigned char     m_cViewOutSeleFore;                     // Selected foreground        (direct)
	static unsigned char     m_cViewOutUrlFore;                      // Url highlight color        (direct)
	//========================================================================================================
	// OTHER GUI STUFF
	static bool              m_bUseBigToolbarPixmaps;
	static bool              m_bUseBigUToolbarPixmaps;
	static bool              m_bUseTextToolbarComment;
	static bool              m_bUseThemeMenubarBackground;
	static unsigned char     m_cViewOutTypeBack[KVI_OUT_NUM_IMAGES]; // Background for type output (direct)
	static unsigned char     m_cViewOutTypeFore[KVI_OUT_NUM_IMAGES]; // Foreground for type output (direct)
	//========================================================================================================
	// OUTPUT REDIRECTIONS
	static bool              m_bJoinMsgsToConsole;              // [false=correct channel]
	static bool              m_bPartMsgsToConsole;              // [false=correct channel]
	static bool              m_bKickMsgsToConsole;              // [false=active window]
	static bool              m_bQuitMsgsToConsole;              // [false=all the windows that qutter is on]
	static bool              m_bNickMsgsToConsole;              // [false=all the windows that the nicker is on]
	static bool              m_bTopicMsgsToConsole;             // [false=active window]
	static bool              m_bDesyncMsgsToConsole;            // Local desync error msgs (JOIN to inexisting channels) [false=active]
	static bool              m_bServerInfoToConsole;            // [false=active window]
	static bool              m_bSplitWarningsToConsole;         // [false = active window]
	static bool              m_bUnhandledServerErrorsToConsole; // [false=active window]
	static bool              m_bUnhandledNumericsToConsole;     // [false=active window]
	static bool              m_bUnhandledLiteralsToConsole;     // [false=active window]
	static bool              m_bNicknameErrorsToConsole;        // [false=active window]
	static bool              m_bNamesReplyToConsole;            // [false=active window]
	static bool              m_bUserModeChangesToConsole;       // [false = active window] (my mode changes!!!)
	static bool              m_bChannelModeChangesToConsole;    // [false = correct chan]
	static bool              m_bWhoMsgsToConsole;
	static bool              m_bBanAndExceptionListToConsole;   // If show the above ...[false = correct channel]
	static bool              m_bOffChannelNoticesToConsole;     // [false=active window]
	static bool              m_bServerNoticesToConsole;
	static bool              m_bWhoisRepliesToConsole;
	static bool              m_bDnsResultsToConsole;            // [false=active window]
	static bool              m_bInviteMessagesToConsole;
	static bool              m_bNotifyListChangesToConsole;
	static bool              m_bProcessOutputToConsole;         // [false=active window]
	static bool              m_bWallopsToConsole;               // [false=active window]
	//========================================================================================================
	// CTCP Stuff
	static bool              m_bCtcpRequestsToConsole;          // [false=active]
	static bool              m_bChannelCtcpRequestsToConsole;   // [false=channel]
	static bool              m_bCtcpRepliesToConsole;
	static bool              m_bCtcpFloodWarningsToConsole;
	static bool              m_bReplyErrmsgOnUnknownCtcp;
	static bool              m_bIgnoreCtcpPingRequests;
	static bool              m_bIgnoreCtcpVersionRequests;
	static bool              m_bIgnoreCtcpTimeRequests;
	static bool              m_bIgnoreCtcpUserinfoRequests;
	static bool              m_bIgnoreCtcpClientinfoRequests;
	static bool              m_bIgnoreCtcpSourceRequests;
	static bool              m_bIgnoreCtcpFingerRequests;
	static bool              m_bUseAntiCtcpFlood;
	static bool              m_bAppendRealUsernameToUserinfoReply;
	static bool              m_bAppendUnameToClientinfoReply;
	static int               m_iMaxCtcpCount; //max ctcps
	static int               m_iMaxCtcpTime;  //in n seconds
	//========================================================================================================
	// Irc engine
	static bool              m_bShowPingPong; // Show server PING & our PONG message ?  [output options]
	static bool              m_bShowOwnParts; //[false= do not show]
	static bool              m_bShowOwnNickChanges; //[false= do not show :)]
	static bool              m_bSkipMotd; 
	static bool              m_bBrutalQuit; //wait for the server to close the connection ?
	static bool              m_bAutoRejoinOnKick;
	static bool              m_bDumpChannelOnKick; //dump channel status to file when kicked
	static bool              m_bRequestBanExceptionListOnJoin;
	static bool              m_bRequestWhoAfterEndOfNames;
	static bool              m_bShowInternalWhoMessages; //Show the WHO replies used to update the channel list ?
	static bool              m_bShowBanAndExceptionList; //Shows the incoming messages ?
	static bool              m_bCreateQueryOnPrivmsg;
	static bool              m_bCreateQueryOnNotice;
	static bool              m_bCreateIconifiedQuery;
	static bool              m_bUseSmallAntispamOnPrivmsg;
	static bool              m_bUseAntiQueryFlood;
	static bool              m_bQueryFloodWarningsToConsole;
	static int               m_iMaxTotalQueries; //max total queries
	static int               m_iMaxQueryCount; //max queries
	static int               m_iMaxQueryTime;  //in n seconds
	static bool              m_bUrlHighlighting;  //Highlight url's ?         (direct)
	static bool              m_bAutoJoinChanOnInvite;
	static bool              m_bPrivmsgFormatNickIsALink;
	static KviStr            m_szPrivmsgFormatNickLinkCommand;
	static bool              m_bUseExtendedPrivmsgView; // Use the options below for PRIVMSG formatting
	static bool              m_bEnableNickModePrefix;
	static bool              m_bShowUserAndHostInPrivmsgs;
	static bool              m_bShowExtendedServerInfo;
	static KviStr            m_szExtPrivmsgPrefix;
	static KviStr            m_szExtPrivmsgPostfix;

	static bool              m_bUseStringSubstitution;

	static KviStr            m_szLastScriptPath; // INTERNAL!!!


	KviStrSub	*m_pStrSub;

	bool   m_bListenToCtcpMultimedia;
	bool   m_bPlayDefaultFileWhenFileNotFound;
	KviStr m_szCtcpMultimediaDefaultFileName;
	bool   m_bSendMultimediaRequestWhenFileNotFound;
	bool   m_bListenToMultimediaFileRequests;

	bool m_bBindIrcSocketToSpecificInterface;
	//
	// ### Stuff used by KviIrcSocket
	// KviDlgOptServer - misc options tab
	bool   m_bAutoReconnectOnDisconnect;
	bool   m_bCloseWindowsOnDisconnect;
	bool   m_bTryNextServerOnConnectFailed;
	
	static int m_iOnIdleAfter;
	bool	m_bCancelIdleOnAnyInput;

	static bool m_bRejoinChannelsOnReconnect;

	int    m_iSocketTimeout;    //Direct access from KviIrcSocket
	static KviStr m_szLocalHostIp;    //Local host Ip (used from KviFrame class)
	//
	// ### The server list  ###
	// KviDlgOptServer
	KviIrcServerManager * m_pServerManager;
	KviIrcProxyManager  * m_pProxyManager;

	bool m_bUseTelnetProxy;
	bool m_bUseProxy;
	bool m_bProxyProtoV5;
	bool m_bProxyProtoHttp;

	KviWindowPropertiesList *m_pWinPropertiesList;

	bool m_bStatusBarVisible;


	// Output redirections tab

	// Internals tab
	bool m_bBeVerbose; //spit more info to the console
	bool m_bUseHackedFrameGeometry; //use frameGeometry().topLeft() + size() instead of geometry() (used for the help window too)
	bool m_bDialogShowHackForBrainDamagedWM;
	bool m_bWindowsRememberProprietes; //otherwise always forget it
	bool m_bWindowsRememberDockState; //otherwise always popup docked
	bool m_bWindowsRememberMaximizeState; //otherwise never maximized
	int  m_iViewMaxBufferSize;//Maximum buf size    (autoset , later must be updated (updated in KviFrame::applyOptions))
	KviStr m_szStringToAddAfterCompletedNick;
	bool m_bApplyCompletionPostfixForFirstWordOnly;
	bool m_bCompletionReplaceWholeWord;
	bool m_bDoNotShowThePopupOnTextSelected;
	bool m_bWordHighlighting;
	KviStr m_szHighlightWords;
	KviStr m_szBrowserCommandline;
	bool m_bInputHistoryCursorAtEnd;
	bool m_bPedanticParser;
	bool m_bAvoidParserWarnings;
	bool m_bSendUnknownCommandsToServer;

	bool m_bAutoDisableBrokenEvents;

	bool m_bEnableNotifyList;
	bool m_bEnableDalNetStyleNotifyMethod;
	int  m_iNotifyListCheckTimeoutInSecs;
	KviRegisteredUsersDb * m_pRegUsersDb;

	bool m_bEnableIgnoreOnPrivmsg;
	bool m_bEnableIgnoreOnNotice;
	bool m_bVerboseIgnore;
	bool m_bSingleMessageForChannelModes;
	bool m_bShowChannelSyncTime;


	// Logging stuff
	bool m_bAutoLogConsole;
	bool m_bAutoLogChannels;
	bool m_bAutoLogQueries;
	bool m_bAutoLogChats;
	bool m_bAutoLogSends;
	bool m_bLogMsgType[KVI_OUT_NUM_IMAGES];
	bool m_bAppendServerNameToLogName;
	bool m_bAppendDateToLogName;

	bool m_bEnableDockWidget;
	bool m_bShowTipOfTheDayAtStartup;
	int  m_iNextTipOfTheDayIdx; // Internal


	char m_cPersonalCommandPrefix;

	bool m_bBeepOnNewQuery;
	bool m_bEnableBeeping;
	bool m_bAddUsersForBeepControl;

	bool m_bDisableUpdateUserList;
	int  m_iUserListUpdateTimeoutInSecs;


	// DCC STUFF
	bool m_bIgnoreDccRequests;
	bool m_bNotifyAllDccRequestsInConsole;

	static KviStr m_szLocalIncomingDirectory;
	static KviStr m_szSoundDevice;

	static KviStr m_szDccLocalIpAddress;
	static bool m_bUseUserDefinedIpForDccRequests;
//	bool m_bBindToUserDefinedIpForDccRequests;


	bool m_bAutoAcceptDccChat;
	bool m_bCreateIconifiedDccChat;

	bool m_bAutoAcceptDccSend;
	bool m_bEnableResumeOnAutoAccept;
	bool m_bCreateIconifiedDccSend;
	bool m_bAutoCloseDccSendOnSuccess;
	bool m_bNotifyDccSendCompletionInConsole;
	bool m_bReplaceSpacesInDccSendFileNames;
	bool m_bIgnorePortNumberInResumeRequests; //Useful with firewalls & co.
	bool m_bUseFastDccSend;
	int m_iDccSendBlockSize;

	bool m_bDccGetSendZeroAck;

	bool m_bDccListenOnPortsInRange;
	unsigned short int m_uMinDccListenPort;
	unsigned short int m_uMaxDccListenPort;

	bool m_bCreateIconifiedDccVoice;
	bool m_bAutoAcceptDccVoice;
	bool m_bFullDuplexSoundDevice;
	bool m_b090CompatibleVoiceCompression;

	KviMimeManager * m_pMimeManager;

//	bool m_bDirBrowserUseBigIcons;
	bool m_bDirBrowserShowHiddenFiles;
	bool m_bDirBrowserGroupFilesByExtension;
	bool m_bDirBrowserSortBySize;
	bool m_bDirBrowserSortCaseInsensitive;
//	bool m_bDirBrowserUseSingleClickMode;
	KviStr m_szDirBrowserOpenWithEditorCmd;
	bool m_bDirBrowserOpenAsMdiWindow;
	bool m_bDirBrowserOpenAlwaysUndocked;

	bool m_bScriptCenterShowAsDialog;
	bool m_bScriptCenterAddHelpBrowser;
	bool m_bScriptCenterAutoSaveWhenAccepted;

	bool m_bForceSyncDns;

#ifdef COMPILE_NEED_CHARSET_TRANSLATION
	bool m_bUseCharsetTranslation;
	KviStr m_szCharsetTranslationMapFile;
#endif

	//======================================================================================================
	// Non configurable stuff

	#ifdef _KVI_SCRIPTEDITOR_CPP_

		#define KVI_SCRIPTEDITOR_CLR_TEXT 0
		#define KVI_SCRIPTEDITOR_CLR_COMMAND 1
		#define KVI_SCRIPTEDITOR_CLR_COMMENT 2
		#define KVI_SCRIPTEDITOR_CLR_STRING 3
		#define KVI_SCRIPTEDITOR_CLR_ESCAPE 4
		#define KVI_SCRIPTEDITOR_CLR_BRACE 5
		#define KVI_SCRIPTEDITOR_CLR_LOCVAR 6
		#define KVI_SCRIPTEDITOR_CLR_GLOBVAR 7
		#define KVI_SCRIPTEDITOR_CLR_OPERATOR 8
		#define KVI_SCRIPTEDITOR_CLR_THIS 9
		#define KVI_SCRIPTEDITOR_CLR_IDENT 10
		#define KVI_SCRIPTEDITOR_CLR_DISABLEDBACK 11
		#define KVI_SCRIPTEDITOR_CLR_ENABLEDBACK 12
	
	#endif

	#define KVI_SCRIPTEDITOR_NUM_COLORS 13

	QColor * m_pScriptEditorClr[KVI_SCRIPTEDITOR_NUM_COLORS];


	//======================================================================================================
	// INTERNAL STUFF
	QList<KviStr> * m_pHighlightWords; // Internal
//	bool m_bStatusBarVisible;          // Internal
//	bool m_bTaskBarVisible;            // Internal 
//	bool m_bToolBarVisible;            // Internal
//	bool m_bSysTrayBarVisible;         // Internal
//#define KVI_TOOL_BAR_DOCK_TOP 0
//#define KVI_TOOL_BAR_DOCK_LEFT 1
//#define KVI_TOOL_BAR_DOCK_RIGHT 2
//#define KVI_TOOL_BAR_DOCK_BOTTOM 3
//	int m_iTaskBarDock;                // Internal
//	int m_iToolBarDock;                // Internal
//	int m_iUserToolBarDock;            // Internal
//	int m_iSysTrayBarDock;             // Internal
	QList<KviStr> * m_pDirBookmarks;   // Internal
	KviStr m_szRecentServers;          // Internal
	KviStr m_szRecentChannels;         // Internal
	KviStr m_szRecentNicknames;        // Internal
	KviStr m_szSysTrayMode;            // Internal
	QRect  m_rectFrameGeometry;        // Internal
//	QRect  m_rectHelpWinGeometry;      // Internal
//	QRect  m_rectDirBrowserGeometry;   // Internal
//	int    m_iDirBrowserWidth;         // Internal
	QRect  m_rectScriptDialog;         // Internal
	QRect  m_rectGeneralOptionsDialog;
	KviStr m_szLastBrowsedDirectory;   // Internal

public:
	void load();
	void save();

	void loadMircColors();
	void saveMircColors();
	void loadViewOptions();
	void saveViewOptions();
	void loadListBoxOptions();
	void saveListBoxOptions();
	void loadInputOptions();
	void saveInputOptions();
	void loadSocketOptions();
	void saveSocketOptions();
	void loadWinProperties();
	void saveWinProperties();
	void loadServerOptions();
	void saveServerOptions();
	void loadUserOptions();
	void saveUserOptions();
	void loadMdiOptions();
	void saveMdiOptions();
	void loadLabelsOptions();
	void saveLabelsOptions();
	void loadHelpOptions();
	void saveHelpOptions();
	void loadIrcOptions();
	void saveIrcOptions();
	void loadFrameOptions();
	void saveFrameOptions();
	void loadAliases();
	void saveAliases();
	void loadEvents();
	void saveEvents();
	void loadPopups();
	void savePopups();
	void loadMimeTypes();
	void saveMimeTypes();
	void loadDccOptions();
	void saveDccOptions();
	void loadRegUsers();
	void saveRegUsers();
	void loadLoggingOptions();
	void saveLoggingOptions();
	void loadScriptCenterOptions();
	void saveScriptCenterOptions();
	void saveToolBar();
	void loadToolBar();
	void saveRawEvents();
	void loadRawEvents();
#ifdef COMPILE_PLUGIN_SUPPORT
	void savePlugins();
	void loadPlugins();
#endif
	void saveStrSub();
	void loadStrSub();
	void saveDirBrowserOptions();
	void loadDirBrowserOptions();
	//Helpers
	void loadBackgroundImage(KviStr &pix_file,QPixmap *pix_ptr,const QPixmap * cached = 0);
public:

	void calculateInputFontVariables();
	void calculateListBoxFontVariables();
	void loadInputBackgroundImage(const QPixmap * cached = 0);
	void loadListBoxBackgroundImage(const QPixmap * cached = 0);
	void loadOutputBackgroundImage(const QPixmap * cached = 0);
	void loadMdiBackgroundImage(const QPixmap * cached = 0);
	void loadLabelsBackgroundImage(const QPixmap * cached = 0);
	void fillHighlightWordsList();
};

#ifndef _KVI_OPTIONS_CPP_
	extern KviOptions *g_pOptions;
#endif

#endif //_KVI_OPTIONS_H_INCLUDED_
