#ifndef _KVI_LISTBOX_H_INCLUDED_
#define _KVI_LISTBOX_H_INCLUDED_

//
//   File : kvi_listbox.h (/usr/build/NEW_kvirc/kvirc/src/kvirc/kvi_listbox.h)
//   Last major modification : Wed Mar 10 1999 17:49:56 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include <qwidget.h>
#include <qpixmap.h>
#include <qscrollbar.h>
#include <qlist.h>

class KviFrame;
class KviIrcUser;
class KviUserParser;
class KviWindow;

#include "kvi_userlist.h"

class KviListBoxScrollBar : public QScrollBar
{
	friend class KviListBox;
	Q_OBJECT
public:
	KviListBoxScrollBar(QWidget * par,const char * name)
		: QScrollBar(par,name){};
	~KviListBoxScrollBar(){};
};

class KviListBox : public QWidget
{
	Q_OBJECT
public:
	KviListBox(QWidget *parent,KviWindow * parentWnd,KviUserParser * parser,KviFrame * pFrm);
	~KviListBox();
private:
	KviListBoxScrollBar * m_pScrollBar;
protected:
	KviFrame   * m_pFrm;
	QPixmap    * m_pMemBuffer;
	HANDLE       m_hMemBuffer;
	int          m_iCurTopItem;
	KviIrcUserChanList * m_pClientList;
	int          m_iLastSelectedItem;
	KviUserParser * m_pUserParser;
	KviWindow     * m_pParent;
public:
	void partAll();
	void join(const KviIrcUser &user,char bOp=0,char bVoice=0,char bHalfOp=0,char bUserOp=0,char bOwner=0,bool bRepaint = true);
	void part(const char *nick);
	void part(const KviIrcUser &user);
	void select(const char *nick);
	void select(const KviIrcUser &user);
	void selectAll();
	void deselect(const char *nick);
	void deselect(const KviIrcUser &user);
	void deselectAll();
	bool owner(const KviIrcUser &user,char bOwner);
	bool owner(const char *nick,char bOwner);
	bool op(const KviIrcUser &user,char bOp);
	bool op(const char *nick,char bOp);
	bool halfop(const KviIrcUser &user,char bHalfOp);
	bool halfop(const char *nick,char bHalfOp);
	bool nickChange(const KviIrcUser &nicker,const char *nick);
	bool voice(const KviIrcUser &user,char bVoice);
	bool voice(const char *nick,char bVoice);
	bool userop(const KviIrcUser &user,char bUserOp);
	bool userop(const char *nick,char bUserOp);
	QList<KviStr> * createNickStringList();
	// Redirects
	bool isOwner(const KviIrcUser &user){ return m_pClientList->isOwner(user); };
	bool isOwner(const char *nick){ return m_pClientList->isOwner(nick); };
	bool isOp(const KviIrcUser &user){ return m_pClientList->isOp(user); };
	bool isOp(const char *nick){ return m_pClientList->isOp(nick); };
	bool isHalfOp(const KviIrcUser &user){ return m_pClientList->isHalfOp(user); };
	bool isHalfOp(const char *nick){ return m_pClientList->isHalfOp(nick); };
	bool isVoice(const KviIrcUser &user){ return m_pClientList->isVoice(user); };
	bool isVoice(const char *nick){ return m_pClientList->isVoice(nick); };
	bool isUserOp(const KviIrcUser &user){ return m_pClientList->isUserOp(user); };
	bool isUserOp(const char *nick){ return m_pClientList->isUserOp(nick); };
	int count(){ return m_pClientList->count(); };
	int ownerCount(){ return m_pClientList->ownerCount(); };
	int opCount(){ return m_pClientList->opCount(); };
	int halfopCount(){ return m_pClientList->halfopCount(); };
	int voiceCount(){ return m_pClientList->voiceCount(); };
	int useropCount(){ return m_pClientList->useropCount(); };
	int findUserPosition(const char *nick){ return m_pClientList->findUserPosition(nick); };
	KviIrcUser * findUser(const KviIrcUser &user){ return m_pClientList->findUser(user); };
	KviIrcUser * findUser(const char *nick){ return m_pClientList->findUser(nick); };
	KviIrcUser * firstUser(){ return m_pClientList->firstUser(); };
	KviIrcUser * lastUser(){ return m_pClientList->lastUser(); };
	KviIrcUser * nextUser(){ return m_pClientList->nextUser(); };
	KviIrcUser * prevUser(){ return m_pClientList->prevUser(); };
	KviIrcUser * firstOp();
	KviIrcUserChanList * userList(){ return m_pClientList; };
	void doRepaint();
	void appendSelectedNicknames(KviStr &buffer);
	void appendSelectedMasks(KviStr &buffer);
	void appendSelectedHosts(KviStr &buffer);
	void appendSelectedUsernames(KviStr &buffer);
	void appendNickList(KviStr &str);
	void appendOwnerList(KviStr &str);
	void appendOpList(KviStr &str);
	void appendNOpList(KviStr &str);
	void appendHalfOpList(KviStr &str);
	void appendVoiceList(KviStr &str);
	void appendUserOpList(KviStr &str);
	virtual void wheelEvent(QWheelEvent *e);
protected:
	void updateScrollBar();
	virtual void paintEvent(QPaintEvent *);
	virtual void resizeEvent(QResizeEvent *);
	virtual void mousePressEvent(QMouseEvent *e);
	virtual void mouseMoveEvent(QMouseEvent *e);
	virtual void mouseReleaseEvent(QMouseEvent *e);
	virtual void dragEnterEvent(QDragEnterEvent *e);
	virtual void dragMoveEvent(QDragMoveEvent *e);
	virtual void dropEvent(QDropEvent *e);
	virtual void mouseDoubleClickEvent(QMouseEvent *e);
protected slots:
	void scrollBarMoved(int value);
	int itemFromPos(QPoint pos);
signals:
	void rightClicked();
};

#endif //!_KVI_LISTBOX_H_INCLUDED_
