#ifndef _KVI_DNS_H_INCLUDED_
#define _KVI_DNS_H_INCLUDED_

//
//   File : kvi_dns.h (/usr/build/NEW_kvirc/kvirc/kvirc/kvi_dns.h)
//   Last major modification : Sun Jan 10 1999 18:54:30 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include "kvi_string.h"
// Threaded implementation

#include "kvi_thread.h"

#include <qtimer.h>

class KviAsyncDns;

typedef struct KviDnsStruct
{
	KviStr szHostToResolve;
	KviStr szHostname;
	KviStr szIp;
	KviStr szAlias1;
	KviStr szAlias2;
	KviAsyncDns * dnsParent;
	int iError;
	KviStr szData;
	bool bIpV6;
};

class KviAsyncDns : public QObject {
	Q_OBJECT
public:
	KviAsyncDns();
	~KviAsyncDns();
private:
	bool m_bThreadRunning;
	KviDnsStruct * m_dnsStruct;
	pthread_t m_thread;
public:
	bool isRunning(){ return m_bThreadRunning; };
	bool resolve(const char * hostname,const char *data = 0,bool bIpV6 = false);
	bool abort();
	/*
		This one can be used after the dnsFinished signal has been triggered
		and no new lookup has been started
		It sets the dnsStruct to zero without deleting it
		and returns the pointer to it.
		In this way the user class can take control over the data structure
	*/
	KviDnsStruct * forgetDnsStruct();
protected:
	virtual bool event(QEvent *e);
signals:
	void dnsFinished(KviDnsStruct *);
};


#endif //_KVI_DNS_H_INCLUDED_
