//
//   File : kvi_dcc_core.cpp (/usr/build/NEW_kvirc/kvirc/src/kvirc/kvi_dcc_core.cpp)
//   Last major modification : Thu Jun 17 1999 13:49:03 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

//#define _KVI_DEBUG_CLASS_NAME_ "KviDccCoreStuff"
//#define _KVI_DEBUG_CHECK_RANGE_
#include "kvi_debug.h"

#define _KVI_DCC_CORE_CPP_
#include "kvi_dcc_core.h"
#include "kvi_defines.h"
#include "kvi_netutils.h"

#include "kvi_thread.h"
#include "kvi_error.h"

#include <sys/time.h>
#include <unistd.h>
#include <errno.h>

#define KVI_DCC_IDLE_TIME_USECS 200

extern KviThreadEventDispatcher *g_pThreadEventDispatcher;

bool kvi_dccCore_selectForRead(int sock)
{
	fd_set in_fd_set;
	struct timeval tv;

	FD_ZERO(&in_fd_set);
	FD_SET(sock,&in_fd_set);

	tv.tv_sec  = 0;
	tv.tv_usec = KVI_DCC_IDLE_TIME_USECS;

//	kvi_threadTestCancel();
	// FIXME : "Maybe check for select() errors here ?"
	return (select(sock + 1,&in_fd_set,0,0,&tv) == 1);
}

int kvi_dccCore_connect(int sock,struct sockaddr *hostSockAddr,int addrlen)
{
	for(;;){ //EINTR loop....threads use signals to communicate...

		kvi_threadTestCancel();

		if(::connect(sock,hostSockAddr,addrlen)<0){
			if(errno != EINTR){
				switch(errno){
					case EINPROGRESS:  return KVI_ERROR_Success;               break;
					case EBADF:        return KVI_ERROR_BadFileDescriptor;     break;
					case EFAULT:       return KVI_ERROR_OutOfAddressSpace;     break;
					case ECONNREFUSED: return KVI_ERROR_ConnectionRefused;     break;
					case ENOTSOCK:     return KVI_ERROR_KernelNetworkingPanic; break;
					case ETIMEDOUT:    return KVI_ERROR_ConnectionTimedOut;    break;
					case ENETUNREACH:  return KVI_ERROR_NetworkUnreachable;    break;
					case EPIPE:        return KVI_ERROR_BrokenPipe;            break;
					// Unhandled error...pass errno to the strerror function
					default:           return -errno;                          break;
				}
			} // else try again
		} else return KVI_ERROR_Success;

	}
	return KVI_ERROR_Success; //Newer here.
}

void kvi_dccCore_errorExitThread(const char *errorMsg,QObject * target)
{
	__debug(">>> kvi_dccCore_threadErrorExit");
	KviDccEvent *e = new KviDccEvent(KVI_DCC_EVENT_ERROR,errorMsg);
	g_pThreadEventDispatcher->postEvent(e,target);
	__debug("### calling pthread_exit(0) in kvi_dccCore_threadErrorExit");
	kvi_threadExit(0);
	__debug("<<< kvi_dccCore_threadErrorExit");
}

void kvi_dccCore_threadCleanupCloseSocket(void * data)
{
	// Cleanup callback for the pthread library in case of cancellation
	__debug("kvi_threadCleanupCloseSocket");
	int * sock = (int *)data;
	close(*sock);
}

//bool kvi_dccCore_doListen(int sock,struct sockaddr_in * pListeningSockAddress)
//{
//	pListeningSockAddress->sin_family      = AF_INET;
//	pListeningSockAddress->sin_port        = htons(0); // :)
//	pListeningSockAddress->sin_addr.s_addr = INADDR_ANY;
//
//	if(bind(sock,(struct sockaddr *)pListeningSockAddress,sizeof(*pListeningSockAddress))<0)return false;
//	if(listen(sock,100)<0)return false;
//
//	_this_should_be_socklen_t iSize = sizeof(*pListeningSockAddress);
//	if(getsockname(sock,(struct sockaddr*)pListeningSockAddress,&iSize)<0)return false;
//
//	return true;
//}


int kvi_dccCore_waitForIncomingConnection(int sock,unsigned long * uRetAddress,
		unsigned short * uRetPort,KviStr * szRetAddress)
{
	// Now loop
	// select() the socket for reading ...
	// newer time out... :)
	// timeout is nearly senseless...
	// the user will just close the window if
	// there will be no connection in some minutes...

	struct sockaddr_in connectedAddr;
	int newsock = -1;

	for(;;){
		kvi_threadTestCancel();

		if(kvi_dccCore_selectForRead(sock)){
			// Can try to accept
			kvi_threadTestCancel();

			_this_should_be_socklen_t iSize = sizeof(connectedAddr);
			newsock = accept(sock,(struct sockaddr*)&connectedAddr,&iSize);
			if(newsock == -1)debug("warning : accept returns -1...waiting for the next accept call");
			else {
				// Connected
				*uRetAddress = connectedAddr.sin_addr.s_addr;
				*uRetPort = ntohs(connectedAddr.sin_port);
				kvi_binaryIpToString(connectedAddr.sin_addr,*szRetAddress);
				return newsock;
			}

		} else {
			// give time to other threads...(there is no way to give the control to another thread now ?)
			kvi_threadTestCancel();
			usleep(KVI_DCC_IDLE_TIME_USECS);
			kvi_threadTestCancel();
		}
	}
}

int kvi_dccCore_waitForOutgoingConnection(int sock)
{
	fd_set fset;
	struct timeval tv;

	// select() the socket for writing ...
	for(;;){
		FD_ZERO(&fset);
		FD_SET(sock,&fset);
		tv.tv_sec  = 0;
		tv.tv_usec = KVI_DCC_IDLE_TIME_USECS;

		kvi_threadTestCancel();
		int retval = select(sock + 1,0,&fset,0,&tv);
		kvi_threadTestCancel();

		if(retval == 1){
			// Connected ?
			// Check for errors....
			int nSockErr;
			_this_should_be_socklen_t iSize = sizeof(int);
			if(getsockopt(sock,SOL_SOCKET,SO_ERROR,(void *)&nSockErr,&iSize)==-1)return KVI_ERROR_BadFileDescriptor;
			if(nSockErr!=0){
				// oops...error != 0
				if((nSockErr != EINTR)&&(nSockErr != EINPROGRESS)){
					switch(nSockErr){
						case EBADF:        return KVI_ERROR_BadFileDescriptor;     break;
						case EFAULT:       return KVI_ERROR_OutOfAddressSpace;     break;
						case ECONNREFUSED: return KVI_ERROR_ConnectionRefused;     break;
						case ENOTSOCK:     return KVI_ERROR_KernelNetworkingPanic; break;
						case ETIMEDOUT:    return KVI_ERROR_ConnectionTimedOut;    break;
						case ENETUNREACH:  return KVI_ERROR_NetworkUnreachable;    break;
						case EPIPE:        return KVI_ERROR_BrokenPipe;            break;
						// Unhandled error...pass errno to the strerror function
						default:			return -nSockErr;                       break;
					}
				} // else EINTR or EINPROGRESS
			} else return KVI_ERROR_Success;

		} else {
			// Retval != 1...continue loop
/* FIXME : "Test for select() errors here!!! if retval == -1" */
			if(retval < 0)debug("select() error");
			// give time to other threads...(there is no way to give the control to another thread now ?)
			kvi_threadTestCancel();
			usleep(KVI_DCC_IDLE_TIME_USECS);
			kvi_threadTestCancel();
		}
	}
}
