#ifndef _KVI_CHANEDITORS_H_INCLUDED_
#define _KVI_CHANEDITORS_H_INCLUDED_

//
//   File : kvi_chaneditors.h (/usr/build/NEW_kvirc/kvirc/src/kvirc/kvi_chaneditors.h)
//   Last major modification : Sat May 1 1999 01:42:36 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include <qframe.h>
#include <qlineedit.h>
#include <qcheckbox.h>
#include <qpushbutton.h>
#include <qlist.h>
#include <qlistview.h>
#include <qlabel.h>

#include "kvi_selectors.h"
#include "kvi_string.h"

class KviTopicEditor : public KviLineEdit
{
	Q_OBJECT
public:
	KviTopicEditor(QWidget * parent);
	~KviTopicEditor();
	QList<KviStr> *m_pHistory;
	void connectMe(QObject * receiver,const char *slot);
protected:
	KviStr m_szSaveTextBuffer;
	int m_iCurHistoryIdx;
	virtual void focusOutEvent(QFocusEvent *);
	virtual void keyPressEvent(QKeyEvent *e);
};

//imnpst

typedef struct KviModeDescriptionEntry
{
	char flag;
	const char *description;
};

class KviModeEditor : public QFrame
{
	Q_OBJECT
public:
	KviModeEditor(QWidget * parent);
	~KviModeEditor();
protected:
	static KviModeDescriptionEntry modeTable[6];
	QCheckBox   * m_pCheck[6];
	bool          m_bInitState[6];
	QPushButton * m_pCommit;
	QCheckBox   * m_pLimitCheck;
	QLineEdit   * m_pLimitEdit;
	QCheckBox   * m_pKeyCheck;
	QLineEdit   * m_pKeyEdit;
	KviStr        m_szInitLimit;
	KviStr        m_szInitKey;
public:
	void doEdit(KviStr &flags,KviStr &limit,KviStr &key,QObject *receiver,const char *slot);
	void setCanCommit(bool bCanCommit);
protected slots:
	void commitChanges();
	void cancel();
signals:
	void modeChanged(const char *newMode,const char * additionalModeChange);
};

class KviBanMask;

class KviMaskEditor : public QFrame
{
	Q_OBJECT
public:
	KviMaskEditor(QWidget * parent);
	~KviMaskEditor();
protected:
	QListView   * m_pMaskBox;
	QPushButton * m_pRemoveMask;
	QPushButton * m_pCommit;
	QLabel      * m_pLabel;
	KviStr        m_szMasksRemoved;
public:
	void doEdit(QObject * receiver,const char * slot,QList<KviBanMask> * maskList,const char * masksLabel,bool bCanCommit);
	void setCanCommit(bool bCanCommit);
protected:
	void setMasks(QList<KviBanMask> * maskList,const char *masksLabel);
protected slots:
	void commitChanges();
	void cancelClicked();
	void removeMaskClicked();
signals:
	void masksEditCompleted(const char *bansToRemove);
};
#endif //!_KVI_CHANEDITORS_H_INCLUDED_