#ifndef _KVI_ASYNCDIALOGS_H_INCLUDED_
#define _KVI_ASYNCDIALOGS_H_INCLUDED_

//
//   File : kvi_asyncdialogs.h (/usr/build/NEW_kvirc/kvirc/src/kvirc/kvi_asyncdialogs.h)
//   Last major modification : Tue Mar 2 1999 04:56:38 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include <qfiledialog.h>
#include <qmessagebox.h>
#include <qlineedit.h>
#include "kvi_string.h"

class KviUserParser;
class KviWindow;

class KviAsyncDialogCore
{
protected:
	KviAsyncDialogCore(KviUserParser * parser,KviWindow *pWnd);
public:
	~KviAsyncDialogCore();
public:
	KviStr m_szJob;
	KviStr m_szMagic;
	KviWindow * m_pWnd;
	KviUserParser * m_pParser;
	void setJob(const char *beginptr,const char *endptr = 0);
	void runJob(const char *dialogresult);
};

class KviAsyncFileDialog : public QFileDialog , public KviAsyncDialogCore
{
	Q_OBJECT
public:
	KviAsyncFileDialog(KviUserParser * parser,KviWindow *pWnd);
	~KviAsyncFileDialog();
public:
	void openFileName();
	void saveFileName();
	void openFileNames();
	void openDirectory();
	virtual void done(int r);
};

class KviAsyncMessageBox : public QMessageBox , public KviAsyncDialogCore
{
	Q_OBJECT
public:
	KviAsyncMessageBox(KviUserParser * parser,KviWindow *pWnd,const char *caption,
		const char *text,const char *icon,const char *btn1);
	KviAsyncMessageBox(KviUserParser * parser,KviWindow *pWnd,const char *caption,
		const char *text,const char *icon,const char *btn1,const char *btn2);
	KviAsyncMessageBox(KviUserParser * parser,KviWindow *pWnd,const char *caption,
		const char *text,const char *icon,const char *btn1,const char *btn2,const char *btn3);
	~KviAsyncMessageBox();
	virtual void done(int r);
	void doSetIcon(const char *iconDescription);
};

class KviAsyncInputBox : public QDialog , public KviAsyncDialogCore
{
	Q_OBJECT
public:
	KviAsyncInputBox(KviUserParser *parser,KviWindow *pWnd,
		const char *caption,const char *text,const char *initialtext, bool passwd=false);
	~KviAsyncInputBox();
	QLineEdit * m_pLined;
	virtual void done(int r);
};

#endif //!_KVI_ASYNCDIALOGS_H_INCLUDED_
