//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#ifndef _KVI_APP_H_INCLUDED_
#define _KVI_APP_H_INCLUDED_

#undef Unsorted
#undef None

#include <qdir.h>

#include "kvi_settings.h"

#ifdef COMPILE_WITH_KDE
	#include <kapp.h>
	#include "kvi_appbase_kde.h"
#else
	#include <qapplication.h>
	#include "kvi_appbase_qt.h"
#endif //!COMPILE_WITH_KDE

#include <qlist.h>
#include <qdatetime.h>
#include <qasciidict.h>
#include <qwindowdefs.h> //at least for Display *

#include "kvi_defines.h"

#include "kvi_string.h"

class QStyle;

typedef struct _KviStyleEntry
{
	KviStr name;
	QStyle * (* get_style_object)();
	void * plugin_handle;
} KviStyleEntry;

class KviFrame;
class KviDlgOptUser;
class KviDlgOptServer;
class KviScriptCenter;
class KviDlgRegUsers;
class KviTipOfTheDay;
//class KviDlgAbout;
class KviScriptWizard;
class KviWMDockWidget;
class KviDlgLoadScript;
class KviGeneralOptionsDialog;
class KviUserParser;

class QPalette;

typedef struct KviSaveScriptStructTag KviSaveScriptStruct;


class KviApp : public KviAppBaseClass
{
	friend class KviUserParser; //checks our dialog pointers
	friend class KviWMDockWidget; //clears the m_pWMDockWidget variable when exiting
private:
	Q_OBJECT
public:
	KviApp(int argc,char ** argv);
	~KviApp();
public:
	QList<KviFrame> *m_pFrameList;
	QList<QObject>  *m_pDestroyList;
	KviStr           m_szLocalKVircDir;
	KviStr           m_szGlobalKVircDir;
	QList<KviStyleEntry> * m_pStyleList;
	KviStr           m_szLastHelpDocument;    // Used by the KviHelpQMLProvider and KviHelpWindow
	bool             m_bGuiUpdatePending;
	bool             m_bGlobalRepaintPending;
	KviStr           m_szLastGUIStyle;
	char             *m_pConfigFile;          // User defined config file
	bool             m_pCreateConfig;
	QDateTime        m_startupTime;
	QPalette         m_savedAppPalette;       // used by the options dialog
protected:
	KviDlgOptUser    *m_pUserOptionsDialog;
	KviDlgOptServer  *m_pServerOptionsDialog;
	KviDlgRegUsers   *m_pRegUsersDialog;
	KviTipOfTheDay	 *m_pTipOfTheDayDialog;
//	KviDlgAbout	     *m_pAboutDialog;
	KviScriptWizard  *m_pScriptWizard;
	KviWMDockWidget  *m_pWMDockWidget;
	KviDlgLoadScript *m_pLoadScriptDialog;
	KviGeneralOptionsDialog *m_pGeneralOptionsDialog;
	QAsciiDict<QPixmap> * m_pIconCache;
	KviScriptCenter  *m_pScriptCenter;
public:
	bool scriptCenterDialogOpen(){ return m_pScriptCenter != 0; };
	KviUserParser * anyUserParser();
	void registerStyle(const char *name,void * plugin_handle,QStyle * (*style_provider_routine)());
	void unregisterStyle(const char *name,void * plugin_handle);
	void unregisterStylesFor(void * plugin_handle);
	void setup();
	void connectAfterStartup(const char * server,const char * port);
	void insertNewFrame(KviFrame *frm);
	void removeFrame(KviFrame *frm);
	void requestHelpOn(const char * topic);
	void warningBox(const char *fmt,...);
	void raiseTopLevelWidget(QWidget * ptr);
	void destroyLater(QObject * o);
	enum KVircSubdir{
		None , Pics , Config ,
		Help , HelpEN , HelpNoIntl,
		Log , Incoming , Audio ,
		Scripts , Plugins , ConfigPlugins ,
		Trash , MsgColors , Charmaps };

	void getGlobalKVircDirectory(KviStr &szData,KVircSubdir dir=None,const char *appendFile=0);
	void getLocalKVircDirectory(KviStr &szData,KVircSubdir dir=None,const char *appendFile=0,bool bCreateIfNeeded=true);
	// Returns a config file name
	// If the file is in the local kvirc directory , it returns that one
	// Otherwise , if it is found in the global kvirc directory , it returns the global (default) one
	// Otherwise it returns false , and sets buffer to the local file name that still has to be written
	bool getReadOnlyConfigPath(KviStr &buffer,const char *config_name);

#ifdef COMPILE_PLUGIN_SUPPORT
	void getPluginConfigFilePath(KviStr &buffer,const char *plugin_name);
	bool getReadOnlyPluginConfigFilePath(KviStr &buffer,const char *plugin_name);
#endif

	void getChannelDumpLogFileName(KviStr &str);
	void getDefaultDccSaveFilePath(KviStr &path,const char *filename);

	bool findImage(KviStr &szRetPath,const char *filename);
	bool findUserFile(KviStr &szRetPath,const char *filename);
	bool cacheIcon(const char *filename);
	QPixmap * getFileIcon(const char *filename);
	void refreshMimeTypeIcons();

	void executeFileWithCommand(const char *commandline,const char *filePath,KviFrame * callerFrame = 0,bool bRemoteExec = false);
	bool trashFile(const char *filename);
	void triggerGlobalRepaint();

	bool saveScript(KviSaveScriptStruct *s);

	void hideAllFrames();
	void showAllFrames();
	void adjustPopupMenusForWMDockWidget();
	void wmDockWidgetDestroyed();
	void globalHighlight(bool bAltColor);
	void updateAllDirectoryBrowsers();
	void updateAllFrameCaptions();
	void showScriptCenter(KviFrame * par);
	void setApplicationStyle();
public slots:
	//Global toolbar slots
	void createNewFrame();
	void toggleFrame(int id);

	void slot_safeQuit();

	void slot_saveSettings();
	void slot_doUserOptionsDialog();
	void slot_userOptionsDialogFinished(bool bAccepted);
	void slot_doServerOptionsDialog();
	void slot_serverOptionsDialogFinished(bool bAccepted);
	void slot_scriptDialogFinished();
	void slot_doRegUsersDialog();
	void slot_regUsersDialogFinished(bool bAccepted);
	void slot_whatIsThisRequest();
	void slot_doTipOfTheDay();
	void slot_TipOfTheDayClosed();
	void slot_doAboutDialog();
//	void slot_AboutDialogClosed();
	void slot_doScriptWizard();
	void slot_scriptWizardFinished(bool bAccepted);

	void slot_doLoadScriptDialog();
	void slot_loadScriptDialogFinished(bool bAccepted);

	void slot_createWMDockWidget();
	void slot_destroyWMDockWidget();

	void restartNotifyLists();
	void globalRepaint();

	void emptyDestroyList();

	void slot_generalOptionsDialog();
	void slot_generalOptionsDialogFinished(bool bCommitChanges);

private:

	void createSplashScreen();
	void destroySplashScreen();
	void loadDirectories();
	void loadPixmaps();
	void createQMLProvider();
	void openUserConfig();
	bool findLocalKVircDirectory();
	void findGlobalKVircDirectory();
	bool checkGlobalKVircDirectory(const char *dir);
	bool checkLocalKVircDirectory(const char *dir);

	void saveKVircDirectory();


	void script_appendFontSettingsBuffer(KviStr &buffer,KviSaveScriptStruct *s);
	void script_appendColorSettingsBuffer(KviStr &buffer,KviSaveScriptStruct *s);
	void script_appendTextColorSettingsBuffer(KviStr &buffer,KviSaveScriptStruct *s);
	void script_appendMessageSettingsBuffer(KviStr &buffer,KviSaveScriptStruct *s);
	void script_appendOutputRedirectionSettingsBuffer(KviStr &buffer,KviSaveScriptStruct *s);
	void script_appendCTCPOptionsSettingsBuffer(KviStr &buffer,KviSaveScriptStruct *s);
	void script_appendIrcEngineOptionsSettingsBuffer(KviStr &buffer,KviSaveScriptStruct *s);
	void script_saveBackgrounds(KviStr &buffer,KviSaveScriptStruct *s);
	void script_saveBackground(KviStr &buffer,KviStr &szDir,const char *fName,const char *szPixName,QPixmap *pix,KviSaveScriptStruct *s);
	void script_saveAliases(KviStr &buffer,KviStr &path,KviSaveScriptStruct *s);
	void script_saveEvents(KviStr &buffer,KviStr &path,KviSaveScriptStruct *s);
	void script_saveRawEvents(KviStr &buffer,KviStr &path,KviSaveScriptStruct *s);
	void script_savePopups(KviStr &buffer,KviStr &path,KviSaveScriptStruct *s);
	void script_copyExtraFiles(KviStr &buffer,KviStr &path,KviSaveScriptStruct *s);
	void script_saveToolbar(KviStr &buffer,KviStr &path,KviSaveScriptStruct *s);
	void destroyPixmaps();
};

#ifndef _KVI_APP_CPP_
	extern KviApp *g_pApp;
#endif

#endif //_KVI_APP_H_INCLUDED
