//
//   File : kvi_app.cpp (/usr/build/NEW_kvirc/kvirc/kvirc/kvi_app.cpp)
//   Last major modification : Thu Dec 24 1998 04:05:26 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 19f99-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

//#define _KVI_DEBUG_CHECK_RANGE_
//#define _KVI_DEBUG_CLASS_NAME_ "KviApp"
#include "kvi_debug.h"

//#warning "Crypted dcc , or queries"

#include "kvi_app.h"
#include "kvi_locale.h" 
#include "kvi_frame.h"
#include "kvi_options.h"
#include "kvi_colorwin.h"
#include "kvi_window.h"
#include "kvi_mdi.h"
#include "kvi_imagelib.h"
#include "kvi_fileutils.h"
#include "kvi_malloc.h"
#include "kvi_msgbox.h"
#include "kvi_splash.h"
#include "kvi_varcache.h"
#include "kvi_helpqml.h"
#include "kvi_ircserver.h"

#include <qpopupmenu.h>

#include "kvi_dlguser.h"
#include "kvi_dlgserver.h"
#include "kvi_dlgscript.h"
#include "kvi_dlgoptions.h"
#include "kvi_dlgregusers.h"
#include "kvi_dlgloadscript.h"

#include "kvi_dirbrowser.h"

#include "kvi_scriptwizard.h"

#include "kvi_tipotd.h"

#include "kvi_alias.h"
#include "kvi_event.h"
#include "kvi_rawevent.h"

#include "kvi_helpwindow.h"

#include "kvi_popupmenu.h"

#include "kvi_jpegio.h"

#include "kvi_thread.h"
#include "config.h"

#include "kvi_mime.h"
#include "kvi_process.h"

#include "kvi_console.h"
#include "kvi_utoolbar.h"

#include "kvi_uparser.h"
#include "kvi_config.h"
#include "kvi_wmdock.h"
#include "kvi_menubar.h"

#include "kvi_ircview.h"

#ifdef COMPILE_PLUGIN_SUPPORT
	#include "kvi_plugin.h"
#endif

#include <qtextstream.h>
#include <qdir.h>
#include <qtimer.h>
#include <qpalette.h>

#include <qmotifstyle.h>
#include <qmotifplusstyle.h>
#include <qsgistyle.h>
#include <qcdestyle.h>
#include <qwindowsstyle.h>
#include <qplatinumstyle.h>
#include <qfileinfo.h>
#include <qstringlist.h>

#ifdef COMPILE_WITH_KDE
	#include <kimageio.h>
	#include <kstyle.h>
	#include <kconfig.h>
#endif

#include <X11/Xlib.h>


// Xlib.h defines None... that is an enum value for KviApp

#ifdef None
	#undef None
#endif

#define _KVI_APP_CPP_
// Global application pointer
// Auto declared as extern in kvi_app.h
KviApp *g_pApp;

#ifdef COMPILE_NEED_CHARSET_TRANSLATION
	#include "kvi_translate.h"
	KviCharsetTranslator * g_pCharsetTranslator;
#endif

KviThreadEventDispatcher *g_pThreadEventDispatcher;

//Other global stuff..
//Need to explicitly declare it as extern in other files
KviColorWindow *g_pColorWindow;
QPopupMenu     *g_pInputPopup;
QPopupMenu     *g_pTaskBarPopup;
QPopupMenu     *g_pViewSelectPopup;
QPopupMenu     *g_pWindowPopup;

//Various pixmaps...handled in loadPixmaps() and destroyPixmaps();
//QPixmap * g_pWindowIcon[KVI_WND_NUM_ICONS];
QPixmap * g_pListBoxOpPixmap;
QPixmap * g_pListBoxVoicePixmap;
QPixmap * g_pListBoxHelpOpPixmap;
QPixmap * g_pListBoxUserOpPixmap;
QPixmap * g_pListBoxOwnerPixmap;
//Stuff used by KviToolBar
QPixmap * g_pReadyStatePixmap;
QPixmap * g_pBusyStatePixmap;
QPixmap * g_pConnectedStatePixmap;
QPixmap * g_pSysTrayBigIcons[4];
QPixmap * g_pFileIcons[KVI_FILE_ICONS_NUM_IMAGES];
QPixmap * g_pBrowserIcons[KVI_BROWSER_ICONS_NUM_IMAGES];
QPixmap * g_pHelpIcons[KVI_HELP_ICONS_NUM_IMAGES];
//Used by KviIrcView
QPixmap * g_pixViewOut[KVI_OUT_NUM_IMAGES];
//Used here and in KviOptions
KviSplashScreen *g_pSplashScreen;
//Created and destroyed here , loaded and saved by KviOptions
KviAliasManager *g_pAliasManager;
KviEventManager *g_pEventManager;
KviVariableCache *g_pVarCache;
KviRawEventManager *g_pRawEventManager;

//KviHelpWindow *g_pHelpWindow;

KviPopupMenu *g_pChannelPopup;
KviPopupMenu *g_pUserlistPopup;
KviPopupMenu *g_pConsolePopup;
KviPopupMenu *g_pNotifylistPopup;
KviPopupMenu *g_pQueryPopup;
KviPopupMenu *g_pDccChatPopup;

KviUserToolBarTemplate *g_pUserToolBarTemplate;

KviConfig * g_pUserConfig;

#ifdef COMPILE_PLUGIN_SUPPORT
	KviPluginManager *g_pPluginManager;
#endif




//#warning "Remove g_display"
Display * g_display = 0;

// IRC VIEW GLOBALS

GC g_ircviewGC;
QPixmap * g_pIrcViewMemBuffer;
HANDLE g_hIrcViewMemBuffer;
QList<KviIrcView> * g_pIrcViewWidgetList;

void g_setSplashScreenText(const char *text)
{
	if(g_pSplashScreen)g_pSplashScreen->setText(text);
}

void g_setSplashScreenProgress(int progress)
{
	if(g_pSplashScreen)g_pSplashScreen->setProgress(progress);
}

QStyle * g_getMotifStyle()
{
	return new QMotifStyle();
}

QStyle * g_getMotifPlusStyle()
{
	return new QMotifPlusStyle();
}

QStyle * g_getWindowsStyle()
{
	return new QWindowsStyle();
}

QStyle * g_getSGIStyle()
{
	return new QSGIStyle();
}

QStyle * g_getCDEStyle()
{
	return new QCDEStyle();
}

QStyle * g_getPlatinumStyle()
{
	return new QPlatinumStyle();
}

//=============================== KviApp ===================================//
//
// Application constructor
//

KviApp::KviApp(int argc,char ** argv)
:KviAppBaseClass(argc,argv,"kvirc")
{
	m_startupTime = QDateTime::currentDateTime();

#ifdef COMPILE_JPEG_SUPPORT
	kvi_initJpegIo();
#endif

#ifdef COMPILE_WITH_KDE
	KImageIO::registerFormats(); // Support all the formats supported by KDE
	//(FIXME: Qt may have jpeg support so maybe we can avoid to compile the native one ? )
#endif
	// Initialize the main thread (setup signal handlers etc..)
	kvi_threadInitialize();
	// Create our lista
	m_pFrameList   = new QList<KviFrame>;
	m_pFrameList->setAutoDelete(false);
	m_pDestroyList = new QList<QObject>;
	m_pDestroyList->setAutoDelete(true);
	m_pStyleList   = new QList<KviStyleEntry>;
	m_pStyleList->setAutoDelete(true);
	m_pIconCache   = new QAsciiDict<QPixmap>;
	m_pIconCache->setAutoDelete(true);
	// Config stuff
	m_pConfigFile   = 0;
	m_pCreateConfig = false;
	// Cleanup all our pointers to avoid problems
	// Do not call anything else that could use the g_pApp pointer.
	// It is not set yet here!
	m_pUserOptionsDialog     = 0;
	m_pServerOptionsDialog   = 0;
	m_pScriptCenter          = 0;
	m_pRegUsersDialog        = 0;
	m_pTipOfTheDayDialog     = 0;
	m_pGeneralOptionsDialog  = 0;
	m_pScriptWizard          = 0;
	m_pWMDockWidget          = 0;
	g_pSplashScreen          = 0;
	m_bGuiUpdatePending      = false;
	m_bGlobalRepaintPending  = false;
	m_savedAppPalette        = palette();
	m_szLastGUIStyle         = "default";
	g_display                = 0;
	g_pUserToolBarTemplate   = 0;
	// Create is as soon as possible...
	g_pThreadEventDispatcher = new KviThreadEventDispatcher();
}

//============================= setup ===============================//
//
// Here we initialize the whole engine
//

void KviApp::setup()
{
#ifdef COMPILE_USE_AA_FONTS
//#warning "FIXME: This should be not needed, check with newer Qt/X releases"
	setFont(QFont("helvetica",12)); // Force Qt to choose a decent font
#endif
	// Find the standard directories
	loadDirectories();
	// Now we can load the splash image...create the splash screen
	createSplashScreen();
	g_setSplashScreenProgress(0);
	g_setSplashScreenText(__tr("Loading icons..."));
	// Now we have a first widget out on the world
	// We can also initialize this variable now
	g_display = g_pSplashScreen->x11Display();
	// And consequently create this GC
	g_ircviewGC = XCreateGC(g_display,g_pSplashScreen->handle(),0,0);
	g_pIrcViewWidgetList = new QList<KviIrcView>;
	g_pIrcViewWidgetList->setAutoDelete(false);
	g_pIrcViewMemBuffer = new QPixmap(16,16); // just dummy 16x16 pixmap by now
	g_hIrcViewMemBuffer = g_pIrcViewMemBuffer->handle();
	// Load all our images
	loadPixmaps();                            // 0-13%
	// Create globals
	g_setSplashScreenText(__tr("Preparing to parse config files..."));
	// The KviPopups MUST be created before KviOptions (and destroyed after)
	g_pChannelPopup        = new KviPopupMenu(0,"channel_script_popup");
	g_pConsolePopup        = new KviPopupMenu(0,"console_script_popup");
	g_pUserlistPopup       = new KviPopupMenu(0,"userlist_script_popup");
	g_pNotifylistPopup     = new KviPopupMenu(0,"notifylist_script_popup");
	g_pQueryPopup          = new KviPopupMenu(0,"query_script_popup");
	g_pDccChatPopup        = new KviPopupMenu(0,"dccchat_script_popup");

	g_pUserToolBarTemplate = new KviUserToolBarTemplate();

	g_pVarCache            = new KviVariableCache();
	openUserConfig();
	g_pAliasManager        = new KviAliasManager();  // this MUST be created BEFORE the g_pOptions
	g_pEventManager        = new KviEventManager();  // Same as the above
	g_pRawEventManager     = new KviRawEventManager();

#ifdef COMPILE_PLUGIN_SUPPORT
	g_pPluginManager       = new KviPluginManager(); // this MUST be created AFTER g_pEventManager
#endif

#ifdef COMPILE_NEED_CHARSET_TRANSLATION
	g_pCharsetTranslator   = new KviCharsetTranslator();
#endif

	g_pOptions=new KviOptions();           //14-83%  // memory allocation and reading on disks eats really much time...
	// Set the fonts for the popups created before g_pOptions
	g_pChannelPopup->setFont(g_pOptions->m_fntApplication);
	g_pConsolePopup->setFont(g_pOptions->m_fntApplication);
	g_pUserlistPopup->setFont(g_pOptions->m_fntApplication);
	g_pNotifylistPopup->setFont(g_pOptions->m_fntApplication);
	g_pQueryPopup->setFont(g_pOptions->m_fntApplication);
	g_pDccChatPopup->setFont(g_pOptions->m_fntApplication);
	// Set the fonts for the rest of the widgets...
	setFont(g_pOptions->m_fntApplication); // Do not repaint widgets

	if(g_pOptions->m_bSetGlobalPaletteAtStartup){
		QColorGroup cg(
			g_pOptions->m_clrNormalGlobalForeground,
			g_pOptions->m_clrNormalGlobalButton,
			g_pOptions->m_clrNormalGlobalLight,
			g_pOptions->m_clrNormalGlobalDark,
			g_pOptions->m_clrNormalGlobalMid,
			g_pOptions->m_clrNormalGlobalText,
			g_pOptions->m_clrNormalGlobalText.light(150),
			g_pOptions->m_clrNormalGlobalBase,
			g_pOptions->m_clrNormalGlobalButton
		);
		QColorGroup cgdis(
			g_pOptions->m_clrDisabledGlobalForeground,
			g_pOptions->m_clrNormalGlobalButton,
			g_pOptions->m_clrNormalGlobalLight,
			g_pOptions->m_clrNormalGlobalDark,
			g_pOptions->m_clrNormalGlobalMid,
			g_pOptions->m_clrDisabledGlobalText,
			g_pOptions->m_clrNormalGlobalText.light(150),
			g_pOptions->m_clrDisabledGlobalBase,
			g_pOptions->m_clrNormalGlobalButton
		);
		QPalette pal(cg,cgdis,cg);	
		g_pChannelPopup->setPaletteRecursive(pal);
		g_pConsolePopup->setPaletteRecursive(pal);
		g_pUserlistPopup->setPaletteRecursive(pal);
		g_pNotifylistPopup->setPaletteRecursive(pal);
		g_pQueryPopup->setPaletteRecursive(pal);
		g_pDccChatPopup->setPaletteRecursive(pal);
		setPalette(pal); //Do not repaint widgets
	}

	g_pColorWindow     = new KviColorWindow();   //84-88%
	g_pInputPopup      = new QPopupMenu();
	g_pTaskBarPopup    = new QPopupMenu();
	g_pViewSelectPopup = new QPopupMenu();
	g_pWindowPopup     = new QPopupMenu();


	g_setSplashScreenProgress(88);
	g_setSplashScreenText(__tr("Booting the nuclear reactor..."));
	createQMLProvider();
	m_szLastHelpDocument = KVI_HELP_QML_MAIN_TOPIC_FILE;

	g_setSplashScreenProgress(90);

	KviFrame * frm = new KviFrame();       // 89 - 100 % Do not show yet...

	g_setSplashScreenProgress(100);
	g_setSplashScreenText(__tr("Go!"));

	destroySplashScreen();

	registerStyle("Motif",0,g_getMotifStyle);
	registerStyle("Motif Plus",0,g_getMotifPlusStyle);
	registerStyle("SGI",0,g_getSGIStyle);
	registerStyle("CDE",0,g_getCDEStyle);
	registerStyle("Windows",0,g_getWindowsStyle);
	registerStyle("Platinum",0,g_getPlatinumStyle);

	setApplicationStyle();
	// call it this way to ensure that the frame is inserted correctly
	__range_valid(frm == m_pFrameList->first());
	frm->show();

	if(g_pOptions->m_bEnableDockWidget)slot_createWMDockWidget();
	if(g_pOptions->m_bShowTipOfTheDayAtStartup)slot_doTipOfTheDay();
}

//============ ~KviApp ============//

KviApp::~KviApp()
{
	saveKVircDirectory();
	// Kill the dialogs if needed
	if(m_pUserOptionsDialog)delete m_pUserOptionsDialog;
	if(m_pServerOptionsDialog)delete m_pServerOptionsDialog;
	if(m_pScriptCenter)delete m_pScriptCenter;
	if(m_pRegUsersDialog)delete m_pRegUsersDialog;
	if(m_pTipOfTheDayDialog)delete m_pTipOfTheDayDialog;
	if(m_pScriptWizard)delete m_pScriptWizard;
	if(m_pWMDockWidget)delete m_pWMDockWidget;
	if(m_pGeneralOptionsDialog)delete m_pGeneralOptionsDialog;
	//There should be no remaining windows now in the list...
	__range_valid(m_pFrameList->isEmpty());
	delete m_pFrameList;
	m_pFrameList = 0;
	// no more frames = no more widgets = no more paint requests
	XFreeGC(g_display,g_ircviewGC);
	delete g_pIrcViewMemBuffer;
	__range_valid(g_pIrcViewWidgetList->isEmpty());
	delete g_pIrcViewWidgetList;

	emptyDestroyList();
	delete m_pDestroyList;
	// Kill globals

	delete g_pOptions;
	g_pOptions = 0;
	delete g_pUserConfig;
	delete g_pVarCache;
	delete g_pAliasManager; // this must be killed AFTER g_pOptions
#ifdef COMPILE_PLUGIN_SUPPORT
	// this must be killed BEFORE g_pEventManager (will unload all the plugins and unregister handles)
	// must be also killed AFTER g_pOptions
	setStyle(new QMotifStyle()); //hehe...QApplication dies if the style set is in a plugin :)
	delete g_pPluginManager;
#endif

#ifdef COMPILE_NEED_CHARSET_TRANSLATION
	delete g_pCharsetTranslator;
#endif

	delete g_pEventManager; // this must be killed AFTER g_pOptions
	delete g_pRawEventManager;
	delete g_pColorWindow;
	delete g_pInputPopup;
	delete g_pTaskBarPopup;
	delete g_pViewSelectPopup;
	delete g_pChannelPopup;
	delete g_pConsolePopup;
	delete g_pUserlistPopup;
	delete g_pNotifylistPopup;
	delete g_pQueryPopup;
	delete g_pDccChatPopup;
	delete g_pWindowPopup;
	delete g_pUserToolBarTemplate;
	destroyPixmaps();
	destroySplashScreen(); //make sure that it is destroyed
	// Delete is as late as possible...
	kvi_destroyLocale(this);
	delete g_pThreadEventDispatcher;
	unregisterStylesFor(0); // crash test :)
	delete m_pStyleList;
	delete m_pIconCache;
}

KviUserParser * KviApp::anyUserParser()
{
	KviFrame * f = m_pFrameList->first();
	return f ? f->m_pUserParser : 0;
}

bool KviApp::cacheIcon(const char *filename)
{
	if(m_pIconCache->find(filename))return true;
	QPixmap *pix = new QPixmap(filename);
	if(pix->isNull())
	{
		delete pix;
		debug("Could not load icon file %s",filename);
		return false;
	} else m_pIconCache->insert(filename,pix);
	return true;
}

void KviApp::refreshMimeTypeIcons()
{
	m_pIconCache->clear();
	for(KviMimeType * m = g_pOptions->m_pMimeManager->m_pMimeList->first();m;m = g_pOptions->m_pMimeManager->m_pMimeList->next())
	{
		m->iconPath.stripWhiteSpace();
		if(m->iconPath.hasData()){
			KviStr tmp;
			if(!findImage(tmp,m->iconPath.ptr()))m->iconPath = "";
			else {
				m->iconPath = tmp;
				if(!cacheIcon(m->iconPath.ptr()))m->iconPath = "";
			}
		}
	}
}

QPixmap * KviApp::getFileIcon(const char *filename)
{
	QPixmap * pix = m_pIconCache->find(filename);
	if(!pix){
		if(cacheIcon(filename))return m_pIconCache->find(filename);
	}
	return pix;
}

void KviApp::registerStyle(const char *name,void * plugin_handle,QStyle * (*style_provider_routine)())
{
	KviStyleEntry * e = new KviStyleEntry;
	e->name = name;
	e->plugin_handle = plugin_handle;
	e->get_style_object = style_provider_routine;
	m_pStyleList->append(e);
	/* FIXME : Need to update the dialog if it is there ? */
//	if(m_pGuiOptionsDialog){
//		delete m_pGuiOptionsDialog; // need to refresh it
//		m_pGuiOptionsDialog = 0;
//	}
}

void KviApp::unregisterStyle(const char *name,void * plugin_handle)
{
	KviStyleEntry * e = 0;
	for(e=m_pStyleList->first();e;e=m_pStyleList->next()){
		if(kvi_strEqualCI(e->name.ptr(),name)){
			if(plugin_handle == e->plugin_handle){
				if(g_pOptions){ // options may be zero when closing down the app
					// not closing down :)
					if(kvi_strEqualCI(e->name.ptr(),g_pOptions->m_szApplicationGUIStyle.ptr())){
						// This is the current style....mmmmh
						// The object code may be not available anymore ...
						g_pOptions->m_szApplicationGUIStyle = "default";
						setApplicationStyle();
					}
				} // else g_pOptions already deleted :)
				m_pStyleList->removeRef(e);
				return;
			}
		}
	}
	/* FIXME : Need to update the dialog if it is there ? */
//	if(m_pGuiOptionsDialog){
//		delete m_pGuiOptionsDialog; // need to refresh it
//		m_pGuiOptionsDialog = 0;
//	}
}

void KviApp::unregisterStylesFor(void * plugin_handle)
{
	QList<KviStyleEntry> l;
	l.setAutoDelete(false);
	KviStyleEntry * e = 0;
	for(e=m_pStyleList->first();e;e=m_pStyleList->next()){
		if(plugin_handle == e->plugin_handle)l.append(e);
	}
	while(l.first()){
		unregisterStyle(l.first()->name.ptr(),plugin_handle);
		l.removeFirst();
	}
	/* FIXME : Need to update the dialog if it is there ? */
//	if(m_pGuiOptionsDialog){
//		delete m_pGuiOptionsDialog; // need to refresh it
//		m_pGuiOptionsDialog = 0;
//	}
}

void KviApp::slot_safeQuit()
{
	// Do a safe quit...
	// Each frame is self-deleted in the close event
	// and removes itself from m_pFrameList in the destructor.
	while(!m_pFrameList->isEmpty())m_pFrameList->first()->close();
	// When the last frame is closed , the app should exit automatically...
}

void KviApp::destroyLater(QObject * o)
{
	m_pDestroyList->append(o);
	QTimer::singleShot(100,this,SLOT(emptyDestroyList()));
}

void KviApp::emptyDestroyList()
{
//	__enter("emptyDestroyList");
	while(!m_pDestroyList->isEmpty())m_pDestroyList->removeFirst();
}



void KviApp::connectAfterStartup(const char * server,const char * port)
{
	__range_valid(m_pFrameList->first()); // we must be called after setup()
	g_pOptions->m_pServerManager->iWantThisServerToBeCurrent(server ? server : "irc.openprojects.net",port ? port : "6667");
	// Jump out of this handler , call it from the main event loop...
	m_pFrameList->first()->doAsyncServerCommandCall(); //will run in exec() loop
}

void KviApp::setApplicationStyle()
{
	if(kvi_strEqualCI(m_szLastGUIStyle.ptr(),g_pOptions->m_szApplicationGUIStyle.ptr()))return;

	QStyle * s = 0;

	if(kvi_strEqualCI(g_pOptions->m_szApplicationGUIStyle.ptr(),"default"))
	{
		// Default (NONE) style
#ifdef COMPILE_WITH_KDE
		s = kstyle(); // get the default KDE style
#else
		s = new QMotifStyle(); // Qt default
#endif
	} else {
		// Lookup in the  registered styles table
		for(KviStyleEntry * e=m_pStyleList->first();e;e=m_pStyleList->next()){
			if(kvi_strEqualCI(g_pOptions->m_szApplicationGUIStyle.ptr(),e->name.ptr())){
				// got the style 
				s = e->get_style_object();
			}
		}
	}

	if(!s){
		// For some reason (KDE ?) we got a null style...
		// Fail to the Qt default
		g_pOptions->m_szApplicationGUIStyle = "default";
		s = new QMotifStyle();
	}
	
	m_szLastGUIStyle = g_pOptions->m_szApplicationGUIStyle;
	
	setStyle(s);
}

//=========== createSplashScreen ============//

void KviApp::createSplashScreen()
{

	KviStr szImage;
	g_pSplashScreen = 0;
	if(findImage(szImage,KVI_SPLASH_IMAGE_NAME)){
		QPixmap pix(szImage.ptr());
		if(!pix.isNull()){
			g_pSplashScreen = new KviSplashScreen(pix);
		}
	}
	if(!g_pSplashScreen){
		debug("Could not load the splash screen image %s",szImage.ptr());
		g_pSplashScreen = new KviSplashScreen(); //no splash image?
	}
	g_pSplashScreen->show();
}

//=========== destroySplashScreen ============//

void KviApp::destroySplashScreen()
{
	if(g_pSplashScreen)delete g_pSplashScreen;
	g_pSplashScreen = 0;
}

//=============================================================================
//
// ### Load settings and create globals ###
//
//=============================================================================

void KviApp::createQMLProvider()
{
//	KviHelpQMLProvider * p = new KviHelpQMLProvider();
//	KviStr szProviderSearchPath;

//	getGlobalKVircDirectory(szProviderSearchPath,Help,0);
//	p->addFilePath(szProviderSearchPath.ptr());
//
//	QMimeSourceFactory::setDefaultFactory(p);
//

	// Set the default help files search path
	QStringList list;
	KviStr tmp;
	getLocalKVircDirectory(tmp,Help);
	list.append(tmp.ptr());
	getGlobalKVircDirectory(tmp,Help);
	list.append(tmp.ptr());
	getGlobalKVircDirectory(tmp,HelpEN);
	list.append(tmp.ptr());
	QMimeSourceFactory::defaultFactory()->setFilePath(list);
	QMimeSourceFactory::defaultFactory()->setExtensionType("kvihelp","text/html");

	KviHelpQMLStyleSheet * s = new KviHelpQMLStyleSheet(this);
	QStyleSheet::setDefaultSheet(s);
}

void KviApp::loadPixmaps()
{
	// This function should set progress from 0 to 21 %
	KviStr szP1;
	KviStr szP2;
	g_setSplashScreenProgress(1);

	//Fist toolBar icon (three state pixmap)
	getLocalKVircDirectory(szP1,Pics,KVI_CONNECT_STATE_IMAGE_LIBRARY_NAME);
	getGlobalKVircDirectory(szP2,Pics,KVI_CONNECT_STATE_IMAGE_LIBRARY_NAME);
	KviImageLibrary lib1(szP1.ptr(),szP2.ptr(),32,32);
	g_setSplashScreenProgress(2);
	if(!lib1.libraryLoaded())warningBox(__tr("The image library %s can not be found."),KVI_CONNECT_STATE_IMAGE_LIBRARY_NAME);
	g_pReadyStatePixmap = new QPixmap(lib1.getImage(0));
	g_pBusyStatePixmap  = new QPixmap(lib1.getImage(1));
	g_pConnectedStatePixmap = new QPixmap(lib1.getImage(2));

	//List box : two images
	getLocalKVircDirectory(szP1,Pics,KVI_LISTBOX_IMAGE_LIBRARY_NAME);
	getGlobalKVircDirectory(szP2,Pics,KVI_LISTBOX_IMAGE_LIBRARY_NAME);
	KviImageLibrary lib2(szP1.ptr(),szP2.ptr(),16,16);
	g_setSplashScreenProgress(3);
	if(!lib2.libraryLoaded())warningBox(__tr("The image library %s can not be found."),KVI_LISTBOX_IMAGE_LIBRARY_NAME);
	g_pListBoxOpPixmap = new QPixmap(lib2.getImage(0));
	g_pListBoxVoicePixmap  = new QPixmap(lib2.getImage(1));
	g_pListBoxHelpOpPixmap  = new QPixmap(lib2.getImage(2));
	g_pListBoxUserOpPixmap  = new QPixmap(lib2.getImage(3));
	g_pListBoxOwnerPixmap  = new QPixmap(lib2.getImage(4));

	//Small image (view icons) library...16x16
	getLocalKVircDirectory(szP1,Pics,KVI_OUT_ICONS_IMAGE_LIBRARY_NAME);
	getGlobalKVircDirectory(szP2,Pics,KVI_OUT_ICONS_IMAGE_LIBRARY_NAME);
	KviImageLibrary lib3(szP1.ptr(),szP2.ptr(),16,16);
	g_setSplashScreenProgress(4);
	if(!lib3.libraryLoaded())warningBox(__tr("The image library %s can not be found."),KVI_OUT_ICONS_IMAGE_LIBRARY_NAME);
	for(int i=0;i<KVI_OUT_NUM_IMAGES;i++)g_pixViewOut[i]=new QPixmap(lib3.getImage(i));
	g_setSplashScreenProgress(5);

	// Systray icons
	getLocalKVircDirectory(szP1,Pics,KVI_SYSTRAY_ICONS_IMAGE_LIBRARY_NAME);
	getGlobalKVircDirectory(szP2,Pics,KVI_SYSTRAY_ICONS_IMAGE_LIBRARY_NAME);
	KviImageLibrary lib4(szP1.ptr(),szP2.ptr(),32,32);
	g_setSplashScreenProgress(6);
	if(!lib4.libraryLoaded())warningBox(__tr("The image library %s can not be found."),KVI_SYSTRAY_ICONS_IMAGE_LIBRARY_NAME);
	for(int i=0;i<4;i++)g_pSysTrayBigIcons[i]=new QPixmap(lib4.getImage(i));
	g_setSplashScreenProgress(7);

	// File icons
	getLocalKVircDirectory(szP1,Pics,KVI_FILE_ICONS_IMAGE_LIBRARY_NAME);
	getGlobalKVircDirectory(szP2,Pics,KVI_FILE_ICONS_IMAGE_LIBRARY_NAME);
	KviImageLibrary lib5(szP1.ptr(),szP2.ptr(),32,32);
	g_setSplashScreenProgress(8);
	if(!lib5.libraryLoaded())warningBox(__tr("The image library %s can not be found."),KVI_FILE_ICONS_IMAGE_LIBRARY_NAME);
	for(int i=0;i<KVI_FILE_ICONS_NUM_IMAGES;i++)g_pFileIcons[i]=new QPixmap(lib5.getImage(i));
	g_setSplashScreenProgress(9);

	// Browser icons
	getLocalKVircDirectory(szP1,Pics,KVI_BROWSER_ICONS_IMAGE_LIBRARY_NAME);
	getGlobalKVircDirectory(szP2,Pics,KVI_BROWSER_ICONS_IMAGE_LIBRARY_NAME);
	KviImageLibrary lib6(szP1.ptr(),szP2.ptr(),32,32);
	g_setSplashScreenProgress(10);
	if(!lib6.libraryLoaded())warningBox(__tr("The image library %s can not be found."),KVI_BROWSER_ICONS_IMAGE_LIBRARY_NAME);
	for(int i=0;i<KVI_BROWSER_ICONS_NUM_IMAGES;i++)g_pBrowserIcons[i]=new QPixmap(lib6.getImage(i));
	g_setSplashScreenProgress(11);

	// Help icons
	getLocalKVircDirectory(szP1,Pics,KVI_HELP_ICONS_IMAGE_LIBRARY_NAME);
	getGlobalKVircDirectory(szP2,Pics,KVI_HELP_ICONS_IMAGE_LIBRARY_NAME);
	KviImageLibrary lib7(szP1.ptr(),szP2.ptr(),32,32);
	g_setSplashScreenProgress(12);
	if(!lib7.libraryLoaded())warningBox(__tr("The image library %s can not be found."),KVI_HELP_ICONS_IMAGE_LIBRARY_NAME);
	for(int i=0;i<KVI_HELP_ICONS_NUM_IMAGES;i++)g_pHelpIcons[i]=new QPixmap(lib7.getImage(i));
	g_setSplashScreenProgress(13);
}

//=============================================================================
//
// ### Save settings ###
//
//=============================================================================

void KviApp::saveKVircDirectory()
{
	// Here we save the local directory path
#ifdef COMPILE_WITH_KDE
	// In KDE we use the application config file
	if(!m_pConfigFile){	// not if user supplied a config file
		KConfig * cfg = config();
		if(cfg)
		{
			if(cfg->getConfigState() == KConfig::ReadWrite)
			{
				cfg->setGroup("LocalKVirc211Directory");
				cfg->writeEntry("LocalKVirc211Directory",m_szLocalKVircDir.ptr());
				cfg->sync();
// Writes both kdehome and standard rc?
//				return;
			}
		}
	}
#endif
	// In NON-KDE we use $HOME/.kvirc-VERSION.rc
	KviStr szF(QDir::homeDirPath());
	if(m_pConfigFile)
		if(*m_pConfigFile != '/') {//assume $HOME/ if not absolute
			szF.append(KviStr::Format,"/%s",m_pConfigFile);
		} else szF=m_pConfigFile;
	else szF.append(KviStr::Format,"/%s",KVI_HOME_CONFIG_FILE_NAME);

	QFile f(szF.ptr());
	if(f.open(IO_WriteOnly|IO_Truncate)){
		QTextStream t(&f);
		t << m_szLocalKVircDir.ptr();
		f.close();
		__debug_1arg("KVIrc local directory saved to %s",szF.ptr());
	} else {
		warningBox(__tr("Failed writing the kvirc home directory path to %s.\n"\
			"You will need to do it manually , otherwise KVirc will restart with\n"\
			"the setup!"),szF.ptr());
	}
}

//=============================================================================
//
// ### Main frames handling ###
//
//=============================================================================

void KviApp::createNewFrame()
{
	//Creates a new toplevel window.
	KviFrame *pFrm=new KviFrame();
	pFrm->show();
}

void KviApp::insertNewFrame(KviFrame *frm)
{
	//KviFrame calls this in the constructor.
	m_pFrameList->append(frm);
}

void KviApp::removeFrame(KviFrame *frm)
{
	//KviFrame calls this in the destructor.
	m_pFrameList->removeRef(frm);
	//If the last window has been closed , die :)
	if(m_pFrameList->isEmpty())quit();
}

//=============================================================================
//
// ### Application exits : destroy global stuff ###
//
//=============================================================================

void KviApp::destroyPixmaps()
{
//	for(int i=0;i<KVI_WND_NUM_ICONS;i++)delete g_pWindowIcon[i];
	for(int j=0;j<KVI_OUT_NUM_IMAGES;j++)delete g_pixViewOut[j];
	for(int k=0;k<4;k++)delete g_pSysTrayBigIcons[k];
	for(int l=0;l<KVI_FILE_ICONS_NUM_IMAGES;l++)delete g_pFileIcons[l];
	for(int m=0;m<KVI_BROWSER_ICONS_NUM_IMAGES;m++)delete g_pBrowserIcons[m];
	for(int n=0;n<KVI_HELP_ICONS_NUM_IMAGES;n++)delete g_pHelpIcons[n];
	delete g_pReadyStatePixmap;
	delete g_pBusyStatePixmap;
	delete g_pConnectedStatePixmap;
	delete g_pListBoxOpPixmap;
	delete g_pListBoxVoicePixmap;
	delete g_pListBoxHelpOpPixmap;
	delete g_pListBoxUserOpPixmap;
	delete g_pListBoxOwnerPixmap;
}

//=============================================================================
//
// ### Global utilities ###
//
//=============================================================================

//=============== warningBox ===============//

void KviApp::warningBox(const char *fmt,...)
{
	//realloc 256 bytes
	char *buf=(char *)kvi_malloc(256);
	va_list list;
	va_start(list,fmt);
	//print...with max 256 chars
	int len=kvi_vsnprintf(buf,256,fmt,list);
	va_end(list);
	//check if we failed
	if(len < 0){
		//yes , failed....
		int ilen=256;
		do{ //we failed , so retry with 256 more chars
			ilen+=256;
			//realloc
			buf=(char *)kvi_realloc(buf,ilen);	
			//print...
			va_start(list,fmt);
			len=kvi_vsnprintf(buf,ilen,fmt,list);
			va_end(list);
		} while(len < 0);
	}
	//done...
	//now m_len is the length of the written string not including the terminator...
	//perfect! :)
	buf=(char *)kvi_realloc(buf,len+1);
	kvi_warningBox(_CHAR_2_QSTRING(__tr("KVIrc : WARNING")),buf);
	kvi_free(buf);
}


void KviApp::openUserConfig()
{
	KviStr tmp;
	getLocalKVircDirectory(tmp,Config,"kvi.userconfig.conf");
	g_pUserConfig = new KviConfig(tmp.ptr());
}

#ifdef COMPILE_PLUGIN_SUPPORT
	void KviApp::getPluginConfigFilePath(KviStr &buffer,const char *plugin_name)
	{
		KviStr fName(KviStr::Format,"kvi.%s.conf",plugin_name);
		getLocalKVircDirectory(buffer,ConfigPlugins,fName.ptr());
	}

	bool KviApp::getReadOnlyPluginConfigFilePath(KviStr &buffer,const char *plugin_name)
	{
		KviStr fName(KviStr::Format,"kvi.%s.conf",plugin_name);
		// Take a look in the local directory....
		getLocalKVircDirectory(buffer,ConfigPlugins,fName.ptr());
		if(!kvi_fileExists(buffer.ptr())){
			// No saved config yet... check for defaults
			KviStr tmp;
			getGlobalKVircDirectory(tmp,ConfigPlugins,fName.ptr());
			if(!kvi_fileExists(tmp.ptr())){
				// No defaults...no such config file at all.
				return false;
			} else buffer = tmp; // get the defaults this time
		} // else file exists...
		return true;
	}
#endif



void KviApp::raiseTopLevelWidget(QWidget * ptr)
{
	if(ptr->hasFocus())return;
	if(ptr->isActiveWindow())return;
	if(g_pOptions->m_bDialogShowHackForBrainDamagedWM)ptr->hide(); //enlightenment works fine with raise , but does not like hide()
	processEvents();
	ptr->show();
	processEvents();
	ptr->raise();
	processEvents();
	ptr->setActiveWindow();
	processEvents();
	ptr->setFocus();
}

void KviApp::executeFileWithCommand(const char *commandline,const char *filePath,KviFrame * callerFrame,bool bRemoteExec)
{
	if(!callerFrame)callerFrame = m_pFrameList->first();
	__range_valid(callerFrame);
	KviStr cmd = commandline;
	cmd.stripWhiteSpace();
	if(cmd.isEmpty())return;
	callerFrame->m_pUserParser->m_szLastExecFilename = filePath;
	callerFrame->m_pUserParser->m_bLastIsRemoteExec = bRemoteExec;
	callerFrame->m_pUserParser->parseCommand(cmd.ptr(),callerFrame->m_pConsole);
}


//=============================================================================
//
// ### Option dialogs ###
//
//=============================================================================

void KviApp::slot_doUserOptionsDialog()
{
	if(m_pUserOptionsDialog)raiseTopLevelWidget(m_pUserOptionsDialog);
	else {
		m_pUserOptionsDialog = new KviDlgOptUser(0);
		connect(m_pUserOptionsDialog,SIGNAL(finished(bool)),this,SLOT(slot_userOptionsDialogFinished(bool)));
		m_pUserOptionsDialog->show();
	}
}

void KviApp::slot_userOptionsDialogFinished(bool bAccepted)
{
	__range_valid(m_pUserOptionsDialog);
	delete m_pUserOptionsDialog;
	m_pUserOptionsDialog = 0;
}

void KviApp::slot_doServerOptionsDialog()
{
	if(m_pServerOptionsDialog)raiseTopLevelWidget(m_pServerOptionsDialog);
	else {
		m_pServerOptionsDialog = new KviDlgOptServer(0);
		connect(m_pServerOptionsDialog,SIGNAL(finished(bool)),this,SLOT(slot_serverOptionsDialogFinished(bool)));
		m_pServerOptionsDialog->show();
	}
}

void KviApp::slot_serverOptionsDialogFinished(bool bAccepted)
{
	__range_valid(m_pServerOptionsDialog);
	delete m_pServerOptionsDialog;
	m_pServerOptionsDialog = 0;
}

void KviApp::showScriptCenter(KviFrame * par)
{
	if(g_pOptions->m_bScriptCenterShowAsDialog)
	{
		if(m_pScriptCenter){
			if(m_pScriptCenter->parent())m_pScriptCenter->reparent(0,QPoint(0,0),true);
		} else {
			m_pScriptCenter = new KviScriptCenter(0);
			connect(m_pScriptCenter,SIGNAL(closed()),this,SLOT(slot_scriptDialogFinished()));
			m_pScriptCenter->show();
		}
	} else {
		if(!par)return;
		if(m_pScriptCenter)
		{
			if(m_pScriptCenter->parent() != par->m_pSplitter)m_pScriptCenter->reparent(par->m_pSplitter,QPoint(0,0),true);
		} else {
			m_pScriptCenter = new KviScriptCenter(par->m_pSplitter);
			connect(m_pScriptCenter,SIGNAL(closed()),this,SLOT(slot_scriptDialogFinished()));
			m_pScriptCenter->show();
		}
	}
}

void KviApp::slot_scriptDialogFinished()
{
//#warning "SLOT_SCRIPT DIALOG FINISHED :  the bool arg has no meaning , also this function should be called from the destructor of the dialog"
	m_pScriptCenter = 0;
}

void KviApp::requestHelpOn(const char *topic)
{
	KviFrame * frm = m_pFrameList->first();
	if(frm)frm->requestHelpOn(topic);
}

void KviApp::slot_whatIsThisRequest()
{
	KviFrame * frm = m_pFrameList->first();
	if(frm)frm->slot_whatIsThisRequest();
}

void KviApp::slot_generalOptionsDialog()
{
	if(m_pGeneralOptionsDialog)raiseTopLevelWidget(m_pGeneralOptionsDialog);
	else {
		m_pGeneralOptionsDialog = new KviGeneralOptionsDialog(0);
		connect(m_pGeneralOptionsDialog,SIGNAL(finished(bool)),this,SLOT(slot_generalOptionsDialogFinished(bool)));
		m_pGeneralOptionsDialog->show();
	}
}

void KviApp::slot_generalOptionsDialogFinished(bool bCommitChanges)
{
	delete m_pGeneralOptionsDialog;
	m_pGeneralOptionsDialog = 0;
}

void KviApp::updateAllFrameCaptions()
{
	for(KviFrame *f = m_pFrameList->first();f;f= m_pFrameList->next())f->updateCaption();
}

void KviApp::updateAllDirectoryBrowsers()
{
	for(KviFrame *frm = m_pFrameList->first();frm;frm = m_pFrameList->next())
	{
		if(frm->m_pDirBrowser)
		{
			if(frm->m_pDirBrowser->isVisible())frm->m_pDirBrowser->applyOptions();
		}
	}
}

void KviApp::triggerGlobalRepaint()
{
	if(!m_bGlobalRepaintPending)
	{
		m_bGlobalRepaintPending = true;
		QTimer::singleShot(50,this,SLOT(globalRepaint()));
	}
}

void KviApp::globalRepaint()
{
	m_bGlobalRepaintPending = false;
	for(KviFrame *f = m_pFrameList->first();f;f= m_pFrameList->next()){
		f->applyOptions();
		f->applyToolbarOptions();
	}
}

void KviApp::slot_doRegUsersDialog()
{
	if(m_pRegUsersDialog)raiseTopLevelWidget(m_pRegUsersDialog);
	else {
		m_pRegUsersDialog = new KviDlgRegUsers(0);
		connect(m_pRegUsersDialog,SIGNAL(finished(bool)),this,SLOT(slot_regUsersDialogFinished(bool)));
		m_pRegUsersDialog->show();
	}
}

void KviApp::slot_regUsersDialogFinished(bool bAccepted)
{
	__range_valid(m_pRegUsersDialog);
	delete m_pRegUsersDialog;
	m_pRegUsersDialog = 0;
	restartNotifyLists();
}

void KviApp::slot_doScriptWizard()
{
	if(m_pScriptWizard)raiseTopLevelWidget(m_pScriptWizard);
	else {
		m_pScriptWizard = new KviScriptWizard();
		connect(m_pScriptWizard,SIGNAL(finished(bool)),this,SLOT(slot_scriptWizardFinished(bool)));
		m_pScriptWizard->show();
	}
}

void KviApp::slot_scriptWizardFinished(bool bAccepted)
{
	__range_valid(m_pScriptWizard);
	KviSaveScriptStruct s;
	s.pWnd = m_pFrameList->first()->activeWindow();
	if(bAccepted)m_pScriptWizard->fillSaveScriptStruct(&s);
	delete m_pScriptWizard;
	m_pScriptWizard = 0;
	if(bAccepted){
		if(saveScript(&s))s.pWnd->output(KVI_OUT_INTERNAL,__tr("Script successfully saved"));
		else s.pWnd->output(KVI_OUT_ERROR,__tr("Failed to save the script"));
		if(s.pExtraFilesList)delete s.pExtraFilesList;
	}
}

void KviApp::restartNotifyLists()
{
	for(KviFrame *f = m_pFrameList->first();f;f= m_pFrameList->next()){
		f->updateNotifyOrWatchList();
	}
}

void KviApp::slot_doTipOfTheDay()
{
	if(!m_pTipOfTheDayDialog)
	{
		m_pTipOfTheDayDialog = new KviTipOfTheDay();
		m_pTipOfTheDayDialog->show();
		connect(m_pTipOfTheDayDialog,SIGNAL(closed()),this,SLOT(slot_TipOfTheDayClosed()));
	} else {
		m_pTipOfTheDayDialog->raise();
		m_pTipOfTheDayDialog->setFocus();
		m_pTipOfTheDayDialog->hide();
		m_pTipOfTheDayDialog->show();
	}
}

void KviApp::slot_TipOfTheDayClosed()
{
	delete m_pTipOfTheDayDialog;
	m_pTipOfTheDayDialog = 0;
}

void KviApp::slot_doAboutDialog()
{
	KviFrame * frm = m_pFrameList->first();
	frm->m_pUserParser->parseCommand("if(!$pluginLoaded(about))plugin -q -u load about; aboutkvirc",frm->m_pConsole);
}


void KviApp::slot_doLoadScriptDialog()
{
	if(!m_pLoadScriptDialog){
		m_pLoadScriptDialog = new KviDlgLoadScript(0);
		m_pLoadScriptDialog->show();
		connect(m_pLoadScriptDialog,SIGNAL(finished(bool)),this,SLOT(slot_loadScriptDialogFinished(bool)));
	} else {
		raiseTopLevelWidget(m_pLoadScriptDialog);
	}
}

void KviApp::slot_loadScriptDialogFinished(bool bAccepted)
{
	if(bAccepted)
	{
		KviFrame * f = m_pFrameList->first();
		KviStr scriptName;
		bool bRemoveAliases;
		bool bRemovePopups;
		bool bRemoveEvents;
		m_pLoadScriptDialog->getSelectedScriptFileName(scriptName,bRemoveAliases,bRemovePopups,bRemoveEvents);
		if(scriptName.hasData())
		{
			if(bRemoveAliases)g_pAliasManager->clearAll();
			if(bRemovePopups)
			{
				g_pChannelPopup->clearAll();
				g_pConsolePopup->clearAll();
				g_pUserlistPopup->clearAll();
				g_pNotifylistPopup->clearAll();
				g_pQueryPopup->clearAll();
				g_pDccChatPopup->clearAll();
			}
			if(bRemoveEvents)
			{
				g_pEventManager->cleanup();
				g_pRawEventManager->cleanup();
			}

			KviStr tmp(KviStr::Format,"PARSE \"%s\"",scriptName.ptr());
			f->m_pUserParser->parseCommand(tmp.ptr(),f->m_pConsole);
			g_pOptions->save(); // save options
		}
	}
	delete m_pLoadScriptDialog;
	m_pLoadScriptDialog = 0;
}

///////////////////////////////////////////////////////

void KviApp::slot_saveSettings()
{
	g_pOptions->save();
}

///////////////////////////////////////////////////////

void KviApp::adjustPopupMenusForWMDockWidget()
{
	for(KviFrame * f = m_pFrameList->first();f;f = m_pFrameList->next()){
		f->m_pMenuBar->wmDockWidgetStateChanged(m_pWMDockWidget != 0);
	}
}

void KviApp::wmDockWidgetDestroyed()
{
	if(m_pWMDockWidget){
		m_pWMDockWidget = 0;
		showAllFrames();
		adjustPopupMenusForWMDockWidget();
	}
}

void KviApp::slot_createWMDockWidget()
{
	if(!m_pWMDockWidget)m_pWMDockWidget = new KviWMDockWidget();
	adjustPopupMenusForWMDockWidget();
}

void KviApp::slot_destroyWMDockWidget()
{
	if(m_pWMDockWidget)delete m_pWMDockWidget;
	m_pWMDockWidget = 0;
	adjustPopupMenusForWMDockWidget();
}

void KviApp::globalHighlight(bool bAltColor)
{
#ifdef COMPILE_NEED_KDE
	if(m_pWMDockWidget){
		if(!m_pWMDockWidget->framesVisible()){
			m_pWMDockWidget->highlight(bAltColor);
		}
	}
#endif
}

void KviApp::hideAllFrames()
{
	for(KviFrame * f=m_pFrameList->first();f;f=m_pFrameList->next())f->hide();

#ifdef COMPILE_NEED_KDE
	if(m_pWMDockWidget)m_pWMDockWidget->setFramesVisible(false);
#endif
}

void KviApp::showAllFrames()
{
	// This does not work with enlightenment :)
	for(KviFrame * f=m_pFrameList->first();f;f=m_pFrameList->next()){
		if(g_pOptions->m_bDialogShowHackForBrainDamagedWM)
		{
			f->hide(); //enlightenment works fine with raise, but does not like hide()
			processEvents();
		}
		f->showNormal();
		f->show();
		f->raise();
	}
#ifdef COMPILE_NEED_KDE
	if(m_pWMDockWidget)
		m_pWMDockWidget->setFramesVisible(true);
#endif
}

void KviApp::toggleFrame(int id)
{
	if(id<0)return;
	__range_valid(((uint)id) < m_pFrameList->count());
	KviFrame *f=m_pFrameList->at(id);
	if(!f)return;
	if(f->isHidden()){
		if(g_pOptions->m_bDialogShowHackForBrainDamagedWM){
			f->hide(); //blah enlightenment
			processEvents();
		}
		f->showNormal();
		f->show();
		f->raise();
	} else f->hide();
//	if(pFrm==g_pApp->m_pFrameList->last())return;
}

#ifdef COMPILE_NEED_KDE
	KviAppBaseClass::KviAppBaseClass(int argc,char ** argv,const char *appname)
	:KApplication(argc,argv,appname){}
	#include "m_kvi_appbase_kde.moc"
#else
	KviAppBaseClass::KviAppBaseClass(int argc,char ** argv,const char *)
	:QApplication(argc,argv){}
	#include "m_kvi_appbase_qt.moc"
#endif

KviAppBaseClass::~KviAppBaseClass(){}

#include "m_kvi_app.moc"
