#ifndef _KVI_OPAQUELABEL_H_INCLUDED_
#define _KVI_OPAQUELABEL_H_INCLUDED_

//
//   File : kvi_opaquelabel.h
//   Last major modification : Thu Jan 23 2000 19:15:12 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include "kvi_string.h"

#include <qwidget.h>
#include <qlabel.h>
#include <qbitmap.h>
#include <qtoolbutton.h>

//
//   A non themeable label
//

class KviOpaqueLabel : public QLabel
{
	Q_OBJECT
public:
	KviOpaqueLabel(QWidget *parent,const char *name = 0);
	KviOpaqueLabel(const QString &text,QWidget *parent,const char *name = 0);
	~KviOpaqueLabel();
public:
	virtual void setMask(const QBitmap &);
	virtual void setMask(const QRegion &);
	virtual void setAutoMask(bool);
};


class KviChanLabel : public QWidget
{
	Q_OBJECT
public:
	KviChanLabel(const char * text,QWidget *parent,const char *name = 0);
	~KviChanLabel();
protected:
	bool m_bCanEdit;
	KviStr m_szText;
	int m_iFirstVisibleChar;
	QColor m_textColor;
	QColor m_backColor;
	QPixmap * m_pPixPointer;
	QToolButton * m_bLeft;
	QToolButton * m_bRight;
public:
	virtual QSize sizeHint();
	inline const char * text(){ return m_szText.ptr(); };
	const char * strippedText();
	void setText(const char * text);
	void setTextColor(QColor &clr);
	void setBackColor(QColor &clr);
	void setBackgroundPixmapPointer(QPixmap * p);
public slots:
	void scrollLeft();
	void scrollRight();
protected:
	virtual void paintEvent(QPaintEvent *e);
	virtual void mouseDoubleClickEvent(QMouseEvent *);
	virtual void mouseReleaseEvent(QMouseEvent *);
	virtual void mousePressEvent(QMouseEvent *e);
signals:
	void doubleClicked();
	void rightClicked();
};


//typedef KviOpaqueLabel KviChanLabel;


#endif //!_KVI_OPAQUELABEL_H_INCLUDED_
