#ifndef _KVI_MIME_H_INCLUDED_
#define _KVI_MIME_H_INCLUDED_

//
//   File : kvi_mime.h (/usr/build/NEW_kvirc/kvirc/src/kvilib/kvi_mime.h)
//   Last major modification : Mon May 10 1999 17:32:28 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include <qlist.h>

#include "kvi_string.h"

class KviConfig;

typedef struct KviMimeType
{
	KviStr fileMask;
	KviStr magicBytes;
	KviStr mimeName;
	KviStr commandline;
	KviStr savePath;
	bool   remoteExecSafe;
	KviStr iconPath;
};

class KviMimeManager
{
public:
	KviMimeManager();
	~KviMimeManager();
public:
	KviMimeType * m_pDefault;
	QList<KviMimeType> * m_pMimeList;	
public:
	void save(KviConfig * cfg);
	void load(KviConfig * cfg);
	KviMimeType * findMatch(const char *fileName,bool bDoMagicCheck = true);
	void inSort(KviMimeType * m);
	bool checkMagicMatch(KviStr &magic,const char *fileName);
};

#endif //!_KVI_MIME_H_INCLUDED_
