//
//   File : kvi_jpegio.cpp (/usr/build/NEW_kvirc/kvirc/src/kvilib/kvi_jpegio.cpp)
//   Last major modification : Sun May 9 1999 05:20:49 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include "kvi_settings.h"

#ifdef COMPILE_JPEG_SUPPORT

#include <stdio.h> // jpeglib needs this to be pre-included
#include <setjmp.h>

extern "C" {
	#define XMD_H // Shut JPEGlib up.
		#include <jpeglib.h>
		#ifdef const
		#undef const // Remove crazy C hackery in jconfig.h
	#endif
}

#include <qimage.h>
#include <qiodevice.h>


struct KviJpegErrorManager : public jpeg_error_mgr
{
	jmp_buf setjmp_buffer;
};

static void kvi_jpegErrorExit (j_common_ptr cinfo)
{
    KviJpegErrorManager * pErrMng = (KviJpegErrorManager*) cinfo->err;
    char buffer[JMSG_LENGTH_MAX];
    (*cinfo->err->format_message)(cinfo, buffer);
    warning(buffer);
    longjmp(pErrMng->setjmp_buffer,1);
}


struct KviJpegSourceManager : public jpeg_source_mgr {
	QImageIO* m_iio;
	JOCTET m_buffer[4096];

public:

	KviJpegSourceManager(QImageIO* iio)
	{
		jpeg_source_mgr::init_source       = init_source;
		jpeg_source_mgr::fill_input_buffer = fill_input_buffer;
		jpeg_source_mgr::skip_input_data   = skip_input_data;
		jpeg_source_mgr::resync_to_restart = jpeg_resync_to_restart;
		jpeg_source_mgr::term_source       = term_source;
		m_iio                              = iio;
		bytes_in_buffer                    = 0;
		next_input_byte                    = m_buffer;
	}

	static void init_source(j_decompress_ptr)
	{
	}

	static boolean fill_input_buffer(j_decompress_ptr cinfo)
	{
		KviJpegSourceManager* src = (KviJpegSourceManager*)cinfo->src;
		src->next_input_byte = src->m_buffer;
		int iRead = src->m_iio->ioDevice()->readBlock((char*)src->m_buffer,4096);
		if(iRead <= 0){
			// Insert a fake EOI marker - as per jpeglib recommendation
			src->m_buffer[0] = (JOCTET) 0xFF;
			src->m_buffer[1] = (JOCTET) JPEG_EOI;
			src->bytes_in_buffer = 2;
		} else src->bytes_in_buffer = iRead;
		return true;
    }

    static void skip_input_data(j_decompress_ptr cinfo, long num_bytes)
    {
		KviJpegSourceManager* src = (KviJpegSourceManager*)cinfo->src;
		if(num_bytes > 0){
			while(num_bytes > (long)src->bytes_in_buffer){
				num_bytes -= (long) src->bytes_in_buffer;
				(void) fill_input_buffer(cinfo);
			}
			src->next_input_byte += (size_t) num_bytes;
			src->bytes_in_buffer -= (size_t) num_bytes;
		}
	}

	static void term_source(j_decompress_ptr)
	{
	}

};

static void kvi_readJpegImage(QImageIO* iio)
{
	QImage theImage;
	struct jpeg_decompress_struct jds;
	struct KviJpegSourceManager *pSourceMgr = new KviJpegSourceManager(iio);
	struct KviJpegErrorManager jErrorMgr;
	// Initialize decompression
	jpeg_create_decompress(&jds);
	jds.src = pSourceMgr;
	jds.err = jpeg_std_error(&jErrorMgr);
	// Set out error exit struct
	jErrorMgr.error_exit = kvi_jpegErrorExit;
	// Now setjmp...
	if (!setjmp(jErrorMgr.setjmp_buffer)){
		// Ok...first call of setjmp...this is not an error
		(void)jpeg_read_header(&jds, TRUE); //Read the header
		(void)jpeg_start_decompress(&jds);  //and begin decompression
		// Adjust our image
		if((jds.output_components == 3)||(jds.output_components == 4)){
			// Always convert to 32bpp
			theImage.create(jds.output_width,jds.output_height,32);
		} else if(jds.output_components == 1){
			// 256 colors... grayscale
			theImage.create(jds.output_width,jds.output_height,8,256);
			for(int i=0;i<256;i++)theImage.setColor(i,qRgb(i,i,i));
		} // else Unsupported format ... leave theImage null.

		if(!theImage.isNull()){
			// Supported format
			unsigned char ** lines = theImage.jumpTable();
			while(jds.output_scanline < jds.output_height){
				(void)jpeg_read_scanlines(&jds,lines + jds.output_scanline,jds.output_height);
			}
			(void)jpeg_finish_decompress(&jds);
		}

		if(jds.output_components == 3){
			// Expand 24->32 bpp.
			for(uint j=0;j<jds.output_height;j++){
				uchar *in = theImage.scanLine(j) + jds.output_width * 3;
				QRgb *outBuf = (QRgb*)theImage.scanLine(j);
				for(uint i=jds.output_width;i--; ){
					in-=3;
					outBuf[i] = qRgb(in[0],in[1],in[2]);
				}
			}
		}
		iio->setImage(theImage);
		iio->setStatus(0);
	}

	jpeg_destroy_decompress(&jds);
	delete pSourceMgr;
}


static void kvi_writeJpegDummy(QImageIO* iio){}

void kvi_initJpegIo()
{
	QImageIO::defineIOHandler("JPEG", "^\377\330\377", 0, kvi_readJpegImage,kvi_writeJpegDummy);
}

#else // Internal JPEG support disabled; Qt may have its own support.
void kvi_initJpegIo()
{
	// Dummy...not used...
}
#endif
