//
//   File : kvi_imagefiledialog.cpp (/usr/build/NEW_kvirc/kvirc/src/kvilib/kvi_imagefiledialog.cpp)
//   Last major modification : Wed Mar 24 1999 13:41:47 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
#include "kvi_string.h"
#include "kvi_imagefiledialog.h"
#include "kvi_locale.h"
#include <qpixmap.h>


KviImageFilePreviewWidget::KviImageFilePreviewWidget(const QString &text,QWidget * parent)
:QLabel(text,parent)
{
	setFrameStyle(QFrame::Panel|QFrame::Sunken);
	setAlignment(AlignCenter);
	setMaximumWidth(400);
	setMaximumHeight(400);
}

KviImageFilePreviewWidget::~KviImageFilePreviewWidget()
{
}

void KviImageFilePreviewWidget::showPreview(const QString & str)
{
	QPixmap pix(str);
	if(pix.isNull())setText(_CHAR_2_QSTRING(__tr("Unrecognized image format")));
	else setPixmap(pix);
}

KviImageFileDialog::KviImageFileDialog(const QString& startFileName, const QString& filter,
		 QWidget *parent,const char *name,bool modal)
:QFileDialog(QString::null,filter,parent,name,modal)
{
	setCaption(_CHAR_2_QSTRING(__tr("Select image...")));
	setMode(QFileDialog::ExistingFile);
	KviImageFilePreviewWidget * im = new KviImageFilePreviewWidget(__tr("Preview"),this);
	addRightWidget(im);
	connect(this,SIGNAL(fileHighlighted(const QString &)),im,SLOT(showPreview(const QString &)));
	setSelection(startFileName);
}

KviImageFileDialog::~KviImageFileDialog()
{
}

#include "m_kvi_imagefiledialog.moc"
