//
//   File : kvi_buttons.cpp (/usr/build/NEW_kvirc/kvirc/kvilib/kvi_buttons.cpp)
//   Last major modification : Thu Jan 21 1999 19:15:27 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include "kvi_buttons.h"
#include "kvi_fileutils.h"
#include "kvi_msgbox.h"
#include "kvi_fontdialog.h"
#include "kvi_colordialog.h"
#include "kvi_imagefiledialog.h"
#include "kvi_locale.h"

#include "kvi_settings.h"

#include <qpixmap.h>
#include <qpalette.h>
#include <qpainter.h>

//=============================================================================
//
// ### KviFontButton ###
//
//=============================================================================

KviFontButton::KviFontButton(QWidget *parent,const QFont &f)
:QPushButton(parent)
{
	setFont(f);
	setText(f.family());
	connect(this,SIGNAL(clicked()),this,SLOT(slot_buttonClicked()));
}

KviFontButton::~KviFontButton(){}

void KviFontButton::slot_buttonClicked()
{
	QFont f(font());
	if(kvi_selectFont(f))
	{
		setFont(f);
		setText(f.family());
	} // else cancelled
}

const QFont KviFontButton::getSelectedFont()
{
	return font();
}

//=============================================================================
//
// ### KviColorButton ###
//
//=============================================================================

KviColorButton::KviColorButton(QWidget *parent,const QColor &clr)
:QPushButton(parent)
{
	setColor(clr);
	connect(this,SIGNAL(clicked()),this,SLOT(slot_buttonClicked()));
}

KviColorButton::~KviColorButton(){}
void KviColorButton::setColor(const QColor &clr)
{
	m_color = clr;
	update();
}

void KviColorButton::slot_buttonClicked()
{
	QColor sel = m_color;
	if(kvi_selectColor(sel))setColor(sel);
	// else cancelled
}

void KviColorButton::drawButtonLabel(QPainter * paint)
{
	paint->setPen(isEnabled() ? QColor(0,0,0) : QColor(120,120,120));
	paint->drawRect(3,3,width() - 6,height() - 6);
	if(isEnabled())paint->fillRect(4,4,width() - 8,height() - 8,m_color);
}

//=============================================================================
//
// ### KviImageButton ###
//
//=============================================================================

KviImageButton::KviImageButton(QWidget *parent,const char *szImagePath,QPixmap * cachedPixmap)
:QPushButton(parent)
{
	connect(this,SIGNAL(clicked()),this,SLOT(slot_buttonClicked()));
	m_szImagePath = "";
	if(szImagePath){
		if(*szImagePath){
			if(cachedPixmap){
				if(!cachedPixmap->isNull()){
					m_szImagePath = szImagePath;
					setPixmap(*cachedPixmap);
				}
			} else tryLoadImage(szImagePath);
		}
	}
}

KviImageButton::~KviImageButton(){}

void KviImageButton::slot_buttonClicked()
{
	KviImageFileDialog aDlg(m_szImagePath.hasData() ? _CHAR_2_QSTRING(m_szImagePath.ptr()) : QString::null,"*");
	if(aDlg.exec()){
		KviStr szPath(aDlg.selectedFile());
		if(szPath.hasData())tryLoadImage(szPath.m_ptr);
	}
}

void KviImageButton::tryLoadImage(const char *szImagePath)
{
	QPixmap pm(szImagePath);
	if(!pm.isNull()){
		m_szImagePath = szImagePath;
		setPixmap(pm);
		return;
	}

	debug(__tr("Could not load the image %s\nInvalid image format or permission denied"),szImagePath);
// this makes Qt crash : 
// Qt enters in a local_loop and sends a resize event 
// to the parent of this KviImageButton
// that is a KviImageSelector and has a reference to 
// this widget in the resizeEvent handler
// the pointer is not set yet , since new has not returned yet

//KviImageSelector::KviImageSelector(QWidget *parent,QTabDialog * tab,KviStr *valuePtr,
//		const char * label)
//:QWidget(parent)
//{
// [...]
//	m_pImgButton = new KviImageButton(this,valuePtr->ptr()); <--- the warning box fires inside this constructor
// [...]
//}
//
// .. a resize event arrives
//
//void KviImageSelector::resizeEvent(QResizeEvent *)
//{
// [...]
//	m_pImgButton->setGeometry(0,hght+1,width(),height() - (hght+1)); <---m_pImgButton is not defined yet
//}

//	kvi_warningBox(__tr("WARNING"),szIm.ptr()); 
}

#include "m_kvi_buttons.moc"
