#ifndef _KVI_NETUTILS_H_INCLUDED_
#define _KVI_NETUTILS_H_INCLUDED_

//
//   File : kvi_netutlis.h (/usr/build/NEW_kvirc/kvirc/kvicore/kvi_netutlis.h)
//   Last major modification : Mon Jan 11 1999 21:04:27 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h> //in_addr
#include <arpa/inet.h>  //inet_ntoa inet_ntop and inet_pton depend on this one.

#include "kvi_string.h"

#ifdef _KVI_NETUTLIS_CPP_
	#define __kvi_extern
#else
	#define __kvi_extern extern
#endif

#include "kvi_settings.h"

#ifdef kvi_socklen_t
	#define _this_should_be_socklen_t kvi_socklen_t
#else
	#define _this_should_be_socklen_t int
#endif


/**
* Returns true if szIp points to a string that contains a valid ip in numbers and dots notation.
*/
__kvi_extern bool kvi_isValidStringIp(const char *szIp);

#ifdef COMPILE_NEED_IPV6
	__kvi_extern bool kvi_isValidStringIp_V6(const char *szIp);
	__kvi_extern bool kvi_binaryIpToString_V6(struct in6_addr in,KviStr &szBuffer);
	__kvi_extern bool kvi_stringIpToBinaryIp_V6(const char *szIp,struct in6_addr *address);
#endif

/**
* Interface to inet_aton<br>
* Returns true if kvi_isValidStringIp(szIp)<br>
* Sets address to the network byte order ip binary data.
*/
__kvi_extern bool kvi_stringIpToBinaryIp(const char *szIp,struct in_addr *address);
/**
* Substitution for inet_ntoa
* The address must be in network byte order!
*/
__kvi_extern bool kvi_binaryIpToString(struct in_addr in,KviStr &szBuffer);

#endif //!_KVI_NETUTILS_H_INCLUDED_
