/***************************************************************************
 *   Copyright (C) 2006 by Raul Fernandes                                  *
 *   rgfbr@yahoo.com.br                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "dictionariessettings.h"
#include "ktranslatordictionary.h"
#include "ktranslatordictionarymanager.h"
#include "config.h"

#include <qlistbox.h>
#include <qpushbutton.h>
#include <qvbox.h>
#include <qlabel.h>

#include <klocale.h>
#include <kpassivepopup.h>

DictionariesSettings::DictionariesSettings( KTranslatorDictionaryManager *manager, QWidget* parent, const char* name, WFlags fl )
 : DictionariesSettingsBase( parent, name, fl )
{
   plugins = manager;
   //dictionaries->dicList->addColumn( "Dictionaries" );
   for( KTranslatorDictionary *dic = plugins->list.first(); dic; dic = plugins->list.next() )
   {
     dicList->insertItem( dic->name() );
   }
   connect( addButton, SIGNAL( clicked() ), this, SLOT( addDictionary() ) );
   connect( editButton, SIGNAL( clicked() ), this, SLOT( editDictionary() ) );
   connect( removeButton, SIGNAL( clicked() ), this, SLOT( removeDictionary() ) );
   connect( upButton, SIGNAL( clicked() ), this, SLOT( moveDictionaryUp() ) );
   connect( downButton, SIGNAL( clicked() ), this, SLOT( moveDictionaryDown() ) );
   connect( dicList, SIGNAL( onItem( QListBoxItem * ) ), this, SLOT( showDicTip( QListBoxItem * ) ) );
   connect( dicList, SIGNAL( onViewport() ), this, SLOT( hideDicTip() ) );

   // Tooltip for dictionaries
   dicPopup = new KPassivePopup( dicList );
   QVBox *vb = new QVBox( dicPopup, "box" );
   (void) new QLabel( vb, "label" );
   dicPopup->setView( vb );
   dicPopup->setPaletteBackgroundColor( config::backgroundColor() );
   dicPopup->setPaletteForegroundColor( config::definitionColor() );
}

DictionariesSettings::~DictionariesSettings()
{
}

void DictionariesSettings::addDictionary()
{
  // Add the dictionary
  plugins->addDictionary();

  dicList->clear();
  for( KTranslatorDictionary *dic = plugins->list.first(); dic; dic = plugins->list.next() )
  {
    dicList->insertItem( dic->name() );
  }
}


void DictionariesSettings::editDictionary()
{
  int item = dicList->currentItem();
  if( item == -1 ) return; // No item selected

  plugins->editDictionary( item );

  // Refresh the dictionary list
  dicList->clear();
  for( KTranslatorDictionary *dic = plugins->list.first(); dic; dic = plugins->list.next() )
  {
    dicList->insertItem( dic->name() );
  }
}


void DictionariesSettings::removeDictionary()
{
  int item = dicList->currentItem();
  if( item == -1 ) return; // No item selected

  // Remove the dictionary
  plugins->removeDictionary( item );

  // Refresh the dictionary list
  dicList->clear();
  for( KTranslatorDictionary *dic = plugins->list.first(); dic; dic = plugins->list.next() )
  {
    dicList->insertItem( dic->name() );
  }
}

void DictionariesSettings::moveDictionaryUp()
{
  int item = dicList->currentItem();
  if( item == 0 ) return;

  // Move the dictionary up
  plugins->moveDictionary( item, true );

  // Refresh the dictionary list
  dicList->clear();
  for( KTranslatorDictionary *dic = plugins->list.first(); dic; dic = plugins->list.next() )
  {
    dicList->insertItem( dic->name() );
  }
  dicList->setSelected( item - 1, true );
}

void DictionariesSettings::moveDictionaryDown()
{
  int item = dicList->currentItem();
  if( item == dicList->numRows() - 1 ) return;

  // Move the dictionary down
  plugins->moveDictionary( item, false );

  // Refresh the dictionary list
  dicList->clear();
  for( KTranslatorDictionary *dic = plugins->list.first(); dic; dic = plugins->list.next() )
  {
    dicList->insertItem( dic->name() );
  }
  dicList->setSelected( item + 1, true );
}


void DictionariesSettings::showDicTip( QListBoxItem *i )
{
  int item = dicList->index( i );

  QLabel *label = (QLabel *)(dicPopup->child( "box" )->child( "label" ));
  label->setText( plugins->list.at( item )->plugin->tooltip() );
  dicPopup->resize( sizeHint() );
  dicPopup->show();
}


void DictionariesSettings::hideDicTip()
{
  dicPopup->hide();
}
