/***************************************************************************
                          qsoinfo.h  -  description
                             -------------------
    begin                : Sat Oct 7 2000
    copyright            : (C) 2000 by Luc Langehegermann
    email                : lx2gt@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef QSOINFO_H
#define QSOINFO_H

#include <qwidget.h>
#include <qtimer.h>
#include <qlistview.h>
#include <kdialogbase.h>
#include <qlabel.h>
#include "logcore.h"

/**
  *@author Luc Langehegermann
  */

class QSOInfo : public KDialogBase  {
   Q_OBJECT
public: 
	QSOInfo(QWidget *parent=0);
	~QSOInfo();
  /**  */
  void insertQSO (QString rsts, QString rstr, QString date, QString time, QString band);
  /**  */
  void clearqso();
  /**  */
  void setInfo (s_dxcc _dxcc);
private:
  QListView* infoview;
	QLabel*	prefixlabel;
	QLabel*	countrylabel;
	QLabel* continentlabel;
	QLabel* itu_zonelabel;
	QLabel* cq_zonelabel;
	QLabel* distancelabel;
	QLabel* directionlabel;
	QLabel* timelabel;
private: // Private methods
  /**  */
	QTimer* timer;
  void displayInfo();
	double safe_acos(double a);
	double norm_course(double a);
	void loc_to_sec(const char* loc, long *longitude, long *latitude);
  /**  */
  void calculate(QString* dist, QString* dir);
  /** No descriptions */
  void clearInfo ();

	/* ----------------------------------- */

	QString prefix;
	QString country;
	QString continent;
	QString itu_zone;
	QString cq_zone;
  QString time_zone;
	QString distance;
	QString direction;
	long mylongitude;
	long mylatitude;
	long hislongitude;
	long hislatitude;
	int timediff;
private slots: // Private slots
private slots: // Private slots
  /**  */
  void slotBye();
  /**  */
  void slotUpdateTime();
};

  /**  */
  void slotBye();
#endif
